/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.InterceptionSupport;
import io.helidon.service.codegen.TypedElements;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class DescribedElements {
    private final Set<ElementSignature> interceptedMethods;
    private final Set<ElementSignature> plainMethods;
    private final List<TypedElements.ElementMeta> allElements;
    private final List<TypedElements.ElementMeta> interceptedElements;
    private final List<TypedElements.ElementMeta> plainElements;
    private final boolean intercepted;
    private final boolean methodIntercepted;
    private final boolean constructorIntercepted;

    private DescribedElements(Set<ElementSignature> interceptedMethods, Set<ElementSignature> plainMethods, List<TypedElements.ElementMeta> allElements, List<TypedElements.ElementMeta> interceptedElements, List<TypedElements.ElementMeta> plainElements, boolean isIntercepted, boolean methodsIntercepted, boolean constructorIntercepted) {
        this.interceptedMethods = interceptedMethods;
        this.plainMethods = plainMethods;
        this.allElements = allElements;
        this.interceptedElements = interceptedElements;
        this.plainElements = plainElements;
        this.intercepted = isIntercepted;
        this.methodIntercepted = methodsIntercepted;
        this.constructorIntercepted = constructorIntercepted;
    }

    static DescribedElements create(CodegenContext ctx, InterceptionSupport interception, Collection<ResolvedType> contracts, TypeInfo serviceTypeInfo) {
        List<TypedElements.ElementMeta> all = TypedElements.gatherElements(ctx, contracts, serviceTypeInfo).stream().collect(Collectors.toUnmodifiableList());
        Set allMethods = all.stream().map(TypedElements.ElementMeta::element).filter(ElementInfoPredicates::isMethod).map(rec$ -> ((TypedElementInfo)rec$).signature()).collect(Collectors.toUnmodifiableSet());
        List<TypedElements.ElementMeta> intercepted = interception.interception().maybeIntercepted(serviceTypeInfo, all);
        Set<ElementSignature> interceptedMethods = intercepted.stream().map(TypedElements.ElementMeta::element).filter(ElementInfoPredicates::isMethod).map(rec$ -> ((TypedElementInfo)rec$).signature()).collect(Collectors.toUnmodifiableSet());
        List<TypedElements.ElementMeta> plain = all.stream().filter(it -> !interceptedMethods.contains(it.element().signature())).collect(Collectors.toUnmodifiableList());
        Set<ElementSignature> plainSignatures = allMethods.stream().filter(it -> !interceptedMethods.contains(it)).collect(Collectors.toUnmodifiableSet());
        boolean methodsIntercepted = intercepted.stream().map(TypedElements.ElementMeta::element).anyMatch(ElementInfoPredicates::isMethod);
        boolean constructorIntercepted = intercepted.stream().map(TypedElements.ElementMeta::element).anyMatch(ElementInfoPredicates::isConstructor);
        boolean isIntercepted = !intercepted.isEmpty();
        return new DescribedElements(interceptedMethods, plainSignatures, all, intercepted, plain, isIntercepted, methodsIntercepted, constructorIntercepted);
    }

    public String toString() {
        return "intercepted (" + this.interceptedElements.size() + "), plain (" + this.plainElements.size() + ")";
    }

    public Set<ElementSignature> interceptedMethods() {
        return this.interceptedMethods;
    }

    public Set<ElementSignature> plainMethods() {
        return this.plainMethods;
    }

    public List<TypedElements.ElementMeta> allElements() {
        return this.allElements;
    }

    public List<TypedElements.ElementMeta> interceptedElements() {
        return this.interceptedElements;
    }

    public List<TypedElements.ElementMeta> plainElements() {
        return this.plainElements;
    }

    public boolean intercepted() {
        return this.intercepted;
    }

    public boolean methodsIntercepted() {
        return this.methodIntercepted;
    }

    public boolean constructorIntercepted() {
        return this.constructorIntercepted;
    }
}

