/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.CoreTypeConstants;
import io.helidon.service.codegen.RegistryCodegenContext;

class CoreDependency {
    private final TypedElementInfo constructor;
    private final TypeName typeName;
    private final TypeName contract;
    private final String name;
    private final String dependencyConstant;
    private final String contractTypeConstant;
    private final String genericTypeConstant;
    private final String typeNameConstant;

    CoreDependency(TypedElementInfo constructor, TypeName typeName, TypeName contract, String name, String dependencyConstant, String contractTypeConstant, String genericTypeConstant, String typeNameConstant) {
        this.constructor = constructor;
        this.typeName = typeName;
        this.contract = contract;
        this.name = name;
        this.dependencyConstant = dependencyConstant;
        this.contractTypeConstant = contractTypeConstant;
        this.genericTypeConstant = genericTypeConstant;
        this.typeNameConstant = typeNameConstant;
    }

    static CoreDependency create(RegistryCodegenContext ctx, TypedElementInfo constructor, TypedElementInfo parameter, CoreTypeConstants constants, int index) {
        String dependencyConstant = "PARAM_" + index;
        TypeName paramTypeName = parameter.typeName();
        TypeName contract = CoreDependency.contract(parameter, paramTypeName, false, false, false);
        String contractConstant = constants.typeNameConstant(ResolvedType.create((TypeName)contract));
        String dependencyGenericTypeConstant = constants.genericTypeConstant(ResolvedType.create((TypeName)paramTypeName));
        String typeNameConstant = constants.typeNameConstant(ResolvedType.create((TypeName)paramTypeName));
        String paramName = parameter.elementName();
        return new CoreDependency(constructor, paramTypeName, contract, paramName, dependencyConstant, contractConstant, dependencyGenericTypeConstant, typeNameConstant);
    }

    public String typeNameConstant() {
        return this.typeNameConstant;
    }

    TypeName typeName() {
        return this.typeName;
    }

    TypeName contract() {
        return this.contract;
    }

    String name() {
        return this.name;
    }

    String dependencyConstant() {
        return this.dependencyConstant;
    }

    String contractTypeConstant() {
        return this.contractTypeConstant;
    }

    String genericTypeConstant() {
        return this.genericTypeConstant;
    }

    TypedElementInfo constructor() {
        return this.constructor;
    }

    private static TypeName contract(TypedElementInfo parameter, TypeName typeName, boolean isList, boolean isOptional, boolean isSupplier) {
        String allowed = "Dependency can be only declared as either of: Contract, Optional<Contract>, List<Contract>, Supplier<Contract>, Supplier<Optional<Contract>, Supplier<List<Contract>>";
        if (typeName.isOptional()) {
            if (isList || isOptional) {
                throw new CodegenException(allowed, parameter.originatingElementValue());
            }
            if (typeName.typeArguments().isEmpty()) {
                throw new CodegenException("Dependency with Optional type must have a declared type argument.", parameter.originatingElementValue());
            }
            return CoreDependency.contract(parameter, (TypeName)typeName.typeArguments().getFirst(), false, true, isSupplier);
        }
        if (typeName.isList()) {
            if (isList || isOptional) {
                throw new CodegenException(allowed, parameter.originatingElementValue());
            }
            if (typeName.typeArguments().isEmpty()) {
                throw new CodegenException("Dependency with List type must have a declared type argument.", parameter.originatingElementValue());
            }
            return CoreDependency.contract(parameter, (TypeName)typeName.typeArguments().getFirst(), true, false, isSupplier);
        }
        if (typeName.isSupplier()) {
            if (isSupplier || isOptional || isList) {
                throw new CodegenException(allowed, parameter.originatingElementValue());
            }
            if (typeName.typeArguments().isEmpty()) {
                throw new CodegenException("Dependency with Supplier type must have a declared type argument.", parameter.originatingElementValue());
            }
            return CoreDependency.contract(parameter, (TypeName)typeName.typeArguments().getFirst(), isList, isOptional, true);
        }
        return typeName;
    }
}

