/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.CodegenHelper;
import io.helidon.service.codegen.DescribedElements;
import io.helidon.service.codegen.InterceptedTypeGenerator;
import io.helidon.service.codegen.Interception;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.TypedElements;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class InterceptionSupport {
    private static final TypeName GENERATOR = TypeName.create(InterceptionSupport.class);
    private static final TypeName DESCRIPTOR_TYPE = ((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.SERVICE_DESCRIPTOR).addTypeArgument(TypeName.create((String)"?"))).build();
    private static final String INTERCEPT_META_PARAM = "interceptMeta";
    private static final String DESCRIPTOR_PARAM = "descriptor";
    private static final String TYPE_ANNOTATIONS_FIELD = "ANNOTATIONS";
    private static final String DELEGATE_PARAM = "delegate";
    private final RegistryCodegenContext ctx;
    private final Interception interception;

    InterceptionSupport(RegistryCodegenContext ctx, Interception interception) {
        this.ctx = ctx;
        this.interception = interception;
    }

    Interception interception() {
        return this.interception;
    }

    TypeName generateDelegateInterception(RegistryRoundContext roundContext, TypeInfo typeInfo, TypeName interceptedType, String packageName) {
        boolean samePackage = packageName.equals(interceptedType.packageName());
        List<TypedElements.ElementMeta> elementMetas = this.interception.maybeIntercepted(typeInfo);
        HashSet interceptedSignatures = new HashSet();
        elementMetas.stream().map(TypedElements.ElementMeta::element).peek(it -> {
            if (samePackage) {
                return;
            }
            if (it.accessModifier() != AccessModifier.PUBLIC) {
                throw new CodegenException("Cannot generate interception delegate for a non-public method when the delegate is in a different package", it.originatingElementValue());
            }
        }).map(rec$ -> ((TypedElementInfo)rec$).signature()).forEach(interceptedSignatures::add);
        List<TypedElementInfo> otherMethods = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> {
            if (samePackage) {
                return true;
            }
            return ElementInfoPredicates.isPublic((TypedElementInfo)it);
        }).filter(it -> !interceptedSignatures.contains(it.signature())).collect(Collectors.toUnmodifiableList());
        TypeName generatedType = this.interceptedDelegateType(interceptedType);
        generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(generatedType)).packageName(packageName)).build();
        if (typeInfo.kind() == ElementKind.INTERFACE) {
            return this.generateInterceptionDelegateInterface(roundContext, typeInfo, interceptedType, generatedType, elementMetas, otherMethods);
        }
        return this.generateInterceptionDelegateClass(roundContext, typeInfo, interceptedType, generatedType, elementMetas, otherMethods);
    }

    TypeName interceptedDelegateType(TypeName interfaceType) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(interfaceType.packageName())).className(interfaceType.classNameWithEnclosingNames().replace('.', '_') + "__InterceptedDelegate")).build();
    }

    void generateDelegateInterception(RegistryRoundContext roundContext, TypeInfo typeInfo, DescribedElements describedElements, TypeName interceptionDelegateType) {
        TypeName interceptedTypeName = typeInfo.typeName();
        boolean samePackage = interceptedTypeName.packageName().equals(interceptionDelegateType.packageName());
        describedElements.interceptedElements().stream().forEach(it -> {
            if (ElementInfoPredicates.isStatic((TypedElementInfo)it.element())) {
                throw new CodegenException("Interception of static methods is not possible", it.element().originatingElementValue());
            }
            if (it.element().accessModifier() == AccessModifier.PRIVATE) {
                throw new CodegenException("Cannot generate interception delegate for a private method: ", it.element().originatingElementValue());
            }
            if (samePackage) {
                return;
            }
            EnumSet<AccessModifier> allowedModifiers = EnumSet.of(AccessModifier.PUBLIC);
            if (typeInfo.kind() == ElementKind.CLASS) {
                allowedModifiers.add(AccessModifier.PROTECTED);
            }
            if (!allowedModifiers.contains(it.element().accessModifier())) {
                throw new CodegenException("Cannot generate interception delegate for a method that is not public or protected, when the delegate is in a different package than the intercepted type intercepted type: " + interceptedTypeName.fqName() + ", delegate: " + interceptionDelegateType.fqName(), it.element().originatingElementValue());
            }
        });
        List<TypedElements.ElementMeta> interceptedMethods = describedElements.interceptedElements().stream().collect(Collectors.toUnmodifiableList());
        List<TypedElementInfo> plainSignatures = describedElements.plainElements().stream().map(TypedElements.ElementMeta::element).filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> {
            if (samePackage) {
                return true;
            }
            return ElementInfoPredicates.isPublic((TypedElementInfo)it);
        }).collect(Collectors.toUnmodifiableList());
        if (typeInfo.kind() == ElementKind.INTERFACE) {
            this.generateInterceptionDelegateInterface(roundContext, typeInfo, interceptedTypeName, interceptionDelegateType, interceptedMethods, plainSignatures);
        } else {
            this.generateInterceptionDelegateClass(roundContext, typeInfo, interceptedTypeName, interceptionDelegateType, interceptedMethods, plainSignatures);
        }
    }

    private TypeName generateInterceptionDelegateClass(RegistryRoundContext roundContext, TypeInfo typeInfo, TypeName classType, TypeName generatedType, List<TypedElements.ElementMeta> elementMetas, List<TypedElementInfo> otherMethods) {
        Optional<TypedElementInfo> foundCtr = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isConstructor).filter(ElementInfoPredicates.hasParams((TypeName[])new TypeName[0])).filter(Predicate.not(ElementInfoPredicates::isPrivate)).findFirst();
        if (foundCtr.isEmpty()) {
            throw new CodegenException("Interception delegate requires accessible no-arg constructor.", typeInfo.originatingElementValue());
        }
        List<InterceptedTypeGenerator.MethodDefinition> definitions = InterceptedTypeGenerator.MethodDefinition.toDefinitions(this.ctx, typeInfo, elementMetas);
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE).superType(classType)).type(generatedType).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)classType, (TypeName)generatedType)).description("Intercepted class implementation, that delegates to the provided instance.")).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)classType, (TypeName)generatedType, (String)"", (String)""));
        CodegenHelper.annotationsField(classModel, typeInfo);
        InterceptedTypeGenerator.generateElementInfoFields(classModel, definitions);
        InterceptedTypeGenerator.generateInvokerFields(classModel, definitions);
        InterceptedTypeGenerator.generateInterceptedMethods(classModel, definitions);
        this.generateOtherMethods(classModel, otherMethods);
        classModel.addField(delegate -> ((Field.Builder)delegate.name(DELEGATE_PARAM)).accessModifier(AccessModifier.PRIVATE).isFinal(true).type(classType));
        classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.accessModifier(AccessModifier.PRIVATE)).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name(INTERCEPT_META_PARAM))).addParameter(descriptor -> descriptor.type(DESCRIPTOR_TYPE).name(DESCRIPTOR_PARAM))).addParameter(delegate -> delegate.type(classType).name(DELEGATE_PARAM))).addContentLine("// no-arg constructor is required for delegation")).addContentLine("super();")).addContentLine("")).addContent("this.")).addContent(DELEGATE_PARAM)).addContent(" = ")).addContent(DELEGATE_PARAM)).addContentLine(";")).update(it -> InterceptedTypeGenerator.createInvokers(it, DESCRIPTOR_TYPE, definitions, false, INTERCEPT_META_PARAM, DESCRIPTOR_PARAM, "descriptor.qualifiers()", TYPE_ANNOTATIONS_FIELD, DELEGATE_PARAM)));
        classModel.addMethod(create -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)create.accessModifier(AccessModifier.PACKAGE_PRIVATE)).isStatic(true).returnType(classType).name("create")).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name(INTERCEPT_META_PARAM))).addParameter(descriptor -> descriptor.type(DESCRIPTOR_TYPE).name(DESCRIPTOR_PARAM))).addParameter(delegate -> delegate.type(classType).name(DELEGATE_PARAM))).addContent("return new ")).addContent(generatedType)).addContent("(")).addContent(INTERCEPT_META_PARAM)).addContentLine(",")).increaseContentPadding()).increaseContentPadding()).addContent(DESCRIPTOR_PARAM)).addContentLine(",")).addContent(DELEGATE_PARAM)).addContentLine(");"));
        roundContext.addGeneratedType(generatedType, classModel, classType, new Object[]{typeInfo.originatingElementValue()});
        return generatedType;
    }

    private TypeName generateInterceptionDelegateInterface(RegistryRoundContext roundContext, TypeInfo typeInfo, TypeName interfaceType, TypeName generatedType, List<TypedElements.ElementMeta> elementMetas, List<TypedElementInfo> otherMethods) {
        List<InterceptedTypeGenerator.MethodDefinition> definitions = InterceptedTypeGenerator.MethodDefinition.toDefinitions(this.ctx, typeInfo, elementMetas);
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE).addInterface(interfaceType)).type(generatedType).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)interfaceType, (TypeName)generatedType)).description("Intercepted interface implementation, that delegates to the provided instance.")).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)interfaceType, (TypeName)generatedType, (String)"", (String)""));
        CodegenHelper.annotationsField(classModel, typeInfo);
        InterceptedTypeGenerator.generateElementInfoFields(classModel, definitions);
        InterceptedTypeGenerator.generateInvokerFields(classModel, definitions);
        InterceptedTypeGenerator.generateInterceptedMethods(classModel, definitions);
        this.generateOtherMethods(classModel, otherMethods);
        classModel.addField(delegate -> ((Field.Builder)delegate.name(DELEGATE_PARAM)).accessModifier(AccessModifier.PRIVATE).isFinal(true).type(interfaceType));
        classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.accessModifier(AccessModifier.PRIVATE)).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name(INTERCEPT_META_PARAM))).addParameter(descriptor -> descriptor.type(DESCRIPTOR_TYPE).name(DESCRIPTOR_PARAM))).addParameter(delegate -> delegate.type(interfaceType).name(DELEGATE_PARAM))).addContent("this.")).addContent(DELEGATE_PARAM)).addContent(" = ")).addContent(DELEGATE_PARAM)).addContentLine(";")).update(it -> InterceptedTypeGenerator.createInvokers(it, DESCRIPTOR_TYPE, definitions, false, INTERCEPT_META_PARAM, DESCRIPTOR_PARAM, "descriptor.qualifiers()", TYPE_ANNOTATIONS_FIELD, DELEGATE_PARAM)));
        classModel.addMethod(create -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)create.accessModifier(AccessModifier.PACKAGE_PRIVATE)).isStatic(true).returnType(interfaceType).name("create")).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name(INTERCEPT_META_PARAM))).addParameter(descriptor -> descriptor.type(DESCRIPTOR_TYPE).name(DESCRIPTOR_PARAM))).addParameter(delegate -> delegate.type(interfaceType).name(DELEGATE_PARAM))).addContent("return new ")).addContent(generatedType)).addContent("(")).addContent(INTERCEPT_META_PARAM)).addContentLine(",")).increaseContentPadding()).increaseContentPadding()).addContent(DESCRIPTOR_PARAM)).addContentLine(",")).addContent(DELEGATE_PARAM)).addContentLine(");"));
        roundContext.addGeneratedType(generatedType, classModel, interfaceType, new Object[]{typeInfo.originatingElementValue()});
        return generatedType;
    }

    private void generateOtherMethods(ClassModel.Builder classModel, List<TypedElementInfo> otherMethods) {
        for (TypedElementInfo info : otherMethods) {
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).name(info.elementName())).accessModifier(info.accessModifier())).name(info.elementName())).returnType(info.typeName()).update(it -> info.parameterArguments().forEach(arg -> it.addParameter(param -> param.type(arg.typeName()).name(arg.elementName()))))).update(it -> {
                for (TypeName checkedException : info.throwsChecked()) {
                    it.addThrows(checkedException, "");
                }
            })).update(it -> {
                if (!info.typeName().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                    it.addContent("return ");
                }
                ((Method.Builder)((Method.Builder)((Method.Builder)it.addContent(DELEGATE_PARAM)).addContent(".")).addContent(info.elementName())).addContent("(");
                it.addContent(info.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).elementName()).collect(Collectors.joining(", ")));
                it.addContentLine(");");
            }));
        }
    }
}

