/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenOptions;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.service.codegen.Interception;
import io.helidon.service.codegen.InterceptionStrategy;
import io.helidon.service.codegen.InterceptionSupport;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.ServiceDescriptorCodegen;
import io.helidon.service.codegen.ServiceOptions;
import io.helidon.service.codegen.spi.InjectCodegenObserver;
import io.helidon.service.codegen.spi.InjectCodegenObserverProvider;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class ServiceExtension
implements RegistryCodegenExtension {
    private final RegistryCodegenContext ctx;
    private final InterceptionSupport interceptionSupport;
    private final List<InjectCodegenObserver> observers;
    private final ServiceDescriptorCodegen descriptorCodegen;

    ServiceExtension(RegistryCodegenContext codegenContext, List<InjectCodegenObserverProvider> observerProviders) {
        this.ctx = codegenContext;
        this.observers = observerProviders.stream().map(it -> it.create(codegenContext)).toList();
        CodegenOptions options = this.ctx.options();
        Interception interception = new Interception((InterceptionStrategy)((Object)ServiceOptions.INTERCEPTION_STRATEGY.value(options)));
        this.interceptionSupport = new InterceptionSupport(this.ctx, interception);
        this.descriptorCodegen = new ServiceDescriptorCodegen(this.ctx, this.observers, this.interceptionSupport);
    }

    @Override
    public void process(RegistryRoundContext roundCtx) {
        Collection descriptorsRequired = roundCtx.types();
        for (TypeInfo typeInfo : descriptorsRequired) {
            if (typeInfo.hasAnnotation(ServiceCodegenTypes.INTERCEPTION_EXTERNAL_DELEGATE)) {
                this.generateInterceptionExternalDelegates(roundCtx, typeInfo);
            }
            if (typeInfo.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_DESCRIBE)) {
                this.descriptorCodegen.describe(roundCtx, typeInfo, typeInfo.annotation(ServiceCodegenTypes.SERVICE_ANNOTATION_DESCRIBE));
                continue;
            }
            this.descriptorCodegen.service(roundCtx, descriptorsRequired, typeInfo);
        }
        this.notifyObservers(roundCtx, descriptorsRequired);
    }

    private void generateInterceptionExternalDelegates(RegistryRoundContext roundContext, TypeInfo typeInfo) {
        Annotation annotation = typeInfo.annotation(ServiceCodegenTypes.INTERCEPTION_EXTERNAL_DELEGATE);
        List typeNames = annotation.typeValues().orElseGet(List::of);
        for (TypeName typeName : typeNames) {
            TypeInfo delegateType = (TypeInfo)this.ctx.typeInfo(typeName).orElseThrow(() -> new CodegenException("Cannot resolve type " + typeName.fqName() + " for  external interception delegates", typeInfo.originatingElementValue()));
            this.interceptionSupport.generateDelegateInterception(roundContext, delegateType, delegateType.typeName(), typeInfo.typeName().packageName());
        }
    }

    private void notifyObservers(RegistryRoundContext roundContext, Collection<TypeInfo> descriptorsRequired) {
        if (this.observers.isEmpty()) {
            return;
        }
        Set elements = descriptorsRequired.stream().flatMap(it -> it.elementInfo().stream()).collect(Collectors.toSet());
        this.observers.forEach(it -> it.onProcessingEvent(roundContext, elements));
    }
}

