/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.codegen.spi.CodegenExtensionProvider;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class ServiceBindingCodegenProvider
implements CodegenExtensionProvider {
    public static final String BINDING_CLASS_NAME = "ApplicationBinding";

    public Set<TypeName> supportedAnnotations() {
        return Set.of(ServiceCodegenTypes.SERVICE_ANNOTATION_GENERATE_BINDING);
    }

    public CodegenExtension create(CodegenContext ctx, TypeName generatorType) {
        return new ServiceBindingCodegen();
    }

    private static class ServiceBindingCodegen
    implements CodegenExtension {
        private static final TypeName GENERATOR = TypeName.create(ServiceBindingCodegen.class);
        private final List<BindingInfo> annotations = new ArrayList<BindingInfo>();

        private ServiceBindingCodegen() {
        }

        public void process(RoundContext roundContext) {
            roundContext.annotatedTypes(ServiceCodegenTypes.SERVICE_ANNOTATION_GENERATE_BINDING).stream().map(this::toInfo).forEach(this.annotations::add);
        }

        public void processingOver(RoundContext roundContext) {
            LinkedHashMap allAnnotatedTypes = new LinkedHashMap();
            this.annotations.forEach(it -> allAnnotatedTypes.put(it.declaringType, it));
            if (allAnnotatedTypes.isEmpty()) {
                return;
            }
            if (allAnnotatedTypes.size() > 1) {
                throw new CodegenException("Annotation " + String.valueOf(ServiceCodegenTypes.SERVICE_ANNOTATION_GENERATE_BINDING) + " can only be used once in an application. Found in: " + String.valueOf(allAnnotatedTypes.keySet()), ((BindingInfo)allAnnotatedTypes.values().iterator().next()).typeInfo.originatingElementValue());
            }
            BindingInfo first = this.annotations.getFirst();
            TypeName generatedType = first.generatedType();
            TypeName triggerType = first.typeInfo().typeName();
            String name = first.typeInfo().module().orElse("unnamed") + "/" + generatedType.packageName();
            ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).accessModifier(AccessModifier.PACKAGE_PRIVATE).superType(ServiceCodegenTypes.SERVICE_BINDING_EMPTY)).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)triggerType, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)triggerType, (TypeName)generatedType, (String)"1", (String)""))).addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.accessModifier(AccessModifier.PRIVATE)).addContent("super(\"")).addContent(name)).addContentLine("\");"))).addMethod(create -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)create.accessModifier(AccessModifier.PACKAGE_PRIVATE)).isStatic(true).returnType(generatedType).name("create")).addContent("return new ")).addContent(generatedType.className())).addContentLine("();"))).addMethod(configure -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)configure.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).name("configure")).addParameter(builder -> ((Parameter.Builder)builder.name("builder")).type(ServiceCodegenTypes.SERVICE_CONFIG_BUILDER))).addContentLine("warnEmpty();")).addContentLine("builder.discoverServices(true);")).addContentLine("builder.discoverServicesFromServiceLoader(true);"));
            roundContext.addGeneratedType(generatedType, classModel, first.declaringType(), new Object[]{first.typeInfo().originatingElementValue()});
        }

        private BindingInfo toInfo(TypeInfo typeInfo) {
            Annotation annotation = typeInfo.annotation(ServiceCodegenTypes.SERVICE_ANNOTATION_GENERATE_BINDING);
            TypeName declaringType = typeInfo.typeName();
            String className = annotation.value().orElse(ServiceBindingCodegenProvider.BINDING_CLASS_NAME);
            String packageName = annotation.stringValue("packageName").filter(it -> !it.equals("@default")).orElse(declaringType.packageName());
            return new BindingInfo(typeInfo, declaringType, ((TypeName.Builder)((TypeName.Builder)TypeName.builder().className(className)).packageName(packageName)).build());
        }
    }

    private record BindingInfo(TypeInfo typeInfo, TypeName declaringType, TypeName generatedType) {
    }
}

