/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.TypedElements;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class InterceptedTypeGenerator {
    public static final String INTERCEPT_META_PARAM = "helidonInject__interceptMeta";
    public static final String SERVICE_DESCRIPTOR_PARAM = "helidonInject__serviceDescriptor";
    public static final String TYPE_QUALIFIERS_PARAM = "helidonInject__typeQualifiers";
    public static final String TYPE_ANNOTATIONS_PARAM = "helidonInject__typeAnnotations";
    private static final TypeName GENERATOR = TypeName.create(InterceptedTypeGenerator.class);
    private static final TypeName RUNTIME_EXCEPTION_TYPE = TypeName.create(RuntimeException.class);
    private final TypeName serviceType;
    private final TypeName descriptorType;
    private final TypeName interceptedType;
    private final TypedElementInfo constructor;
    private final List<MethodDefinition> interceptedMethods;

    InterceptedTypeGenerator(RegistryCodegenContext ctx, TypeInfo typeInfo, TypeName serviceType, TypeName descriptorType, TypeName interceptedType, TypedElementInfo constructor, List<TypedElements.ElementMeta> interceptedMethods) {
        this.serviceType = serviceType;
        this.descriptorType = descriptorType;
        this.interceptedType = interceptedType;
        this.constructor = constructor;
        this.interceptedMethods = MethodDefinition.toDefinitions(ctx, typeInfo, interceptedMethods);
    }

    static void generateElementInfoFields(ClassModel.Builder classModel, List<MethodDefinition> interceptedMethods) {
        for (MethodDefinition interceptedMethod : interceptedMethods) {
            classModel.addField(methodField -> ((Field.Builder)methodField.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).type(TypeNames.TYPED_ELEMENT_INFO).name(interceptedMethod.constantName())).addContentCreate(interceptedMethod.info()));
        }
    }

    static void generateInvokerFields(ClassModel.Builder classModel, List<MethodDefinition> interceptedMethods) {
        for (MethodDefinition interceptedMethod : interceptedMethods) {
            classModel.addField(methodField -> methodField.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(InterceptedTypeGenerator.invokerType(interceptedMethod.info().typeName())).name(interceptedMethod.invokerName()));
        }
    }

    static void generateInterceptedMethods(ClassModel.Builder classModel, List<MethodDefinition> interceptedMethods) {
        for (MethodDefinition interceptedMethod : interceptedMethods) {
            TypedElementInfo info = interceptedMethod.info();
            String invoker = interceptedMethod.invokerName();
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).accessModifier(info.accessModifier())).name(info.elementName())).returnType(info.typeName()).update(it -> info.parameterArguments().forEach(arg -> it.addParameter(param -> param.type(arg.typeName()).name(arg.elementName()))))).update(it -> {
                if (!interceptedMethod.exceptionTypes().isEmpty()) {
                    for (TypeName exceptionType : interceptedMethod.exceptionTypes()) {
                        it.addThrows(exceptionType, "thrown by intercepted method");
                    }
                }
            })).update(it -> {
                String invokeLine = invoker + ".invoke(" + info.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).elementName()).collect(Collectors.joining(", ")) + ");";
                ((Method.Builder)((Method.Builder)((Method.Builder)it.addContentLine("try {")).addContent(interceptedMethod.isVoid() ? "" : "return ")).addContentLine(invokeLine)).addContent("}");
                for (TypeName exceptionType : interceptedMethod.exceptionTypes()) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContent(" catch (")).addContent(exceptionType)).addContentLine(" helidonInject__e) {")).addContentLine(" throw helidonInject__e;")).addContent("}");
                }
                if (!interceptedMethod.exceptionTypes().contains(RUNTIME_EXCEPTION_TYPE)) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContent(" catch (")).addContent(RuntimeException.class)).addContentLine(" helidonInject__e) {")).addContentLine("throw helidonInject__e;")).addContent("}");
                }
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContent(" catch (")).addContent(Exception.class)).addContentLine(" helidonInject__e) {")).addContent("throw new ")).addContent(RuntimeException.class)).addContentLine("(helidonInject__e);")).addContentLine("}");
            }));
        }
    }

    static void createInvokers(Constructor.Builder cModel, TypeName descriptorType, List<MethodDefinition> interceptedMethods, boolean useDescriptorConstant, String interceptMetaName, String descriptorName, String qualifiersName, String annotationsName, String invocationTargetName) {
        boolean hasGenericType = false;
        for (MethodDefinition interceptedMethod : interceptedMethods) {
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)cModel.addContent("this.")).addContent(interceptedMethod.invokerName)).addContent(" = ")).addContent(interceptMetaName)).addContentLine(".createInvoker(")).increaseContentPadding()).addContentLine("this,")).addContent(descriptorName)).addContentLine(",")).addContent(qualifiersName)).addContentLine(",")).addContent(annotationsName)).addContentLine(",")).update(it -> {
                if (useDescriptorConstant) {
                    ((Constructor.Builder)it.addContent(descriptorType)).addContent(".");
                }
            })).addContent(interceptedMethod.constantName())).addContentLine(",")).addContent("helidonInject__params -> ");
            if (interceptedMethod.isVoid()) {
                cModel.addContentLine("{");
            }
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)cModel.addContent(invocationTargetName)).addContent(".")).addContent(interceptedMethod.info().elementName())).addContent("(");
            ArrayList<CallSite> allArgs = new ArrayList<CallSite>();
            List args = interceptedMethod.info().parameterArguments();
            for (int i = 0; i < args.size(); ++i) {
                TypedElementInfo arg = (TypedElementInfo)args.get(i);
                allArgs.add((CallSite)((Object)("(" + arg.typeName().resolvedName() + ") helidonInject__params[" + i + "]")));
                if (arg.typeName().typeArguments().isEmpty()) continue;
                hasGenericType = true;
            }
            cModel.addContent(String.join((CharSequence)", ", allArgs));
            cModel.addContent(")");
            if (interceptedMethod.isVoid()) {
                cModel.addContentLine(";");
                cModel.addContentLine("return null;");
                cModel.addContent("}");
            }
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)cModel.addContent(", ")).addContent(Set.class)).addContent(".of(")).addContent(interceptedMethod.exceptionTypes().stream().map(it -> it.fqName() + ".class").collect(Collectors.joining(", ")))).addContentLine("));")).decreaseContentPadding();
        }
        if (hasGenericType) {
            cModel.addAnnotation(Annotation.create((TypeName)TypeName.create(SuppressWarnings.class), (String)"unchecked"));
        }
    }

    ClassModel.Builder generate() {
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)this.serviceType, (TypeName)this.interceptedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)this.serviceType, (TypeName)this.interceptedType, (String)"1", (String)""))).description("Intercepted sub-type for {@link " + this.serviceType.fqName() + "}.")).accessModifier(AccessModifier.PACKAGE_PRIVATE).type(this.interceptedType).superType(this.serviceType);
        InterceptedTypeGenerator.generateInvokerFields(classModel, this.interceptedMethods);
        this.generateConstructor(classModel);
        InterceptedTypeGenerator.generateInterceptedMethods(classModel, this.interceptedMethods);
        return classModel;
    }

    private static TypeName invokerType(TypeName type) {
        return ((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.INTERCEPT_INVOKER).addTypeArgument(type.boxed())).build();
    }

    private void generateConstructor(ClassModel.Builder classModel) {
        classModel.addConstructor(constructor -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name(INTERCEPT_META_PARAM))).addParameter(descriptor -> descriptor.type(this.descriptorType).name(SERVICE_DESCRIPTOR_PARAM))).addParameter(qualifiers -> qualifiers.type(ServiceCodegenTypes.SET_OF_QUALIFIERS).name(TYPE_QUALIFIERS_PARAM))).addParameter(qualifiers -> qualifiers.type(ServiceCodegenTypes.LIST_OF_ANNOTATIONS).name(TYPE_ANNOTATIONS_PARAM))).update(this::addConstructorParameters)).update(this::callSuperConstructor)).update(it -> InterceptedTypeGenerator.createInvokers(it, this.descriptorType, this.interceptedMethods, true, INTERCEPT_META_PARAM, SERVICE_DESCRIPTOR_PARAM, TYPE_QUALIFIERS_PARAM, TYPE_ANNOTATIONS_PARAM, "super")));
    }

    private void callSuperConstructor(Constructor.Builder cModel) {
        cModel.addContent("super(");
        cModel.addContent(this.constructor.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).elementName()).collect(Collectors.joining(", ")));
        cModel.addContentLine(");");
        cModel.addContentLine("");
    }

    private void addConstructorParameters(Constructor.Builder cModel) {
        this.constructor.parameterArguments().forEach(constructorArg -> cModel.addParameter(generatedCtrParam -> generatedCtrParam.type(constructorArg.typeName()).name(constructorArg.elementName())));
    }

    record MethodDefinition(TypedElementInfo info, String constantName, String invokerName, boolean isVoid, Set<TypeName> exceptionTypes) {
        static List<MethodDefinition> toDefinitions(RegistryCodegenContext ctx, TypeInfo typeInfo, List<TypedElements.ElementMeta> interceptedMethods) {
            ArrayList<TypedElements.ElementMeta> sortedMethods = new ArrayList<TypedElements.ElementMeta>(interceptedMethods);
            ArrayList<MethodDefinition> result = new ArrayList<MethodDefinition>();
            for (int i = 0; i < sortedMethods.size(); ++i) {
                TypedElements.ElementMeta elementMeta = (TypedElements.ElementMeta)sortedMethods.get(i);
                ArrayList<Annotation> elementAnnotations = new ArrayList<Annotation>(elementMeta.element().annotations());
                MethodDefinition.addInterfaceAnnotations(elementAnnotations, elementMeta.abstractMethods());
                TypedElementInfo typedElementInfo = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().from(elementMeta.element())).annotations(elementAnnotations)).build();
                String constantName = "METHOD_" + CodegenUtil.toConstantName((String)ctx.uniqueName(typeInfo, elementMeta.element()));
                String invokerName = typedElementInfo.elementName() + "_" + i + "_invoker";
                result.add(new MethodDefinition(typedElementInfo, constantName, invokerName, TypeNames.PRIMITIVE_VOID.equals((Object)typedElementInfo.typeName()), typedElementInfo.throwsChecked()));
            }
            result.sort(Comparator.comparing(o -> o.invokerName));
            return result;
        }

        private static void addInterfaceAnnotations(List<Annotation> elementAnnotations, List<TypedElements.DeclaredElement> declaredElements) {
            for (TypedElements.DeclaredElement declaredElement : declaredElements) {
                declaredElement.element().annotations().forEach(it -> MethodDefinition.addInterfaceAnnotation(elementAnnotations, it));
            }
        }

        private static void addInterfaceAnnotation(List<Annotation> elementAnnotations, Annotation annotation) {
            if (!elementAnnotations.contains(annotation)) {
                elementAnnotations.add(annotation);
            }
        }
    }
}

