/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.Qualifiers;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import io.helidon.service.codegen.spi.RegistryCodegenExtensionProvider;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EventObserverExtensionProvider
implements RegistryCodegenExtensionProvider {
    @Override
    public RegistryCodegenExtension create(RegistryCodegenContext codegenContext) {
        return new EventObserverExtension();
    }

    public Set<TypeName> supportedAnnotations() {
        return Set.of(ServiceCodegenTypes.EVENT_OBSERVER, ServiceCodegenTypes.EVENT_OBSERVER_ASYNC);
    }

    private static final class EventObserverExtension
    implements RegistryCodegenExtension {
        private static final TypeName GENERATOR = TypeName.create(EventObserverExtension.class);
        private static final Map<ClassNameCacheKey, Map<Set<Annotation>, TypeName>> CACHE = new ConcurrentHashMap<ClassNameCacheKey, Map<Set<Annotation>, TypeName>>();

        private EventObserverExtension() {
        }

        @Override
        public void process(RegistryRoundContext roundContext) {
            Collection elements = roundContext.annotatedElements(ServiceCodegenTypes.EVENT_OBSERVER);
            this.process(roundContext, elements, "");
            elements = roundContext.annotatedElements(ServiceCodegenTypes.EVENT_OBSERVER_ASYNC);
            this.process(roundContext, elements, "Async");
        }

        private static TypeName registration(TypeName serviceType, TypeName eventObject, Set<Annotation> qualifiers) {
            ResolvedType event = ResolvedType.create((TypeName)eventObject);
            Map map = CACHE.computeIfAbsent(new ClassNameCacheKey(serviceType, event), k -> new ConcurrentHashMap());
            return map.computeIfAbsent(qualifiers, it -> {
                String className = serviceType.classNameWithEnclosingNames().replace('.', '_') + "__Observer";
                TypeName.Builder builder = (TypeName.Builder)TypeName.builder().packageName(serviceType.packageName());
                if (map.isEmpty()) {
                    return ((TypeName.Builder)builder.className(className)).build();
                }
                return ((TypeName.Builder)builder.className(className + "_" + map.size())).build();
            });
        }

        private void process(RegistryRoundContext roundContext, Collection<TypedElementInfo> elements, String suffix) {
            for (TypedElementInfo element : elements) {
                if (element.kind() != ElementKind.METHOD) {
                    throw new CodegenException("Event observer annotations are only allowed on methods", element.originatingElementValue());
                }
                if (element.accessModifier() == AccessModifier.PRIVATE) {
                    throw new CodegenException("Event observer annotations are only allowed on non-private methods", element.originatingElementValue());
                }
                if (!element.typeName().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                    throw new CodegenException("Event observer annotations are only allowed on void methods", element.originatingElementValue());
                }
                if (element.parameterArguments().size() != 1) {
                    throw new CodegenException("Event observer annotations are only allowed on methods with exactly one parameter", element.originatingElementValue());
                }
                TypedElementInfo parameter = (TypedElementInfo)element.parameterArguments().getFirst();
                TypeName eventObject = parameter.typeName();
                Set<Annotation> qualifiers = Qualifiers.qualifiers((Annotated)element);
                TypeInfo owningType = (TypeInfo)element.enclosingType().flatMap(arg_0 -> ((RegistryRoundContext)roundContext).typeInfo(arg_0)).orElseThrow(() -> new CodegenException("Could not obtain type defining an observer", element.originatingElementValue()));
                this.generateObserverRegistration(roundContext, owningType, element, qualifiers, eventObject, suffix);
            }
        }

        private void generateObserverRegistration(RegistryRoundContext roundContext, TypeInfo owningType, TypedElementInfo element, Set<Annotation> qualifiers, TypeName eventObject, String suffix) {
            TypeName serviceTypeName = owningType.typeName();
            TypeName generatedType = EventObserverExtension.registration(serviceTypeName, eventObject, qualifiers);
            ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)generatedType, (String)"1", (String)""))).type(generatedType).accessModifier(AccessModifier.PACKAGE_PRIVATE).description("Event observer registration service for {@link " + eventObject.fqName() + "}.")).addInterface(ServiceCodegenTypes.SERVICE_G_EVENT_OBSERVER_REGISTRATION)).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON));
            classModel.addField(eventObjectConstant -> ((Field.Builder)eventObjectConstant.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).type(TypeNames.RESOLVED_TYPE_NAME).name("EVENT_OBJECT")).addContentCreate(ResolvedType.create((TypeName)eventObject)));
            Qualifiers.generateQualifiersConstant(classModel, qualifiers);
            classModel.addField(eventObserver -> eventObserver.accessModifier(AccessModifier.PRIVATE).isFinal(true).type(serviceTypeName).name("eventObserver"));
            classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(eventObserver -> eventObserver.type(serviceTypeName).name("eventObserver"))).addContentLine("this.eventObserver = eventObserver;"));
            classModel.addMethod(register -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)register.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.PRIMITIVE_VOID).name("register")).addParameter(eventManager -> eventManager.type(ServiceCodegenTypes.EVENT_MANAGER).name("manager"))).addContent("manager.register")).addContent(suffix)).addContent("(EVENT_OBJECT, eventObserver::")).addContent(element.elementName())).addContentLine(", QUALIFIERS);"));
            roundContext.addGeneratedType(generatedType, classModel, serviceTypeName, new Object[]{owningType});
        }

        private record ClassNameCacheKey(TypeName serviceType, ResolvedType eventType) {
        }
    }
}

