/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.ClassCode;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.DescriptorClassCode;
import io.helidon.service.codegen.DescriptorClassCodeImpl;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceContracts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

class RoundContextImpl
implements RegistryRoundContext {
    private final RegistryCodegenContext ctx;
    private final RoundContext delegate;
    private final Map<TypeName, List<TypeInfo>> annotationToTypes;
    private final Map<TypeName, Set<TypeName>> metaAnnotated;
    private final List<TypeInfo> types;
    private final Consumer<DescriptorClassCode> addDescriptorConsumer;
    private final Collection<TypeName> annotations;

    RoundContextImpl(RegistryCodegenContext ctx, RoundContext delegate, Consumer<DescriptorClassCode> addDescriptorConsumer, Set<TypeName> annotations, Map<TypeName, List<TypeInfo>> annotationToTypes, Map<TypeName, Set<TypeName>> metaAnnotated, List<TypeInfo> types) {
        this.ctx = ctx;
        this.delegate = delegate;
        this.addDescriptorConsumer = addDescriptorConsumer;
        this.annotations = annotations;
        this.annotationToTypes = annotationToTypes;
        this.metaAnnotated = metaAnnotated;
        this.types = types;
    }

    public Collection<TypeName> availableAnnotations() {
        return this.annotations;
    }

    public Collection<TypeInfo> types() {
        return this.types;
    }

    public Collection<TypedElementInfo> annotatedElements(TypeName annotationType) {
        List<TypeInfo> typeInfos = this.annotationToTypes.get(annotationType);
        if (typeInfos == null) {
            return Set.of();
        }
        ArrayList<TypedElementInfo> result = new ArrayList<TypedElementInfo>();
        for (TypeInfo typeInfo : typeInfos) {
            typeInfo.elementInfo().stream().filter(it -> it.hasAnnotation(annotationType)).forEach(result::add);
        }
        return result;
    }

    public Collection<TypeInfo> annotatedTypes(TypeName annotationType) {
        List<TypeInfo> typeInfos = this.annotationToTypes.get(annotationType);
        if (typeInfos == null) {
            return Set.of();
        }
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (TypeInfo typeInfo : typeInfos) {
            if (!typeInfo.hasAnnotation(annotationType)) continue;
            result.add(typeInfo);
        }
        return result;
    }

    public Collection<TypeName> annotatedAnnotations(TypeName metaAnnotation) {
        return Optional.ofNullable(this.metaAnnotated.get(metaAnnotation)).orElseGet(Set::of);
    }

    public Optional<TypeInfo> typeInfo(TypeName typeName) {
        return this.delegate.typeInfo(typeName);
    }

    public void addGeneratedType(TypeName type, ClassModel.Builder newClass, TypeName mainTrigger, Object ... originatingElements) {
        this.delegate.addGeneratedType(type, newClass, mainTrigger, originatingElements);
    }

    @Override
    public void addDescriptor(TypeName serviceType, TypeName descriptorType, ClassModel.Builder descriptor, double weight, Set<ResolvedType> contracts, Set<ResolvedType> factoryContracts, Object ... originatingElements) {
        Objects.requireNonNull(serviceType);
        Objects.requireNonNull(descriptorType);
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(contracts);
        Objects.requireNonNull(originatingElements);
        this.addDescriptorConsumer.accept(new DescriptorClassCodeImpl(new ClassCode(descriptorType, descriptor, serviceType, originatingElements), weight, contracts, factoryContracts));
        this.delegate.addGeneratedType(descriptorType, descriptor, serviceType, originatingElements);
    }

    @Override
    public ServiceContracts serviceContracts(TypeInfo serviceInfo) {
        return ServiceContracts.create(this.ctx.options(), this::typeInfo, serviceInfo);
    }

    public Optional<ClassModel.Builder> generatedType(TypeName type) {
        return this.delegate.generatedType(type);
    }
}

