/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class CoreTypeConstants {
    private final AtomicInteger genericTypeCounter = new AtomicInteger();
    private final Map<ResolvedType, String> genericConstants = new LinkedHashMap<ResolvedType, String>();
    private final AtomicInteger typeNameCounter = new AtomicInteger();
    private final Map<ResolvedType, String> typeNameConstants = new LinkedHashMap<ResolvedType, String>();

    CoreTypeConstants() {
    }

    String genericTypeConstant(ResolvedType type) {
        return this.genericConstants.computeIfAbsent(type, it -> "GTYPE_" + this.genericTypeCounter.getAndIncrement());
    }

    String typeNameConstant(ResolvedType type) {
        return this.typeNameConstants.computeIfAbsent(type, it -> "TYPE_" + this.typeNameCounter.getAndIncrement());
    }

    List<Constant> genericConstants() {
        ArrayList<Constant> result = new ArrayList<Constant>();
        this.genericConstants.forEach((type, constantName) -> result.add(new Constant(type.type(), (String)constantName)));
        return result;
    }

    List<Constant> typeNameConstants() {
        ArrayList<Constant> result = new ArrayList<Constant>();
        this.typeNameConstants.forEach((type, constantName) -> result.add(new Constant(type.type(), (String)constantName)));
        return result;
    }

    record Constant(TypeName type, String constantName) {
    }
}

