/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

final class TypedElements {
    static final ElementMeta DEFAULT_CONSTRUCTOR = new ElementMeta(((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(TypeNames.OBJECT)).accessModifier(AccessModifier.PUBLIC)).kind(ElementKind.CONSTRUCTOR)).build());

    private TypedElements() {
    }

    static List<ElementMeta> gatherElements(TypeInfo typeInfo) {
        ArrayList<ElementMeta> result = new ArrayList<ElementMeta>();
        List declaredElements = typeInfo.elementInfo().stream().toList();
        for (TypedElementInfo declaredElement : declaredElements) {
            ArrayList<DeclaredElement> abstractMethods = new ArrayList<DeclaredElement>();
            if (declaredElement.kind() == ElementKind.METHOD) {
                for (TypeInfo info : typeInfo.interfaceTypeInfo()) {
                    TypedElements.findAbstractMethod(info, declaredElement, abstractMethods);
                }
                Optional superClass = typeInfo.superTypeInfo();
                while (superClass.isPresent()) {
                    TypeInfo superClassInfo = (TypeInfo)superClass.get();
                    TypedElements.findAbstractMethod(superClassInfo, declaredElement, abstractMethods);
                    superClass = superClassInfo.superTypeInfo();
                }
            }
            result.add(new ElementMeta(declaredElement, abstractMethods));
        }
        return result;
    }

    static List<ElementMeta> gatherElements(CodegenContext ctx, Collection<ResolvedType> contracts, TypeInfo typeInfo) {
        ArrayList<ElementMeta> result = new ArrayList<ElementMeta>();
        HashSet processedSignatures = new HashSet();
        typeInfo.elementInfo().stream().filter(it -> it.kind() != ElementKind.CLASS).forEach(declaredElement -> {
            ArrayList<DeclaredElement> abstractMethods = new ArrayList<DeclaredElement>();
            if (declaredElement.kind() == ElementKind.METHOD) {
                for (TypeInfo info : typeInfo.interfaceTypeInfo()) {
                    if (!contracts.contains(ResolvedType.create((TypeName)info.typeName()))) continue;
                    TypedElements.findAbstractMethod(info, declaredElement, abstractMethods);
                }
                Optional superClass = typeInfo.superTypeInfo();
                while (superClass.isPresent()) {
                    TypeInfo superClassInfo = (TypeInfo)superClass.get();
                    TypedElements.findAbstractMethod(superClassInfo, declaredElement, abstractMethods);
                    superClass = superClassInfo.superTypeInfo();
                }
            }
            result.add(new ElementMeta((TypedElementInfo)declaredElement, (List<DeclaredElement>)abstractMethods));
            processedSignatures.add(declaredElement.signature());
        });
        for (ResolvedType contract : contracts) {
            Optional contractTypeInfo = ctx.typeInfo(contract.type());
            if (!contractTypeInfo.isPresent()) continue;
            TypeInfo inheritedContract = (TypeInfo)contractTypeInfo.get();
            inheritedContract.elementInfo().stream().filter(it -> it.kind() != ElementKind.CLASS).forEach(superElement -> {
                if (!processedSignatures.add(superElement.signature())) {
                    return;
                }
                ArrayList<DeclaredElement> interfaceMethods = new ArrayList<DeclaredElement>();
                if (superElement.kind() == ElementKind.METHOD) {
                    interfaceMethods.add(new DeclaredElement(inheritedContract, (TypedElementInfo)superElement));
                }
                result.add(new ElementMeta((TypedElementInfo)superElement, (List<DeclaredElement>)interfaceMethods));
            });
        }
        return result;
    }

    private static void findAbstractMethod(TypeInfo info, TypedElementInfo declaredElement, List<DeclaredElement> abstractMethods) {
        info.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> ElementInfoPredicates.isAbstract((TypedElementInfo)it) || ElementInfoPredicates.isDefault((TypedElementInfo)it)).filter(it -> declaredElement.signature().equals((Object)it.signature())).findFirst().ifPresent(it -> abstractMethods.add(new DeclaredElement(info, (TypedElementInfo)it)));
    }

    record ElementMeta(TypedElementInfo element, List<DeclaredElement> abstractMethods) {
        ElementMeta(TypedElementInfo element) {
            this(element, List.of());
        }
    }

    record DeclaredElement(TypeInfo abstractType, TypedElementInfo element) {
    }
}

