/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.ModuleInfo;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.Weight;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.Assignments;
import io.helidon.service.codegen.CodegenHelper;
import io.helidon.service.codegen.DescribedElements;
import io.helidon.service.codegen.DescribedService;
import io.helidon.service.codegen.DescribedType;
import io.helidon.service.codegen.FactoryType;
import io.helidon.service.codegen.InterceptedTypeGenerator;
import io.helidon.service.codegen.Interception;
import io.helidon.service.codegen.InterceptionStrategy;
import io.helidon.service.codegen.InterceptionSupport;
import io.helidon.service.codegen.MethodDefinition;
import io.helidon.service.codegen.ParamDefinition;
import io.helidon.service.codegen.Qualifiers;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.ServiceExtension;
import io.helidon.service.codegen.ServiceOptions;
import io.helidon.service.codegen.ServiceSuperType;
import io.helidon.service.codegen.TypedElements;
import io.helidon.service.codegen.spi.InjectAssignment;
import io.helidon.service.codegen.spi.InjectCodegenObserver;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ServiceDescriptorCodegen {
    private static final TypeName GENERATOR = TypeName.create(ServiceExtension.class);
    private static final TypeName DESCRIPTOR_TYPE = ((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.SERVICE_DESCRIPTOR).addTypeArgument(TypeName.create((String)"T"))).build();
    private final InterceptionSupport interception;
    private final Assignments assignments;
    private final Set<TypeName> scopeMetaAnnotations;
    private final List<InjectCodegenObserver> observers;
    private final RegistryCodegenContext ctx;
    private String packageName;

    ServiceDescriptorCodegen(RegistryCodegenContext ctx, List<InjectCodegenObserver> observers, InterceptionSupport interceptionSupport) {
        this.ctx = ctx;
        this.observers = observers;
        this.interception = interceptionSupport;
        this.assignments = new Assignments(ctx);
        CodegenOptions options = ctx.options();
        this.scopeMetaAnnotations = (Set)ServiceOptions.SCOPE_META_ANNOTATIONS.value(options);
        this.packageName = CodegenOptions.CODEGEN_PACKAGE.findValue(options).orElse(null);
    }

    public static ServiceDescriptorCodegen create(RegistryCodegenContext ctx) {
        Interception interception = new Interception(InterceptionStrategy.NONE);
        return new ServiceDescriptorCodegen(ctx, List.of(), new InterceptionSupport(ctx, interception));
    }

    public void service(TypeName generator, RegistryRoundContext roundCtx, Collection<TypeInfo> services, TypeInfo typeInfo) {
        Set<ResolvedType> factoryContracts;
        this.packageName(roundCtx);
        if (typeInfo.kind() == ElementKind.INTERFACE || typeInfo.kind() == ElementKind.ANNOTATION_TYPE) {
            return;
        }
        TypeName scope = this.scope(typeInfo);
        DescribedService service = DescribedService.create(this.ctx, roundCtx, this.interception, typeInfo, this.superType(typeInfo, services), scope);
        DescribedType serviceDescriptor = service.serviceDescriptor();
        DescribedElements serviceElements = serviceDescriptor.elements();
        TypeName serviceTypeName = serviceDescriptor.typeName();
        ArrayList<ParamDefinition> params = new ArrayList<ParamDefinition>();
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        TypedElementInfo constructorInjectElement = this.injectConstructor(typeInfo);
        List<TypedElementInfo> fieldInjectElements = this.fieldInjectElements(typeInfo);
        this.params(services, service, methods, params, constructorInjectElement, fieldInjectElements);
        this.notifyIpObservers(roundCtx, service, params);
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)service.descriptorType())).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)service.descriptorType(), (String)"1", (String)""))).type(service.descriptorType()).addGenericArgument(TypeArgument.create((String)("T extends " + serviceTypeName.fqName())))).javadoc(Javadoc.builder().add("Service descriptor for {@link " + serviceTypeName.fqName() + "}.").addGenericArgument("T", "type of the service, for extensibility").build())).sortStaticFields(false);
        this.singletonInstanceField(classModel, service);
        Map<String, GenericTypeDeclaration> genericTypes = this.genericTypes(classModel, params, methods);
        Set<Object> contracts = serviceDescriptor.contracts();
        if (service.isFactory()) {
            if (serviceTypeName.className().endsWith("__Interception_Wrapper")) {
                contracts = service.providedDescriptor().contracts();
                factoryContracts = service.serviceDescriptor().contracts();
            } else {
                DescribedElements providedElements = service.providedDescriptor().elements();
                if (providedElements.methodsIntercepted()) {
                    contracts = Set.of();
                    factoryContracts = Set.of();
                    TypeName delegateType = this.generateProvidedInterceptionDelegate(roundCtx, service);
                    this.generateDelegationService(roundCtx, service, delegateType);
                } else {
                    contracts = service.providedDescriptor().contracts();
                    factoryContracts = service.serviceDescriptor().contracts();
                }
            }
        } else {
            factoryContracts = Set.of();
        }
        if (service.superType().present()) {
            classModel.superType(service.superType().descriptorType());
        } else {
            classModel.addInterface(DESCRIPTOR_TYPE);
        }
        this.serviceTypeMethod(classModel, service);
        this.providedTypeMethod(classModel, service);
        this.descriptorTypeMethod(classModel, service);
        this.scopeMethod(classModel, service);
        this.contractsMethod(classModel, service, contracts, factoryContracts);
        this.qualifiersMethod(classModel, service);
        this.methodFields(classModel, methods);
        this.methodElementFields(classModel, service);
        this.injectionPointFields(classModel, typeInfo, genericTypes, params);
        this.dependenciesField(classModel, params);
        CodegenHelper.annotationsField(classModel, serviceDescriptor.typeInfo());
        if (serviceElements.intercepted()) {
            if (serviceElements.constructorIntercepted()) {
                this.constructorElementField(classModel, constructorInjectElement);
            }
            fieldInjectElements.stream().filter(it -> this.isIntercepted(serviceElements.interceptedElements(), (TypedElementInfo)it)).forEach(fieldElement -> this.fieldElementField(classModel, (TypedElementInfo)fieldElement));
        }
        classModel.addConstructor(constructor -> ((Constructor.Builder)constructor.description("Constructor with no side effects")).accessModifier(AccessModifier.PROTECTED));
        this.dependenciesMethod(classModel, service, params);
        this.isAbstractMethod(classModel, service);
        this.instantiateMethod(classModel, service, params);
        this.injectMethod(classModel, service, params, methods);
        this.postConstructMethod(classModel, service);
        this.preDestroyMethod(classModel, service);
        this.weightMethod(classModel, service);
        this.runLevelMethod(classModel, service);
        this.createForMethod(classModel, service);
        this.qualifiedProvider(classModel, service);
        this.scopeHandler(typeInfo, classModel, contracts);
        this.factoryType(classModel, service, service.providerType());
        HashSet<ResolvedType> metaInfServiceContracts = new HashSet<ResolvedType>(contracts);
        HashSet<ResolvedType> metaInfFactoryContracts = new HashSet<ResolvedType>(factoryContracts);
        if (service.providedDescriptor() == null || contracts.isEmpty()) {
            metaInfServiceContracts.add(ResolvedType.create((TypeName)serviceTypeName));
        } else {
            metaInfFactoryContracts.add(ResolvedType.create((TypeName)serviceTypeName));
        }
        roundCtx.addDescriptor(serviceTypeName, service.descriptorType(), classModel, this.weight(typeInfo).orElse(100.0), metaInfServiceContracts, metaInfFactoryContracts, typeInfo.originatingElementValue());
        if (serviceElements.methodsIntercepted()) {
            this.generateInterceptedType(roundCtx, typeInfo, service, constructorInjectElement);
        }
    }

    void service(RegistryRoundContext roundCtx, Collection<TypeInfo> services, TypeInfo typeInfo) {
        this.service(GENERATOR, roundCtx, services, typeInfo);
    }

    void describe(RegistryRoundContext roundCtx, TypeInfo typeInfo, Annotation describeAnnotation) {
        this.packageName(roundCtx);
        DescribedService service = DescribedService.create(this.ctx, roundCtx, this.interception, typeInfo, ServiceSuperType.create(), describeAnnotation.typeValue().orElse(ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON));
        DescribedType serviceDescriptor = service.serviceDescriptor();
        TypeName serviceTypeName = serviceDescriptor.typeName();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)service.descriptorType())).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)serviceTypeName, (TypeName)service.descriptorType(), (String)"1", (String)""))).addInterface(DESCRIPTOR_TYPE)).type(service.descriptorType()).addGenericArgument(TypeArgument.create((String)("T extends " + serviceTypeName.fqName())))).javadoc(Javadoc.builder().add("Service descriptor for {@link " + serviceTypeName.fqName() + "}.").addGenericArgument("T", "type of the service, for extensibility").build())).sortStaticFields(false);
        Set<ResolvedType> contracts = serviceDescriptor.contracts();
        this.singletonInstanceField(classModel, service);
        this.serviceTypeMethod(classModel, service);
        this.providedTypeMethod(classModel, service);
        this.descriptorTypeMethod(classModel, service);
        this.scopeMethod(classModel, service);
        this.contractsMethod(classModel, service, contracts, Set.of());
        CodegenHelper.annotationsField(classModel, serviceDescriptor.typeInfo());
        classModel.addConstructor(constructor -> ((Constructor.Builder)constructor.description("Constructor with no side effects")).accessModifier(AccessModifier.PROTECTED));
        this.qualifiersMethod(classModel, service);
        this.weightMethod(classModel, service);
        this.runLevelMethod(classModel, service);
        this.factoryType(classModel, service, FactoryType.NONE);
        HashSet<ResolvedType> serviceContracts = new HashSet<ResolvedType>(contracts);
        serviceContracts.add(ResolvedType.create((TypeName)serviceTypeName));
        roundCtx.addDescriptor(serviceTypeName, service.descriptorType(), classModel, this.weight(serviceDescriptor.typeInfo()).orElse(100.0), serviceContracts, Set.of(), serviceDescriptor.typeInfo().originatingElementValue());
    }

    private static void addAnnotationValue(ContentBuilder<?> contentBuilder, Object objectValue) {
        Object object = objectValue;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Long.class, Double.class, Integer.class, Byte.class, Character.class, Short.class, Float.class, Class.class, TypeName.class, Annotation.class, Enum.class, List.class}, (Object)object2, n)) {
            case 0: {
                String value = (String)object2;
                contentBuilder.addContent("\"" + value + "\"");
                break;
            }
            case 1: {
                Boolean value = (Boolean)object2;
                contentBuilder.addContent(String.valueOf(value));
                break;
            }
            case 2: {
                Long value = (Long)object2;
                contentBuilder.addContent(String.valueOf(value) + "L");
                break;
            }
            case 3: {
                Double value = (Double)object2;
                contentBuilder.addContent(String.valueOf(value) + "D");
                break;
            }
            case 4: {
                Integer value = (Integer)object2;
                contentBuilder.addContent(String.valueOf(value));
                break;
            }
            case 5: {
                Byte value = (Byte)object2;
                contentBuilder.addContent("(byte)" + value);
                break;
            }
            case 6: {
                Character value = (Character)object2;
                contentBuilder.addContent("'" + value + "'");
                break;
            }
            case 7: {
                Short value = (Short)object2;
                contentBuilder.addContent("(short)" + value);
                break;
            }
            case 8: {
                Float value = (Float)object2;
                contentBuilder.addContent(String.valueOf(value) + "F");
                break;
            }
            case 9: {
                Class value = (Class)object2;
                contentBuilder.addContentCreate(TypeName.create((Type)value));
                break;
            }
            case 10: {
                TypeName value = (TypeName)object2;
                contentBuilder.addContentCreate(value);
                break;
            }
            case 11: {
                Annotation value = (Annotation)object2;
                contentBuilder.addContentCreate(value);
                break;
            }
            case 12: {
                Enum value = (Enum)object2;
                ServiceDescriptorCodegen.toEnumValue(contentBuilder, value);
                break;
            }
            case 13: {
                List values = (List)object2;
                ServiceDescriptorCodegen.toListValues(contentBuilder, values);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected annotation value type " + objectValue.getClass().getName() + ": " + String.valueOf(objectValue));
            }
        }
    }

    private static void toListValues(ContentBuilder<?> contentBuilder, List<?> values) {
        contentBuilder.addContent(List.class).addContent(".of(");
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            ServiceDescriptorCodegen.addAnnotationValue(contentBuilder, value);
            if (i == size - 1) continue;
            contentBuilder.addContent(",");
        }
        contentBuilder.addContent(")");
    }

    private static void toEnumValue(ContentBuilder<?> contentBuilder, Enum<?> enumValue) {
        contentBuilder.addContent(enumValue.getDeclaringClass()).addContent(".").addContent(enumValue.name());
    }

    private static void addInterfaceAnnotations(List<Annotation> elementAnnotations, List<TypedElements.DeclaredElement> declaredElements) {
        for (TypedElements.DeclaredElement declaredElement : declaredElements) {
            declaredElement.element().annotations().forEach(it -> ServiceDescriptorCodegen.addInterfaceAnnotation(elementAnnotations, it));
        }
    }

    private static void addInterfaceAnnotation(List<Annotation> elementAnnotations, Annotation annotation) {
        if (!elementAnnotations.contains(annotation)) {
            elementAnnotations.add(annotation);
        }
    }

    private static List<ParamDefinition> declareCtrParamsAndGetThem(Method.Builder method, List<ParamDefinition> params) {
        List<ParamDefinition> constructorParams = params.stream().filter(it -> it.kind() == ElementKind.CONSTRUCTOR).toList();
        for (ParamDefinition param : constructorParams) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(param.declaredType())).addContent(" ")).addContent(param.ipParamName())).addContent(" = ")).update(it -> param.assignmentHandler().accept((ContentBuilder<?>)it))).addContentLine(";");
        }
        if (!params.isEmpty()) {
            method.addContentLine("");
        }
        return constructorParams;
    }

    private void notifyIpObservers(RegistryRoundContext roundContext, DescribedService service, List<ParamDefinition> params) {
        if (this.observers.isEmpty()) {
            return;
        }
        for (ParamDefinition param : params) {
            TypeInfo typeInfo = service.serviceDescriptor().typeInfo();
            TypedElementInfo owningElement = param.owningElement();
            TypedElementInfo ipElement = param.elementInfo();
            this.observers.forEach(it -> it.onInjectionPoint(roundContext, typeInfo, owningElement, ipElement));
        }
    }

    private void packageName(RegistryRoundContext roundCtx) {
        if (this.packageName == null) {
            this.packageName = this.ctx.module().flatMap(ModuleInfo::firstUnqualifiedExport).orElse(null);
            if (this.packageName == null) {
                this.packageName = roundCtx.types().stream().map(rec$ -> ((TypeInfo)rec$).typeName()).map(rec$ -> ((TypeName)rec$).packageName()).findFirst().orElse(null);
            }
        }
    }

    private TypeName scope(TypeInfo service) {
        LinkedHashSet<TypeName> result = new LinkedHashSet<TypeName>();
        for (Annotation anno : service.annotations()) {
            TypeName annoType = anno.typeName();
            if (service.hasMetaAnnotation(annoType, ServiceCodegenTypes.SERVICE_ANNOTATION_SCOPE)) {
                result.add(annoType);
                continue;
            }
            for (TypeName scopeMetaAnnotation : this.scopeMetaAnnotations) {
                if (!service.hasMetaAnnotation(annoType, scopeMetaAnnotation)) continue;
                result.add(annoType);
            }
        }
        if (result.size() > 1) {
            throw new CodegenException("Type " + service.typeName().fqName() + " has more than one scope defined. This is not supported. Scopes. " + String.valueOf(result));
        }
        if (!result.isEmpty()) {
            return (TypeName)result.iterator().next();
        }
        if (service.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PER_INSTANCE)) {
            return ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON;
        }
        if (service.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PROVIDER)) {
            if (service.interfaceTypeInfo().stream().map(rec$ -> ((TypeInfo)rec$).typeName()).anyMatch(arg_0 -> ((TypeName)TypeNames.SUPPLIER).equals(arg_0))) {
                return ServiceCodegenTypes.SERVICE_ANNOTATION_PER_LOOKUP;
            }
            return ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON;
        }
        return ServiceCodegenTypes.SERVICE_ANNOTATION_PER_LOOKUP;
    }

    private ServiceSuperType superType(TypeInfo typeInfo, Collection<TypeInfo> services) {
        Optional superTypeInfoOptional = typeInfo.superTypeInfo();
        if (superTypeInfoOptional.isEmpty()) {
            return ServiceSuperType.create();
        }
        TypeInfo superType = (TypeInfo)superTypeInfoOptional.get();
        TypeName expectedSuperDescriptor = this.ctx.descriptorType(superType.typeName());
        TypeName superTypeToExtend = ((TypeName.Builder)TypeName.builder((TypeName)expectedSuperDescriptor).addTypeArgument(TypeName.create((String)"T"))).build();
        for (TypeInfo service : services) {
            if (!service.typeName().equals((Object)superType.typeName())) continue;
            return ServiceSuperType.create(service, superTypeToExtend);
        }
        return this.ctx.typeInfo(expectedSuperDescriptor).map(it -> ServiceSuperType.create(superType, superTypeToExtend)).orElseGet(ServiceSuperType::create);
    }

    private TypedElementInfo injectConstructor(TypeInfo typeInfo) {
        List constructors = typeInfo.elementInfo().stream().filter(it -> it.kind() == ElementKind.CONSTRUCTOR).filter(it -> it.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT)).collect(Collectors.toUnmodifiableList());
        if (constructors.size() > 1) {
            throw new CodegenException("There can only be one constructor annotated with " + ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT.fqName() + ", but there were " + constructors.size(), typeInfo.originatingElementValue());
        }
        if (!constructors.isEmpty()) {
            TypedElementInfo first = (TypedElementInfo)constructors.getFirst();
            if (ElementInfoPredicates.isPrivate((TypedElementInfo)first)) {
                throw new CodegenException("Constructor annotated with " + ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT.fqName() + " must not be private.");
            }
            return first;
        }
        List allConstructors = typeInfo.elementInfo().stream().filter(it -> it.kind() == ElementKind.CONSTRUCTOR).collect(Collectors.toUnmodifiableList());
        if (allConstructors.isEmpty()) {
            return TypedElements.DEFAULT_CONSTRUCTOR.element();
        }
        List nonPrivateConstructors = allConstructors.stream().filter(Predicate.not(ElementInfoPredicates::isPrivate)).collect(Collectors.toUnmodifiableList());
        if (nonPrivateConstructors.isEmpty()) {
            throw new CodegenException("There is no non-private constructor defined for " + typeInfo.typeName().fqName(), typeInfo.originatingElementValue());
        }
        if (nonPrivateConstructors.size() > 1) {
            throw new CodegenException("There are more non-private constructors defined for " + typeInfo.typeName().fqName(), typeInfo.originatingElementValue());
        }
        return (TypedElementInfo)nonPrivateConstructors.getFirst();
    }

    private List<TypedElementInfo> fieldInjectElements(TypeInfo typeInfo) {
        List<TypedElementInfo> injectFields = typeInfo.elementInfo().stream().filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(ElementInfoPredicates::isField).filter(ElementInfoPredicates.hasAnnotation((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT)).toList();
        Optional<TypedElementInfo> firstFound = injectFields.stream().filter(ElementInfoPredicates::isPrivate).findFirst();
        if (firstFound.isPresent()) {
            if (typeInfo.kind() == ElementKind.RECORD) {
                throw new CodegenException("Discovered " + ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT.fqName() + " annotation on record field(s). This is not supported. If this is the only constructor, you can remove the Inject annotation; if you need to inject the default constructor, kindly create an explicit default constructor and annotate it with Inject.", firstFound.get().originatingElementValue());
            }
            throw new CodegenException("Discovered " + ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT.fqName() + " annotation on private field(s). We cannot support private field injection.", firstFound.get().originatingElementValue());
        }
        firstFound = injectFields.stream().filter(ElementInfoPredicates::isStatic).findFirst();
        if (firstFound.isPresent()) {
            throw new CodegenException("Discovered " + ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT.fqName() + " annotation on static field(s).", firstFound.get().originatingElementValue());
        }
        return injectFields;
    }

    private void params(Collection<TypeInfo> services, DescribedService describedService, List<MethodDefinition> methods, List<ParamDefinition> params, TypedElementInfo constructor, List<TypedElementInfo> fieldInjectElements) {
        AtomicInteger paramCounter = new AtomicInteger();
        AtomicInteger methodCounter = new AtomicInteger();
        if (!constructor.parameterArguments().isEmpty()) {
            this.injectConstructorParams(describedService, params, paramCounter, constructor);
        }
        fieldInjectElements.forEach(it -> this.fieldParam(describedService, params, paramCounter, (TypedElementInfo)it));
        methods.addAll(this.methodParams(services, describedService, params, methodCounter, paramCounter));
    }

    private List<MethodDefinition> methodParams(Collection<TypeInfo> services, DescribedService service, List<ParamDefinition> allParams, AtomicInteger methodCounter, AtomicInteger paramCounter) {
        TypeName serviceType = service.serviceDescriptor().typeName();
        TypeInfo serviceTypeInfo = service.serviceDescriptor().typeInfo();
        List<TypedElementInfo> atInjectMethods = serviceTypeInfo.elementInfo().stream().filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates.hasAnnotation((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT)).toList();
        ArrayList<MethodDefinition> result = new ArrayList<MethodDefinition>();
        atInjectMethods.stream().map(it -> {
            boolean overrides;
            TypeName declaringType;
            if (service.superType().present()) {
                declaringType = this.overrides(services, service.superType().typeInfo(), (TypedElementInfo)it, it.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).toList(), serviceType.packageName(), new TypeName[0]).orElse(serviceType);
                overrides = !declaringType.equals((Object)serviceType);
            } else {
                declaringType = serviceType;
                overrides = false;
            }
            return this.toMethodDefinition(service, allParams, methodCounter, paramCounter, (TypedElementInfo)it, declaringType, overrides, true);
        }).forEach(result::add);
        if (service.superType().empty()) {
            return result;
        }
        List<TypedElementInfo> otherMethods = serviceTypeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> !it.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT)).toList();
        for (TypedElementInfo otherMethod : otherMethods) {
            Optional<TypeName> overrides = this.overrides(services, service.superType().typeInfo(), otherMethod, otherMethod.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).toList(), serviceType.packageName(), ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT);
            if (!overrides.isPresent()) continue;
            result.add(this.toMethodDefinition(service, allParams, methodCounter, paramCounter, otherMethod, overrides.get(), true, false));
        }
        return result;
    }

    private MethodDefinition toMethodDefinition(DescribedService service, List<ParamDefinition> allParams, AtomicInteger methodCounter, AtomicInteger paramCounter, TypedElementInfo method, TypeName declaringType, boolean overrides, boolean isInjectionPoint) {
        int methodIndex = methodCounter.getAndIncrement();
        String methodId = method.elementName() + "_" + methodIndex;
        String constantName = "METHOD_" + methodIndex;
        List<ParamDefinition> methodParams = this.toMethodParams(service, paramCounter, method, methodId, constantName);
        if (isInjectionPoint) {
            allParams.addAll(methodParams);
        }
        return new MethodDefinition(declaringType, method.accessModifier(), methodId, constantName, method.elementName(), overrides, methodParams, isInjectionPoint, method.elementModifiers().contains(Modifier.FINAL));
    }

    private List<ParamDefinition> toMethodParams(DescribedService service, AtomicInteger paramCounter, TypedElementInfo method, String methodId, String methodConstantName) {
        return method.parameterArguments().stream().map(param -> {
            String constantName = "DEP_" + paramCounter.getAndIncrement();
            InjectAssignment.Assignment assignment = this.translateParameter(param.typeName(), constantName);
            return new ParamDefinition(method, methodConstantName, (TypedElementInfo)param, constantName, param.typeName(), assignment.usedType(), assignment.codeGenerator(), ElementKind.METHOD, method.elementName(), param.elementName(), methodId + "_" + param.elementName(), method.elementModifiers().contains(Modifier.STATIC), param.annotations(), this.qualifiers(service, (Annotated)param), this.contract("Method " + service.serviceDescriptor().typeName().fqName() + "#" + method.elementName() + ", parameter: " + param.elementName(), assignment.usedType()), method.accessModifier(), methodId);
        }).toList();
    }

    private void injectConstructorParams(DescribedService service, List<ParamDefinition> result, AtomicInteger paramCounter, TypedElementInfo constructor) {
        constructor.parameterArguments().stream().map(param -> {
            String constantName = "DEP_" + paramCounter.getAndIncrement();
            InjectAssignment.Assignment assignment = this.translateParameter(param.typeName(), constantName);
            return new ParamDefinition(constructor, null, (TypedElementInfo)param, constantName, param.typeName(), assignment.usedType(), assignment.codeGenerator(), ElementKind.CONSTRUCTOR, constructor.elementName(), param.elementName(), param.elementName(), false, param.annotations(), this.qualifiers(service, (Annotated)param), this.contract(service.serviceDescriptor().typeName().fqName() + " Constructor parameter: " + param.elementName(), assignment.usedType()), constructor.accessModifier(), "<init>");
        }).forEach(result::add);
    }

    private void fieldParam(DescribedService describedService, List<ParamDefinition> result, AtomicInteger paramCounter, TypedElementInfo field) {
        String constantName = "DEP_" + paramCounter.getAndIncrement();
        InjectAssignment.Assignment assignment = this.translateParameter(field.typeName(), constantName);
        result.add(new ParamDefinition(field, null, field, constantName, field.typeName(), assignment.usedType(), assignment.codeGenerator(), ElementKind.FIELD, field.elementName(), field.elementName(), field.elementName(), field.elementModifiers().contains(Modifier.STATIC), field.annotations(), this.qualifiers(describedService, (Annotated)field), this.contract("Field " + describedService.serviceDescriptor().typeName().fqName() + "." + field.elementName(), assignment.usedType()), field.accessModifier(), null));
    }

    private InjectAssignment.Assignment translateParameter(TypeName typeName, String constantName) {
        return this.assignments.assignment(typeName, "ctx__helidonInject.dependency(" + constantName + ")");
    }

    private Set<Annotation> qualifiers(DescribedService service, Annotated element) {
        LinkedHashSet<Annotation> result = new LinkedHashSet<Annotation>();
        for (Annotation anno : element.annotations()) {
            if (!service.serviceDescriptor().typeInfo().hasMetaAnnotation(anno.typeName(), ServiceCodegenTypes.SERVICE_ANNOTATION_QUALIFIER)) continue;
            result.add(anno);
        }
        return result;
    }

    private TypeName contract(String description, TypeName typeName) {
        if (typeName.isOptional()) {
            if (typeName.typeArguments().isEmpty()) {
                throw new IllegalArgumentException("Injection point with Optional type must have a declared type argument: " + description);
            }
            TypeName firstType = (TypeName)typeName.typeArguments().getFirst();
            if (firstType.equals((Object)ServiceCodegenTypes.SERVICE_SERVICE_INSTANCE)) {
                if (typeName.typeArguments().isEmpty()) {
                    throw new IllegalArgumentException("Injection point with Optional<ServiceInstance> type must have a declared type argument: " + description);
                }
                return this.contract(description, (TypeName)firstType.typeArguments().getFirst());
            }
            return this.contract(description, firstType);
        }
        if (typeName.isList()) {
            if (typeName.typeArguments().isEmpty()) {
                throw new IllegalArgumentException("Injection point with List type must have a declared type argument: " + description);
            }
            TypeName firstType = (TypeName)typeName.typeArguments().getFirst();
            if (firstType.equals((Object)ServiceCodegenTypes.SERVICE_SERVICE_INSTANCE)) {
                if (typeName.typeArguments().isEmpty()) {
                    throw new IllegalArgumentException("Injection point with List<ServiceInstance> type must have a declared type argument: " + description);
                }
                return this.contract(description, (TypeName)firstType.typeArguments().getFirst());
            }
            return this.contract(description, firstType);
        }
        if (typeName.isSupplier()) {
            if (typeName.typeArguments().isEmpty()) {
                throw new IllegalArgumentException("Injection point with Supplier type must have a declared type argument: " + description);
            }
            return this.contract(description, (TypeName)typeName.typeArguments().getFirst());
        }
        if (typeName.equals((Object)ServiceCodegenTypes.SERVICE_SERVICE_INSTANCE)) {
            if (typeName.typeArguments().isEmpty()) {
                throw new IllegalArgumentException("Injection point with ServiceInstance type must have a declared type argument: " + description);
            }
            return this.contract(description, (TypeName)typeName.typeArguments().getFirst());
        }
        return typeName;
    }

    private Optional<TypeName> overrides(Collection<TypeInfo> services, TypeInfo type, TypedElementInfo method, List<TypeName> arguments, String currentPackage, TypeName ... expectedAnnotations) {
        ServiceSuperType superType;
        String methodName = method.elementName();
        Optional<TypedElementInfo> found = type.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates.elementName((String)methodName)).filter(it -> {
            for (TypeName expectedAnnotation : expectedAnnotations) {
                if (it.hasAnnotation(expectedAnnotation)) continue;
                return false;
            }
            return true;
        }).filter(ElementInfoPredicates.hasParams(arguments)).findFirst();
        if (found.isPresent()) {
            boolean realOverride;
            TypedElementInfo superMethod = found.get();
            boolean bl = realOverride = superMethod.accessModifier() != AccessModifier.PACKAGE_PRIVATE || currentPackage.equals(type.typeName().packageName());
            if (realOverride) {
                ServiceSuperType superType2 = this.superType(type, services);
                if (superType2.present()) {
                    Optional<TypeName> fromSuperHierarchy = this.overrides(services, superType2.typeInfo(), method, arguments, currentPackage, new TypeName[0]);
                    return Optional.of(fromSuperHierarchy.orElseGet(() -> type.typeName()));
                }
                return Optional.of(type.typeName());
            }
        }
        if ((superType = this.superType(type, services)).present()) {
            return this.overrides(services, superType.typeInfo(), method, arguments, currentPackage, expectedAnnotations);
        }
        return Optional.empty();
    }

    private void singletonInstanceField(ClassModel.Builder classModel, DescribedService service) {
        classModel.addField(instance -> ((Field.Builder)((Field.Builder)instance.description("Global singleton instance for this descriptor.")).accessModifier(AccessModifier.PUBLIC).isStatic(true).isFinal(true).type(this.descriptorInstanceType(service.serviceDescriptor().typeName(), service.descriptorType())).name("INSTANCE")).defaultValueContent("new " + service.descriptorType().className() + "<>()"));
    }

    private void injectionPointFields(ClassModel.Builder classModel, TypeInfo service, Map<String, GenericTypeDeclaration> genericTypes, List<ParamDefinition> params) {
        for (ParamDefinition param : params) {
            DependencyMetadata dependencyMetadata = this.dependencyMetadata(param);
            classModel.addField(field -> ((Field.Builder)((Field.Builder)field.accessModifier(AccessModifier.PUBLIC).isStatic(true).isFinal(true).type(ServiceCodegenTypes.SERVICE_DEPENDENCY).name(param.constantName())).description(this.ipIdDescription(service, param))).update(it -> {
                ((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)it.addContent(ServiceCodegenTypes.SERVICE_DEPENDENCY).addContentLine(".builder()")).increaseContentPadding().increaseContentPadding().addContent(".typeName(").addContent(((GenericTypeDeclaration)genericTypes.get(param.translatedType().resolvedName())).constantName()).addContentLine(")")).update(maybeElementKind -> {
                    if (param.kind() != ElementKind.CONSTRUCTOR) {
                        maybeElementKind.addContent(".elementKind(").addContent(TypeNames.ELEMENT_KIND).addContent(".").addContent(param.kind().name()).addContentLine(")");
                    }
                })).update(maybeMethod -> {
                    if (param.kind() == ElementKind.METHOD) {
                        maybeMethod.addContent(".method(").addContent(param.methodConstantName()).addContentLine(")");
                    }
                })).addContent(".name(\"").addContent(param.fieldId()).addContentLine("\")")).addContentLine(".service(SERVICE_TYPE)")).addContentLine(".descriptor(TYPE)")).addContent(".descriptorConstant(\"").addContent(param.constantName()).addContentLine("\")")).addContent(".contract(").addContent(((GenericTypeDeclaration)genericTypes.get(param.contract().resolvedName())).constantName()).addContentLine(")")).addContent(".contractType(G").addContent(((GenericTypeDeclaration)genericTypes.get(param.contract().resolvedName())).constantName()).addContentLine(")");
                if (param.access() != AccessModifier.PACKAGE_PRIVATE) {
                    it.addContent(".access(").addContent(TypeNames.ACCESS_MODIFIER).addContent(".").addContent(param.access().name()).addContentLine(")");
                }
                if (param.isStatic()) {
                    it.addContentLine(".isStatic(true)");
                }
                if (!param.qualifiers().isEmpty()) {
                    for (Annotation qualifier : param.qualifiers()) {
                        ((Field.Builder)it.addContent(".addQualifier(qualifier -> qualifier.typeName(").addContentCreate(qualifier.typeName().genericTypeName())).addContentLine(")");
                        qualifier.values().keySet().forEach(propertyName -> {
                            it.addContent(".putValue(\"").addContent(propertyName).addContent("\", ");
                            ServiceDescriptorCodegen.addAnnotationValue(it, qualifier.objectValue(propertyName).get());
                            it.addContentLine(")");
                        });
                        it.addContentLine(")");
                    }
                }
                if (!dependencyMetadata.cardinality.equals("REQUIRED")) {
                    it.addContent(".cardinality(").addContent(ServiceCodegenTypes.DEPENDENCY_CARDINALITY).addContent(".").addContent(dependencyMetadata.cardinality()).addContentLine(")");
                }
                if (dependencyMetadata.serviceInstance()) {
                    it.addContent(".isServiceInstance(").addContent(String.valueOf(dependencyMetadata.serviceInstance())).addContentLine(")");
                }
                if (dependencyMetadata.supplier()) {
                    it.addContent(".isSupplier(").addContent(String.valueOf(dependencyMetadata.supplier())).addContentLine(")");
                }
                it.addContent(".build()").decreaseContentPadding().decreaseContentPadding();
            }));
        }
    }

    private DependencyMetadata dependencyMetadata(ParamDefinition param) {
        boolean isServiceInstance;
        String cardinality;
        TypeName declared = param.declaredType();
        boolean isSupplier = declared.isSupplier();
        if (isSupplier) {
            declared = (TypeName)declared.typeArguments().getFirst();
        }
        if (declared.isSupplier()) {
            throw new CodegenException("Dependency is declared as a Supplier<Supplier<>> - this is not supported", param.elementInfo().originatingElementValue());
        }
        if (declared.isOptional()) {
            cardinality = "OPTIONAL";
            TypeName actualContract = (TypeName)declared.typeArguments().getFirst();
            if (actualContract.isSupplier()) {
                throw new CodegenException("Dependency has Optional<Supplier<>> - this is not supported, please use Supplier<Optional>", param.elementInfo().originatingElementValue());
            }
            if (actualContract.isOptional()) {
                throw new CodegenException("Dependency has Optional<Optional<>> - this is not supported", param.elementInfo().originatingElementValue());
            }
            if (actualContract.isList()) {
                throw new CodegenException("Dependency has Optional<List<>> - this is not supported, Lists are empty if no service satisfies them, so please use List<> instead", param.elementInfo().originatingElementValue());
            }
            isServiceInstance = this.isServiceInstance(actualContract);
        } else if (this.isServiceInstance(declared)) {
            cardinality = "REQUIRED";
            isServiceInstance = true;
            TypeName actualContract = (TypeName)declared.typeArguments().getFirst();
            if (actualContract.isSupplier()) {
                throw new CodegenException("Dependency has ServiceInstance<Supplier<>> - this is not supported, please use Supplier<ServiceInstance<>>", param.elementInfo().originatingElementValue());
            }
            if (actualContract.isOptional()) {
                throw new CodegenException("Dependency has ServiceInstance<Optional<>> - this is not supported, please use Optional<ServiceInstance<?>>", param.elementInfo().originatingElementValue());
            }
            if (actualContract.isList()) {
                throw new CodegenException("Dependency has ServiceInstance<List<>> - this is not supported, please useList<ServiceInstance<>>", param.elementInfo().originatingElementValue());
            }
        } else if (declared.isList()) {
            cardinality = "LIST";
            TypeName actualContract = (TypeName)declared.typeArguments().getFirst();
            if (actualContract.isSupplier()) {
                throw new CodegenException("Dependency has List<Supplier<>> - this is not supported, please use Supplier<List<>>", param.elementInfo().originatingElementValue());
            }
            if (actualContract.isOptional()) {
                throw new CodegenException("Dependency has List<Optional<>> - this is not supported", param.elementInfo().originatingElementValue());
            }
            if (actualContract.isList()) {
                throw new CodegenException("Dependency has List<List<>> - this is not supported", param.elementInfo().originatingElementValue());
            }
            isServiceInstance = this.isServiceInstance(actualContract);
        } else {
            cardinality = "REQUIRED";
            isServiceInstance = false;
        }
        return new DependencyMetadata(cardinality, isServiceInstance, isSupplier);
    }

    private boolean isServiceInstance(TypeName typeName) {
        return typeName.equals((Object)ServiceCodegenTypes.SERVICE_SERVICE_INSTANCE);
    }

    private String ipIdDescription(TypeInfo service, ParamDefinition param) {
        boolean elementPublic;
        TypeName serviceType = service.typeName();
        StringBuilder result = new StringBuilder("Injection point dependency for ");
        boolean servicePublic = service.accessModifier() == AccessModifier.PUBLIC;
        boolean bl = elementPublic = param.owningElement().accessModifier() == AccessModifier.PUBLIC;
        if (servicePublic) {
            result.append("{@link ").append(serviceType.fqName());
            if (!elementPublic) {
                result.append("}");
            }
        } else {
            result.append(serviceType.classNameWithEnclosingNames());
        }
        if (servicePublic && elementPublic) {
            switch (param.kind()) {
                case CONSTRUCTOR: {
                    result.append("#").append(serviceType.className()).append("(").append(this.toDescriptionSignature(param.owningElement(), true)).append(")");
                    break;
                }
                case METHOD: {
                    result.append("#").append(param.owningElement().elementName()).append("(").append(this.toDescriptionSignature(param.owningElement(), true)).append(")");
                    break;
                }
                case FIELD: {
                    result.append("#").append(param.elementInfo().elementName());
                    break;
                }
            }
            result.append("}");
        } else {
            switch (param.kind()) {
                case CONSTRUCTOR: {
                    result.append("(").append(this.toDescriptionSignature(param.owningElement(), false)).append(")");
                    break;
                }
                case METHOD: {
                    result.append("#").append(param.owningElement().elementName()).append("(").append(this.toDescriptionSignature(param.owningElement(), false)).append(")");
                    break;
                }
                case FIELD: {
                    result.append(".").append(param.elementInfo().elementName());
                    break;
                }
            }
        }
        switch (param.kind()) {
            case CONSTRUCTOR: 
            case METHOD: {
                result.append(", parameter ").append(param.elementInfo().elementName());
                break;
            }
        }
        result.append(".");
        return result.toString();
    }

    private String toDescriptionSignature(TypedElementInfo method, boolean javadoc) {
        if (javadoc) {
            return method.parameterArguments().stream().map(it -> it.typeName().fqName()).collect(Collectors.joining(", "));
        }
        return method.parameterArguments().stream().map(it -> it.typeName().classNameWithEnclosingNames() + " " + it.elementName()).collect(Collectors.joining(", "));
    }

    private void dependenciesField(ClassModel.Builder classModel, List<ParamDefinition> params) {
        classModel.addField(dependencies -> ((Field.Builder)((Field.Builder)((Field.Builder)dependencies.isStatic(true).isFinal(true).name("DEPENDENCIES")).type(ServiceCodegenTypes.LIST_OF_DEPENDENCIES).addContent(List.class)).addContent(".of(").update(it -> {
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                it.addContent(((ParamDefinition)iterator.next()).constantName());
                if (!iterator.hasNext()) continue;
                it.addContent(", ");
            }
        })).addContent(")"));
    }

    private void methodFields(ClassModel.Builder classModel, List<MethodDefinition> methods) {
        for (MethodDefinition method : methods) {
            classModel.addField(methodField -> ((Field.Builder)methodField.isStatic(true).isFinal(true).name(method.constantName())).type(TypeNames.STRING).update(it -> this.fieldForMethodConstantBody(method, (Field.Builder)it)));
        }
    }

    private void fieldForMethodConstantBody(MethodDefinition method, Field.Builder fieldBuilder) {
        fieldBuilder.addContent("\"").addContent(method.declaringType().fqName()).addContent(".").addContent(method.methodName()).addContent("(").addContent(method.params().stream().map(ParamDefinition::declaredType).map(rec$ -> ((TypeName)rec$).resolvedName()).collect(Collectors.joining(","))).addContent(")\"");
    }

    private void fieldElementField(ClassModel.Builder classModel, TypedElementInfo fieldElement) {
        classModel.addField(ctorElement -> ((Field.Builder)ctorElement.isStatic(true).isFinal(true).name(this.fieldElementConstantName(fieldElement.elementName()))).type(TypeNames.TYPED_ELEMENT_INFO).addContentCreate(fieldElement));
    }

    private String fieldElementConstantName(String elementName) {
        return "FIELD_INFO_" + CodegenUtil.toConstantName((String)elementName);
    }

    private void constructorElementField(ClassModel.Builder classModel, TypedElementInfo constructorInjectElement) {
        classModel.addField(ctorElement -> ((Field.Builder)ctorElement.isStatic(true).isFinal(true).name("CTOR_ELEMENT")).type(TypeNames.TYPED_ELEMENT_INFO).addContentCreate(constructorInjectElement));
    }

    private void serviceTypeMethod(ClassModel.Builder classModel, DescribedService service) {
        classModel.addField(field -> ((Field.Builder)field.isStatic(true).isFinal(true).accessModifier(AccessModifier.PRIVATE).type(TypeNames.TYPE_NAME).name("SERVICE_TYPE")).addContentCreate(service.serviceDescriptor().typeName().genericTypeName()));
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).name("serviceType")).addContentLine("return SERVICE_TYPE;"));
    }

    private void providedTypeMethod(ClassModel.Builder classModel, DescribedService service) {
        if (!service.isFactory() && service.superType().empty()) {
            return;
        }
        TypeName providedType = service.isFactory() ? service.providedDescriptor().typeName() : service.serviceDescriptor().typeName();
        classModel.addField(field -> ((Field.Builder)field.isStatic(true).isFinal(true).accessModifier(AccessModifier.PRIVATE).type(TypeNames.TYPE_NAME).name("PROVIDED_TYPE")).addContentCreate(providedType));
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).name("providedType")).addContentLine("return PROVIDED_TYPE;"));
    }

    private void descriptorTypeMethod(ClassModel.Builder classModel, DescribedService service) {
        classModel.addField(field -> ((Field.Builder)field.isStatic(true).isFinal(true).accessModifier(AccessModifier.PRIVATE).type(TypeNames.TYPE_NAME).name("TYPE")).addContentCreate(service.descriptorType().genericTypeName()));
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).name("descriptorType")).addContentLine("return TYPE;"));
    }

    private void contractsMethod(ClassModel.Builder classModel, DescribedService service, Set<ResolvedType> serviceContracts, Set<ResolvedType> factoryContracts) {
        ServiceSuperType superType = service.superType();
        if (!serviceContracts.isEmpty() || superType.present()) {
            classModel.addField(contractsField -> ((Field.Builder)((Field.Builder)((Field.Builder)contractsField.isStatic(true).isFinal(true).name("CONTRACTS")).type(ServiceCodegenTypes.SET_OF_RESOLVED_TYPES).addContent(Set.class)).addContent(".of(").update(it -> {
                Iterator iterator = serviceContracts.iterator();
                while (iterator.hasNext()) {
                    it.addContentCreate((ResolvedType)iterator.next());
                    if (!iterator.hasNext()) continue;
                    it.addContent(", ");
                }
            })).addContent(")"));
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).name("contracts")).returnType(ServiceCodegenTypes.SET_OF_RESOLVED_TYPES).addContentLine("return CONTRACTS;"));
        }
        if (!factoryContracts.isEmpty() || superType.present()) {
            classModel.addField(contractsField -> ((Field.Builder)((Field.Builder)((Field.Builder)contractsField.isStatic(true).isFinal(true).name("FACTORY_CONTRACTS")).type(ServiceCodegenTypes.SET_OF_RESOLVED_TYPES).addContent(Set.class)).addContent(".of(").update(it -> {
                Iterator iterator = factoryContracts.iterator();
                while (iterator.hasNext()) {
                    it.addContentCreate((ResolvedType)iterator.next());
                    if (!iterator.hasNext()) continue;
                    it.addContent(", ");
                }
            })).addContent(")"));
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).name("factoryContracts")).returnType(ServiceCodegenTypes.SET_OF_RESOLVED_TYPES).addContentLine("return FACTORY_CONTRACTS;"));
        }
    }

    private void dependenciesMethod(ClassModel.Builder classModel, DescribedService service, List<ParamDefinition> params) {
        boolean hasSuperType = service.superType().present();
        if (hasSuperType || !params.isEmpty()) {
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(ServiceCodegenTypes.LIST_OF_DEPENDENCIES).name("dependencies")).update(it -> {
                if (hasSuperType) {
                    ((Method.Builder)((Method.Builder)it.addContent("return ")).addContent(ServiceCodegenTypes.SERVICE_G_DEPENDENCY_SUPPORT)).addContentLine(".combineDependencies(DEPENDENCIES, super.dependencies());");
                } else {
                    it.addContentLine("return DEPENDENCIES;");
                }
            }));
        }
    }

    private void instantiateMethod(ClassModel.Builder classModel, DescribedService service, List<ParamDefinition> params) {
        DescribedType serviceDescriptor = service.serviceDescriptor();
        if (serviceDescriptor.isAbstract()) {
            return;
        }
        DescribedElements elements = serviceDescriptor.elements();
        TypeName toInstantiate = elements.methodsIntercepted() ? this.interceptedTypeName(serviceDescriptor.typeName()) : serviceDescriptor.typeName();
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(serviceDescriptor.typeName()).name("instantiate")).addParameter(ctxParam -> ctxParam.type(ServiceCodegenTypes.SERVICE_DEPENDENCY_CONTEXT).name("ctx__helidonInject"))).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name("interceptMeta__helidonInject"))).update(it -> {
            if (elements.constructorIntercepted()) {
                this.createInstantiateInterceptBody((Method.Builder)it, params);
            } else {
                this.createInstantiateBody(toInstantiate, (Method.Builder)it, params, elements.methodsIntercepted());
            }
        }));
        if (elements.constructorIntercepted()) {
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.returnType(serviceDescriptor.typeName()).name("doInstantiate")).accessModifier(AccessModifier.PRIVATE)).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name("interceptMeta"))).addParameter(ctrParams -> ctrParams.type(TypeName.create((String)"Object...")).name("params"))).update(it -> this.createDoInstantiateBody(toInstantiate, (Method.Builder)it, params, elements.methodsIntercepted())));
        }
    }

    private void createInstantiateInterceptBody(Method.Builder method, List<ParamDefinition> params) {
        List<ParamDefinition> constructorParams = ServiceDescriptorCodegen.declareCtrParamsAndGetThem(method, params);
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContentLine("try {")).addContentLine("return interceptMeta__helidonInject.createInvoker(this,")).increaseContentPadding()).increaseContentPadding()).increaseContentPadding()).addContentLine("QUALIFIERS,")).addContentLine("ANNOTATIONS,")).addContentLine("CTOR_ELEMENT,")).addContentLine("params__helidonInject -> doInstantiate(interceptMeta__helidonInject, params__helidonInject),")).addContent(Set.class)).addContentLine(".of())")).decreaseContentPadding()).decreaseContentPadding()).addContent(".invoke(")).addContent(constructorParams.stream().map(ParamDefinition::ipParamName).collect(Collectors.joining(", ")))).addContentLine(");")).decreaseContentPadding()).addContentLine("} catch (RuntimeException e__helidonInject) {")).addContentLine("throw e__helidonInject;")).addContentLine("} catch (Exception e__helidonInject) {")).addContent(" throw new ")).addContent(ServiceCodegenTypes.INTERCEPT_EXCEPTION)).addContentLine("(\"Failed to instantiate \" + SERVICE_TYPE.fqName(), e__helidonInject, false);")).addContentLine("}");
    }

    private void createInstantiateBody(TypeName serviceType, Method.Builder method, List<ParamDefinition> params, boolean interceptedMethods) {
        List<ParamDefinition> constructorParams = ServiceDescriptorCodegen.declareCtrParamsAndGetThem(method, params);
        String paramsDeclaration = constructorParams.stream().map(ParamDefinition::ipParamName).collect(Collectors.joining(", "));
        if (interceptedMethods) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("return new ")).addContent(serviceType.genericTypeName())).addContentLine("(interceptMeta__helidonInject,")).increaseContentPadding()).increaseContentPadding()).addContentLine("this,")).addContentLine("QUALIFIERS,")).addContent("ANNOTATIONS");
            if (!constructorParams.isEmpty()) {
                method.addContentLine(",");
                method.addContent(paramsDeclaration);
            }
            ((Method.Builder)((Method.Builder)method.addContentLine(");")).decreaseContentPadding()).decreaseContentPadding();
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("return new ")).addContent(serviceType.genericTypeName())).addContent("(")).addContent(paramsDeclaration)).addContentLine(");");
        }
        boolean hasGenericType = constructorParams.stream().anyMatch(it -> !it.declaredType().typeArguments().isEmpty());
        if (hasGenericType) {
            method.addAnnotation(Annotation.create((TypeName)TypeName.create(SuppressWarnings.class), (String)"unchecked"));
        }
    }

    private void createDoInstantiateBody(TypeName serviceType, Method.Builder method, List<ParamDefinition> params, boolean interceptedMethods) {
        List<ParamDefinition> constructorParams = params.stream().filter(it -> it.kind() == ElementKind.CONSTRUCTOR).toList();
        ArrayList<CallSite> paramDeclarations = new ArrayList<CallSite>();
        for (int i = 0; i < constructorParams.size(); ++i) {
            ParamDefinition param = constructorParams.get(i);
            paramDeclarations.add((CallSite)((Object)("(" + param.declaredType().resolvedName() + ") params[" + i + "]")));
        }
        String paramsDeclaration = String.join((CharSequence)", ", paramDeclarations);
        if (interceptedMethods) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("return new ")).addContent(serviceType.genericTypeName())).addContentLine("(interceptMeta,")).addContentLine("this,")).addContentLine("QUALIFIERS,")).addContent("ANNOTATIONS");
            if (!constructorParams.isEmpty()) {
                method.addContentLine(",");
                method.addContent(paramsDeclaration);
            }
            method.addContentLine(");");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("return new ")).addContent(serviceType.genericTypeName())).addContent("(")).addContent(paramsDeclaration)).addContentLine(");");
        }
    }

    private void isAbstractMethod(ClassModel.Builder classModel, DescribedService service) {
        boolean isAbstract = service.serviceDescriptor().isAbstract();
        if (!isAbstract && service.superType().empty()) {
            return;
        }
        classModel.addMethod(isAbstractMethod -> ((Method.Builder)((Method.Builder)isAbstractMethod.name("isAbstract")).returnType(TypeNames.PRIMITIVE_BOOLEAN).addAnnotation(Annotations.OVERRIDE)).addContentLine("return " + isAbstract + ";"));
    }

    private void injectMethod(ClassModel.Builder classModel, DescribedService service, List<ParamDefinition> params, List<MethodDefinition> methods) {
        List<ParamDefinition> fields = params.stream().filter(it -> it.kind() == ElementKind.FIELD).toList();
        if (fields.isEmpty() && methods.isEmpty()) {
            return;
        }
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).name("inject")).addParameter(ctxParam -> ctxParam.type(ServiceCodegenTypes.SERVICE_DEPENDENCY_CONTEXT).name("ctx__helidonInject"))).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name("interceptMeta__helidonInject"))).addParameter(injectedParam -> injectedParam.type(ServiceCodegenTypes.SET_OF_STRINGS).name("injected__helidonInject"))).addParameter(instanceParam -> instanceParam.type(ServiceCodegenTypes.GENERIC_T_TYPE).name("instance__helidonInject"))).update(it -> this.createInjectBody((Method.Builder)it, service.superType().present(), methods, fields, service.serviceDescriptor().elements().intercepted(), service.serviceDescriptor().elements().interceptedElements())));
    }

    private void createInjectBody(Method.Builder methodBuilder, boolean hasSuperType, List<MethodDefinition> methods, List<ParamDefinition> fields, boolean canIntercept, List<TypedElements.ElementMeta> maybeIntercepted) {
        boolean hasGenericType;
        boolean bl = hasGenericType = methods.stream().flatMap(it -> it.params().stream()).anyMatch(it -> !it.declaredType().typeArguments().isEmpty()) || fields.stream().anyMatch(it -> !it.declaredType().typeArguments().isEmpty());
        if (hasGenericType) {
            methodBuilder.addAnnotation(Annotation.create((TypeName)TypeName.create(SuppressWarnings.class), (String)"unchecked"));
        }
        for (MethodDefinition method : methods) {
            if (method.isInjectionPoint() && !method.isFinal()) {
                methodBuilder.addContentLine("boolean " + method.invokeName() + " = injected__helidonInject.add(" + method.constantName() + ");");
                continue;
            }
            methodBuilder.addContentLine("injected__helidonInject.add(" + method.constantName() + ");");
        }
        methodBuilder.addContentLine("");
        if (hasSuperType) {
            methodBuilder.addContentLine("super.inject(ctx__helidonInject, interceptMeta__helidonInject, injected__helidonInject, instance__helidonInject);");
            methodBuilder.addContentLine("");
        }
        for (ParamDefinition field : fields) {
            this.injectFieldBody(methodBuilder, field, canIntercept, maybeIntercepted);
        }
        if (!fields.isEmpty()) {
            methodBuilder.addContentLine("");
        }
        for (MethodDefinition method : methods) {
            if (!method.isInjectionPoint()) continue;
            if (!method.isFinal()) {
                methodBuilder.addContentLine("if (" + method.invokeName() + ") {");
            }
            List<ParamDefinition> params = method.params();
            methodBuilder.addContent("instance__helidonInject." + method.methodName() + "(");
            if (params.size() > 2) {
                methodBuilder.addContentLine("");
                methodBuilder.increaseContentPadding();
                methodBuilder.increaseContentPadding();
                for (i = 0; i < params.size(); ++i) {
                    param = params.get(i);
                    param.assignmentHandler().accept((ContentBuilder<?>)methodBuilder);
                    if (i == params.size() - 1) continue;
                    methodBuilder.addContentLine(",");
                }
                methodBuilder.decreaseContentPadding();
                methodBuilder.decreaseContentPadding();
            } else {
                for (i = 0; i < params.size(); ++i) {
                    param = params.get(i);
                    param.assignmentHandler().accept((ContentBuilder<?>)methodBuilder);
                    if (i == params.size() - 1) continue;
                    methodBuilder.addContent(",");
                }
            }
            methodBuilder.addContentLine(");");
            if (!method.isFinal()) {
                methodBuilder.addContentLine("}");
            }
            methodBuilder.addContentLine("");
        }
    }

    private void injectFieldBody(Method.Builder methodBuilder, ParamDefinition field, boolean canIntercept, List<TypedElements.ElementMeta> maybeIntercepted) {
        if (canIntercept && this.isIntercepted(maybeIntercepted, field.elementInfo())) {
            methodBuilder.addContentLine(field.declaredType().resolvedName() + " " + field.ipParamName() + " = ctx__helidonInject.dependency(" + field.constantName() + ");");
            String interceptorsName = field.ipParamName() + "__interceptors";
            String constantName = this.fieldElementConstantName(field.ipParamName());
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)methodBuilder.addContent("var ")).addContent(interceptorsName)).addContent(" = interceptMeta__helidonInject.interceptors(QUALIFIERS, ANNOTATIONS, ")).addContent(constantName)).addContentLine(");")).addContent("if(")).addContent(interceptorsName)).addContentLine(".isEmpty() {")).addContent("instance__helidonInject.")).addContent(field.ipParamName())).addContent(" = ")).addContent(field.ipParamName())).addContentLine(";")).addContentLine("} else {")).addContent("instance__helidonInject.")).addContent(field.ipParamName())).addContent(" = interceptMeta__helidonInject.invoke(this,")).addContentLine("ANNOTATIONS,")).addContent(constantName)).addContentLine(",")).addContent(interceptorsName)).addContentLine(",")).addContent("params__helidonInject -> ")).addContent(field.constantName())).addContentLine(".type().cast(params__helidonInject[0]),")).addContent(field.ipParamName())).addContentLine(");")).addContentLine("}");
        } else {
            ((Method.Builder)((Method.Builder)methodBuilder.addContent("instance__helidonInject." + field.ipParamName() + " = ")).update(it -> field.assignmentHandler().accept((ContentBuilder<?>)it))).addContentLine(";");
        }
    }

    private boolean isIntercepted(List<TypedElements.ElementMeta> maybeIntercepted, TypedElementInfo typedElementInfo) {
        for (TypedElements.ElementMeta methodMetadata : maybeIntercepted) {
            if (methodMetadata.element() != typedElementInfo) continue;
            return true;
        }
        return false;
    }

    private void postConstructMethod(ClassModel.Builder classModel, DescribedService service) {
        TypeInfo typeInfo = service.serviceDescriptor().typeInfo();
        TypeName typeName = service.serviceDescriptor().typeName();
        this.lifecycleMethod(typeInfo, ServiceCodegenTypes.SERVICE_ANNOTATION_POST_CONSTRUCT).ifPresent(method -> classModel.addMethod(postConstruct -> ((Method.Builder)((Method.Builder)((Method.Builder)postConstruct.name("postConstruct")).addAnnotation(Annotations.OVERRIDE)).addParameter(instance -> instance.type(typeName).name("instance"))).addContentLine("instance." + method.elementName() + "();")));
    }

    private void preDestroyMethod(ClassModel.Builder classModel, DescribedService service) {
        TypeInfo typeInfo = service.serviceDescriptor().typeInfo();
        TypeName typeName = service.serviceDescriptor().typeName();
        this.lifecycleMethod(typeInfo, ServiceCodegenTypes.SERVICE_ANNOTATION_PRE_DESTROY).ifPresent(method -> classModel.addMethod(preDestroy -> ((Method.Builder)((Method.Builder)((Method.Builder)preDestroy.name("preDestroy")).addAnnotation(Annotations.OVERRIDE)).addParameter(instance -> instance.type(typeName).name("instance"))).addContentLine("instance." + method.elementName() + "();")));
    }

    private Optional<TypedElementInfo> lifecycleMethod(TypeInfo typeInfo, TypeName annotationType) {
        List list = typeInfo.elementInfo().stream().filter(ElementInfoPredicates.hasAnnotation((TypeName)annotationType)).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        if (list.size() > 1) {
            throw new IllegalStateException("There is more than one method annotated with " + annotationType.fqName() + ", which is not allowed on type " + typeInfo.typeName().fqName());
        }
        TypedElementInfo method = (TypedElementInfo)list.getFirst();
        if (method.accessModifier() == AccessModifier.PRIVATE) {
            throw new IllegalStateException("Method annotated with " + annotationType.fqName() + ", is private, which is not supported: " + typeInfo.typeName().fqName() + "#" + method.elementName());
        }
        if (!method.parameterArguments().isEmpty()) {
            throw new IllegalStateException("Method annotated with " + annotationType.fqName() + ", has parameters, which is not supported: " + typeInfo.typeName().fqName() + "#" + method.elementName());
        }
        if (!method.typeName().equals((Object)TypeNames.PRIMITIVE_VOID)) {
            throw new IllegalStateException("Method annotated with " + annotationType.fqName() + ", is not void, which is not supported: " + typeInfo.typeName().fqName() + "#" + method.elementName());
        }
        return Optional.of(method);
    }

    private void qualifiersMethod(ClassModel.Builder classModel, DescribedService service) {
        Set<Annotation> qualifiers = service.qualifiers();
        Qualifiers.generateQualifiersConstant(classModel, qualifiers);
        if (qualifiers.isEmpty() && service.superType().empty()) {
            return;
        }
        classModel.addMethod(qualifiersMethod -> ((Method.Builder)((Method.Builder)qualifiersMethod.name("qualifiers")).addAnnotation(Annotations.OVERRIDE)).returnType(ServiceCodegenTypes.SET_OF_QUALIFIERS).addContentLine("return QUALIFIERS;"));
    }

    private void scopeMethod(ClassModel.Builder classModel, DescribedService service) {
        TypeName scope = service.scope();
        if (scope.packageName().equals(ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON.packageName()) && scope.enclosingNames().size() == 1 && ((String)scope.enclosingNames().getFirst()).equals("Service")) {
            classModel.addMethod(scopeMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)scopeMethod.name("scope")).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).addContent("return ")).addContent(scope)).addContentLine(".TYPE;"));
        } else {
            classModel.addField(scopesField -> ((Field.Builder)scopesField.isStatic(true).isFinal(true).name("SCOPE")).type(TypeNames.TYPE_NAME).addContentCreate(scope));
            classModel.addMethod(scopeMethod -> ((Method.Builder)((Method.Builder)scopeMethod.name("scope")).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).addContentLine("return SCOPE;"));
        }
    }

    private void weightMethod(ClassModel.Builder classModel, DescribedService service) {
        TypeInfo typeInfo = service.serviceDescriptor().typeInfo();
        boolean hasSuperType = service.superType().present();
        Optional<Double> weight = this.weight(typeInfo);
        if (!hasSuperType && weight.isEmpty()) {
            return;
        }
        double usedWeight = weight.orElse(100.0);
        if (!hasSuperType && usedWeight == 100.0) {
            return;
        }
        classModel.addMethod(weightMethod -> ((Method.Builder)((Method.Builder)weightMethod.name("weight")).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.PRIMITIVE_DOUBLE).addContentLine("return " + usedWeight + ";"));
    }

    private Optional<Double> weight(TypeInfo typeInfo) {
        return typeInfo.findAnnotation(TypeName.create(Weight.class)).flatMap(rec$ -> ((Annotation)rec$).doubleValue());
    }

    private void runLevelMethod(ClassModel.Builder classModel, DescribedService service) {
        TypeInfo typeInfo = service.serviceDescriptor().typeInfo();
        boolean hasSuperType = service.superType().present();
        Optional<Double> runLevel = this.runLevel(typeInfo);
        if (!hasSuperType && runLevel.isEmpty()) {
            return;
        }
        if (runLevel.isEmpty()) {
            classModel.addMethod(runLevelMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)runLevelMethod.name("runLevel")).addAnnotation(Annotations.OVERRIDE)).returnType(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(TypeNames.BOXED_DOUBLE)).build()).addContent("return ")).addContent(Optional.class)).addContentLine(".empty();"));
            return;
        }
        double usedRunLevel = runLevel.get();
        classModel.addMethod(runLevelMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)runLevelMethod.name("runLevel")).addAnnotation(Annotations.OVERRIDE)).returnType(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(TypeNames.BOXED_DOUBLE)).build()).addContent("return ")).addContent(Optional.class)).addContent(".of(")).addContent(String.valueOf(usedRunLevel))).addContentLine("D);"));
    }

    private Optional<Double> runLevel(TypeInfo typeInfo) {
        return typeInfo.findAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_RUN_LEVEL).flatMap(rec$ -> ((Annotation)rec$).doubleValue());
    }

    private TypeName descriptorInstanceType(TypeName serviceType, TypeName descriptorType) {
        return ((TypeName.Builder)TypeName.builder((TypeName)descriptorType).addTypeArgument(serviceType)).build();
    }

    private TypeName generateProvidedInterceptionDelegate(RegistryRoundContext roundContext, DescribedService service) {
        DescribedType providedDescriptor = service.providedDescriptor();
        TypeInfo typeInfo = providedDescriptor.typeInfo();
        TypeName expectedInterceptionDelegate = this.interception.interceptedDelegateType(typeInfo.typeName());
        if (this.ctx.typeInfo(expectedInterceptionDelegate).isPresent()) {
            return expectedInterceptionDelegate;
        }
        if (this.canDelegate(service.serviceDescriptor().typeInfo(), typeInfo)) {
            this.interception.generateDelegateInterception(roundContext, typeInfo, providedDescriptor.elements(), expectedInterceptionDelegate);
            return expectedInterceptionDelegate;
        }
        throw new CodegenException("Attempting to create delegate interception for non interface type. If the type is ready to be delegated, annotate it with " + ServiceCodegenTypes.INTERCEPTION_DELEGATE.fqName() + ", or annotate the service provider with " + ServiceCodegenTypes.INTERCEPTION_EXTERNAL_DELEGATE.fqName() + "(" + typeInfo.typeName().classNameWithEnclosingNames() + ".class) if it is not under your control", service.serviceDescriptor().typeInfo().originatingElementValue());
    }

    private boolean canDelegate(TypeInfo providerType, TypeInfo providedType) {
        if (providedType.kind() == ElementKind.INTERFACE) {
            return true;
        }
        if (providedType.hasAnnotation(ServiceCodegenTypes.INTERCEPTION_DELEGATE)) {
            return true;
        }
        return providerType.hasAnnotation(ServiceCodegenTypes.INTERCEPTION_EXTERNAL_DELEGATE) && providerType.annotation(ServiceCodegenTypes.INTERCEPTION_EXTERNAL_DELEGATE).typeValue().map(it -> providedType.typeName().equals(it)).orElse(false) != false;
    }

    private void generateDelegationService(RegistryRoundContext roundContext, DescribedService service, TypeName delegateType) {
        TypeName typeName = service.serviceDescriptor().typeName();
        String typeNameSuffix = "__Interception_Wrapper";
        TypeName wrapperType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(typeName.packageName())).className(typeName.classNameWithEnclosingNames().replace('.', '_') + typeNameSuffix)).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(wrapperType).addAnnotation(Annotation.create((TypeName)service.scope()))).addInterface(service.providerInterface())).superType(service.interceptionWrapperSuperType())).accessModifier(AccessModifier.PACKAGE_PRIVATE).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)typeName, (TypeName)wrapperType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)typeName, (TypeName)wrapperType, (String)"1", (String)""));
        service.qualifiers().forEach(x$0 -> {
            ClassModel.Builder cfr_ignored_0 = (ClassModel.Builder)classModel.addAnnotation(x$0);
        });
        classModel.addField(interceptMeta -> ((Field.Builder)interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name("interceptMeta")).isFinal(true).accessModifier(AccessModifier.PRIVATE));
        classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addParameter(delegate -> ((Parameter.Builder)delegate.update(it -> service.qualifiers().forEach(x$0 -> {
            Parameter.Builder cfr_ignored_0 = (Parameter.Builder)it.addAnnotation(x$0);
        }))).type(typeName).name("delegate"))).addParameter(interceptMeta -> interceptMeta.type(ServiceCodegenTypes.INTERCEPT_METADATA).name("interceptMeta"))).addContentLine("super(delegate);")).addContentLine("this.interceptMeta = interceptMeta;"));
        TypeName descriptorType = service.descriptorType();
        classModel.addMethod(wrap -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)wrap.addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PROTECTED)).name("wrap")).returnType(service.providedDescriptor().typeName()).addParameter(instance -> instance.type(service.providedDescriptor().typeName()).name("instance"))).addContent("return ")).addContent(delegateType)).addContentLine(".create(")).increaseContentPadding()).increaseContentPadding()).addContentLine("interceptMeta,")).addContent(descriptorType)).addContentLine(".INSTANCE,")).addContentLine("instance);"));
        roundContext.addGeneratedType(wrapperType, classModel, typeName, new Object[]{service.serviceDescriptor().typeInfo().originatingElementValue()});
    }

    private void factoryType(ClassModel.Builder classModel, DescribedService service, FactoryType factoryType) {
        if (service.superType().empty() && factoryType == FactoryType.SERVICE) {
            return;
        }
        classModel.addMethod(providerTypeMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)providerTypeMethod.name("factoryType")).accessModifier(AccessModifier.PUBLIC)).addAnnotation(Annotations.OVERRIDE)).returnType(ServiceCodegenTypes.SERVICE_FACTORY_TYPE).addContent("return ")).addContent(ServiceCodegenTypes.SERVICE_FACTORY_TYPE)).addContent(".")).addContent(factoryType.name())).addContentLine(";"));
    }

    private void methodElementFields(ClassModel.Builder classModel, DescribedService service) {
        Set<ElementSignature> elementSignatures = service.serviceDescriptor().elements().interceptedMethods();
        List interceptedElements = service.serviceDescriptor().elements().interceptedElements().stream().filter(it -> elementSignatures.contains(it.element().signature())).collect(Collectors.toUnmodifiableList());
        TypeInfo typeInfo = service.serviceDescriptor().typeInfo();
        for (TypedElements.ElementMeta element : interceptedElements) {
            TypedElementInfo method = element.element();
            String uniqueName = this.ctx.uniqueName(typeInfo, method);
            String constantName = "METHOD_" + CodegenUtil.toConstantName((String)uniqueName);
            ArrayList<Annotation> elementAnnotations = new ArrayList<Annotation>(method.annotations());
            ServiceDescriptorCodegen.addInterfaceAnnotations(elementAnnotations, element.abstractMethods());
            TypedElementInfo typedElementInfo = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().from(method)).annotations(elementAnnotations)).build();
            classModel.addField(constant -> ((Field.Builder)((Field.Builder)constant.description("Element info for method: {@code " + String.valueOf(method.signature()) + "}.")).accessModifier(AccessModifier.PUBLIC).isStatic(true).isFinal(true).type(TypeNames.TYPED_ELEMENT_INFO).name(constantName)).addContentCreate(typedElementInfo));
        }
    }

    private void generateInterceptedType(RegistryRoundContext roundContext, TypeInfo typeInfo, DescribedService service, TypedElementInfo constructorInjectElement) {
        TypeName typeName = service.serviceDescriptor().typeName();
        TypeName interceptedType = this.interceptedTypeName(typeName);
        InterceptedTypeGenerator generator = new InterceptedTypeGenerator(this.ctx, typeInfo, typeName, service.descriptorType(), interceptedType, constructorInjectElement, service.serviceDescriptor().elements().interceptedElements().stream().filter(it -> it.element().kind() == ElementKind.METHOD).toList());
        roundContext.addGeneratedType(interceptedType, generator.generate(), typeName, new Object[]{typeInfo.originatingElementValue()});
    }

    private TypeName interceptedTypeName(TypeName serviceType) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)serviceType).className(serviceType.classNameWithEnclosingNames().replace('.', '_') + "__Intercepted")).enclosingNames(List.of())).build();
    }

    private void qualifiedProvider(ClassModel.Builder classModel, DescribedService service) {
        TypeName typeName = service.qualifiedProviderQualifier();
        if (typeName == null) {
            return;
        }
        classModel.addInterface(ServiceCodegenTypes.SERVICE_G_QUALIFIED_FACTORY_DESCRIPTOR);
        classModel.addField(qpField -> ((Field.Builder)qpField.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).name("QP_QUALIFIER")).type(TypeNames.TYPE_NAME).addContentCreate(typeName));
        classModel.addMethod(qpMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)qpMethod.accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.TYPE_NAME).name("qualifierType")).addAnnotation(Annotations.OVERRIDE)).addContentLine("return QP_QUALIFIER;"));
    }

    private void scopeHandler(TypeInfo typeInfo, ClassModel.Builder classModel, Set<ResolvedType> contracts) {
        if (contracts.stream().noneMatch(it -> it.type().equals((Object)ServiceCodegenTypes.SERVICE_SCOPE_HANDLER))) {
            return;
        }
        TypeName handledScope = this.findHandledScope(typeInfo);
        classModel.addInterface(ServiceCodegenTypes.SERVICE_G_SCOPE_HANDLER_DESCRIPTOR);
        classModel.addField(scopeField -> ((Field.Builder)scopeField.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).name("SCOPE_HANDLER_SCOPE")).type(TypeNames.TYPE_NAME).addContentCreate(handledScope));
        classModel.addMethod(handledScopeMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)handledScopeMethod.accessModifier(AccessModifier.PUBLIC)).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).name("handledScope")).addContentLine("return SCOPE_HANDLER_SCOPE;"));
    }

    private TypeName findHandledScope(TypeInfo typeInfo) {
        return typeInfo.findAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED).flatMap(rec$ -> ((Annotation)rec$).value()).map(TypeName::create).orElseThrow(() -> new CodegenException("Type implementing ScopeHandler must be qualified with the scope type name: " + String.valueOf(typeInfo.typeName())));
    }

    private void createForMethod(ClassModel.Builder classModel, DescribedService service) {
        TypeInfo serviceTypeInfo = service.serviceDescriptor().typeInfo();
        TypeName serviceTypeName = service.serviceDescriptor().typeName();
        Optional createFor = serviceTypeInfo.findAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PER_INSTANCE);
        if (service.superType().empty() && createFor.isEmpty()) {
            return;
        }
        if (createFor.isPresent()) {
            Optional createForTypeInfo;
            if (service.providerType() != FactoryType.SERVICE) {
                throw new CodegenException("Service " + serviceTypeName.classNameWithEnclosingNames() + " is annotated with @" + ServiceCodegenTypes.SERVICE_ANNOTATION_PER_INSTANCE.classNameWithEnclosingNames() + ", and as such it must not implement any provider interfaces. Provider type: " + String.valueOf((Object)service.providerType()), serviceTypeInfo.originatingElementValue());
            }
            TypeName createForType = (TypeName)((Annotation)createFor.get()).typeValue().orElseThrow(() -> new CodegenException(ServiceCodegenTypes.SERVICE_ANNOTATION_PER_INSTANCE.fqName() + ".value() is required, yet not found on type: " + serviceTypeName.fqName()));
            String createForClassName = createForType.className();
            if (createForClassName.endsWith("Blueprint") && (createForTypeInfo = this.ctx.typeInfo(createForType)).isPresent() && ((TypeInfo)createForTypeInfo.get()).hasAnnotation(ServiceCodegenTypes.BUILDER_BLUEPRINT)) {
                createForType = ((TypeName.Builder)TypeName.builder((TypeName)createForType).className(createForClassName.substring(0, createForClassName.length() - "Blueprint".length()))).build();
            }
            if (createForType.packageName().isBlank()) {
                throw new CodegenException(ServiceCodegenTypes.SERVICE_ANNOTATION_PER_INSTANCE.classNameWithEnclosingNames() + " type used on " + serviceTypeName.fqName() + " does not have a package defined. Package is mandatory. If the type is a generated prototype, please use the Blueprint type instead.");
            }
            TypeName createForTypeFinal = createForType;
            classModel.addInterface(ServiceCodegenTypes.SERVICE_G_PER_INSTANCE_DESCRIPTOR);
            classModel.addField(createForField -> ((Field.Builder)createForField.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).name("CREATE_FOR")).type(TypeNames.TYPE_NAME).addContentCreate(createForTypeFinal));
            classModel.addMethod(createForMethod -> ((Method.Builder)((Method.Builder)((Method.Builder)createForMethod.accessModifier(AccessModifier.PUBLIC)).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).name("createFor")).addContentLine("return CREATE_FOR;"));
        }
    }

    private Map<String, GenericTypeDeclaration> genericTypes(ClassModel.Builder classModel, List<ParamDefinition> params, List<MethodDefinition> methods) {
        LinkedHashMap<String, GenericTypeDeclaration> result = new LinkedHashMap<String, GenericTypeDeclaration>();
        AtomicInteger counter = new AtomicInteger();
        for (ParamDefinition param : params) {
            result.computeIfAbsent(param.translatedType().resolvedName(), type -> {
                GenericTypeDeclaration response = new GenericTypeDeclaration("TYPE_" + counter.getAndIncrement(), param.declaredType());
                this.addTypeConstant(classModel, param.translatedType(), response);
                return response;
            });
            result.computeIfAbsent(param.contract().resolvedName(), type -> {
                GenericTypeDeclaration response = new GenericTypeDeclaration("TYPE_" + counter.getAndIncrement(), param.declaredType());
                this.addTypeConstant(classModel, param.contract(), response);
                return response;
            });
        }
        for (MethodDefinition method : methods) {
            for (ParamDefinition param : method.params()) {
                result.computeIfAbsent(param.declaredType().resolvedName(), type -> {
                    GenericTypeDeclaration response = new GenericTypeDeclaration("TYPE_" + counter.getAndIncrement(), param.declaredType());
                    this.addTypeConstant(classModel, param.declaredType(), response);
                    return response;
                });
            }
        }
        return result;
    }

    private void addTypeConstant(ClassModel.Builder classModel, TypeName typeName, GenericTypeDeclaration generic) {
        String stringType = typeName.resolvedName();
        classModel.addField(field -> ((Field.Builder)field.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).type(TypeNames.TYPE_NAME).name(generic.constantName())).update(it -> {
            if (stringType.indexOf(46) < 0) {
                it.addContent(TypeNames.TYPE_NAME).addContent(".create(").addContent(typeName).addContent(".class)");
            } else {
                it.addContentCreate(typeName);
            }
        }));
        classModel.addField(field -> ((Field.Builder)field.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).type(ServiceCodegenTypes.ANY_GENERIC_TYPE).name("G" + generic.constantName())).update(it -> {
            if (typeName.primitive()) {
                it.addContent(TypeNames.GENERIC_TYPE).addContent(".create(").addContent(typeName.className()).addContent(".class)");
            } else {
                it.addContent("new ").addContent(TypeNames.GENERIC_TYPE).addContent("<").addContent(typeName).addContent(">() {}");
            }
        }));
    }

    private record DependencyMetadata(String cardinality, boolean serviceInstance, boolean supplier) {
    }

    private record GenericTypeDeclaration(String constantName, TypeName typeName) {
    }
}

