/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

final class TypedElements {
    static final ElementMeta DEFAULT_CONSTRUCTOR = new ElementMeta(((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(TypeNames.OBJECT)).accessModifier(AccessModifier.PUBLIC)).kind(ElementKind.CONSTRUCTOR)).build());

    private TypedElements() {
    }

    static List<ElementMeta> gatherElements(TypeInfo typeInfo) {
        ArrayList<ElementMeta> result = new ArrayList<ElementMeta>();
        List declaredElements = typeInfo.elementInfo().stream().toList();
        for (TypedElementInfo declaredMethod : declaredElements) {
            ArrayList<DeclaredElement> interfaceMethods = new ArrayList<DeclaredElement>();
            if (declaredMethod.kind() == ElementKind.METHOD) {
                for (TypeInfo info : typeInfo.interfaceTypeInfo()) {
                    info.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> TypedElements.signatureMatches(declaredMethod, it)).findFirst().ifPresent(it -> interfaceMethods.add(new DeclaredElement(info, (TypedElementInfo)it)));
                }
            }
            result.add(new ElementMeta(declaredMethod, interfaceMethods));
        }
        return result;
    }

    private static boolean signatureMatches(TypedElementInfo method, TypedElementInfo interfaceMethod) {
        if (!ElementInfoPredicates.elementName((String)method.elementName()).test(interfaceMethod)) {
            return false;
        }
        List<TypeName> expectedParams = method.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).toList();
        return ElementInfoPredicates.hasParams(expectedParams).test(interfaceMethod);
    }

    record ElementMeta(TypedElementInfo element, List<DeclaredElement> interfaceMethods) {
        ElementMeta(TypedElementInfo element) {
            this(element, List.of());
        }
    }

    record DeclaredElement(TypeInfo iface, TypedElementInfo element) {
    }
}

