/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.ClassCode;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.ModuleInfo;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.DescriptorClassCode;
import io.helidon.service.codegen.HelidonMetaInfServices;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryCodegenExtension;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.RoundContextImpl;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.ServiceExtension;
import io.helidon.service.metadata.DescriptorMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

class ServiceRegistryCodegenExtension
implements CodegenExtension {
    private final Map<TypeName, List<RegistryCodegenExtension>> typeToExtensions = new HashMap<TypeName, List<RegistryCodegenExtension>>();
    private final Map<RegistryCodegenExtension, Predicate<TypeName>> extensionPredicates = new IdentityHashMap<RegistryCodegenExtension, Predicate<TypeName>>();
    private final Set<DescriptorMetadata> generatedServiceDescriptors = new HashSet<DescriptorMetadata>();
    private final RegistryCodegenContext ctx;
    private final List<RegistryCodegenExtension> extensions;
    private final String module;

    private ServiceRegistryCodegenExtension(CodegenContext ctx, TypeName generator) {
        this.ctx = RegistryCodegenContext.create(ctx);
        this.module = ctx.moduleName().orElse(null);
        ServiceExtension serviceExtension = new ServiceExtension(this.ctx);
        this.extensions = List.of(serviceExtension);
        this.typeToExtensions.put(ServiceCodegenTypes.SERVICE_ANNOTATION_PROVIDER, List.of(serviceExtension));
    }

    static ServiceRegistryCodegenExtension create(CodegenContext ctx, TypeName generator) {
        return new ServiceRegistryCodegenExtension(ctx, generator);
    }

    public void process(RoundContext roundContext) {
        Collection allTypes = roundContext.types();
        if (allTypes.isEmpty()) {
            this.extensions.forEach(it -> it.process(this.createRoundContext(List.of(), (RegistryCodegenExtension)it)));
            return;
        }
        List<TypeInfoAndAnnotations> annotatedTypes = this.annotatedTypes(allTypes);
        for (RegistryCodegenExtension extension : this.extensions) {
            extension.process(this.createRoundContext(annotatedTypes, extension));
        }
        this.writeNewTypes();
        for (TypeInfo typeInfo : roundContext.annotatedTypes(ServiceCodegenTypes.SERVICE_ANNOTATION_DESCRIPTOR)) {
            Annotation descriptorAnnot = typeInfo.annotation(ServiceCodegenTypes.SERVICE_ANNOTATION_DESCRIPTOR);
            double weight = descriptorAnnot.doubleValue("weight").orElse(100.0);
            Set contracts = descriptorAnnot.typeValues("contracts").map(Set::copyOf).orElseGet(Set::of);
            String registryType = descriptorAnnot.stringValue("registryType").orElse("core");
            this.generatedServiceDescriptors.add(DescriptorMetadata.create((String)registryType, (TypeName)typeInfo.typeName(), (double)weight, (Set)contracts));
        }
        if (roundContext.availableAnnotations().size() == 1 && roundContext.availableAnnotations().contains(TypeNames.GENERATED) && !this.generatedServiceDescriptors.isEmpty()) {
            this.addDescriptorsToServiceMeta();
            this.generatedServiceDescriptors.clear();
        }
    }

    public void processingOver(RoundContext roundContext) {
        this.extensions.forEach(RegistryCodegenExtension::processingOver);
        this.writeNewTypes();
        if (!this.generatedServiceDescriptors.isEmpty()) {
            this.addDescriptorsToServiceMeta();
            this.generatedServiceDescriptors.clear();
        }
    }

    private void addDescriptorsToServiceMeta() {
        boolean hasModule;
        Optional currentModule = this.ctx.module();
        Object moduleName = this.module == null ? (String)currentModule.map(ModuleInfo::name).orElse(null) : this.module;
        String packageName = CodegenOptions.CODEGEN_PACKAGE.findValue(this.ctx.options()).orElseGet(() -> this.topLevelPackage(this.generatedServiceDescriptors));
        boolean bl = hasModule = moduleName != null && !"unnamed module".equals(moduleName);
        if (!hasModule) {
            moduleName = "unnamed/" + packageName + (String)(this.ctx.scope().isProduction() ? "" : "/" + this.ctx.scope().name());
        }
        HelidonMetaInfServices services = HelidonMetaInfServices.create(this.ctx.filer(), (String)moduleName);
        services.addAll(this.generatedServiceDescriptors);
        services.write();
    }

    private void writeNewTypes() {
        ClassModel classModel;
        CodegenFiler filer = this.ctx.filer();
        List<DescriptorClassCode> descriptors = this.ctx.descriptors();
        for (DescriptorClassCode descriptor : descriptors) {
            ClassCode classCode = descriptor.classCode();
            classModel = classCode.classModel().build();
            this.generatedServiceDescriptors.add(DescriptorMetadata.create((String)descriptor.registryType(), (TypeName)classCode.newType(), (double)descriptor.weight(), descriptor.contracts()));
            filer.writeSourceFile(classModel, classCode.originatingElements());
        }
        descriptors.clear();
        List<ClassCode> otherTypes = this.ctx.types();
        for (ClassCode classCode : otherTypes) {
            classModel = classCode.classModel().build();
            filer.writeSourceFile(classModel, classCode.originatingElements());
        }
        otherTypes.clear();
    }

    private List<TypeInfoAndAnnotations> annotatedTypes(Collection<TypeInfo> allTypes) {
        ArrayList<TypeInfoAndAnnotations> result = new ArrayList<TypeInfoAndAnnotations>();
        for (TypeInfo typeInfo : allTypes) {
            result.add(new TypeInfoAndAnnotations(typeInfo, this.annotations(typeInfo)));
        }
        return result;
    }

    private RegistryRoundContext createRoundContext(List<TypeInfoAndAnnotations> annotatedTypes, RegistryCodegenExtension extension) {
        HashSet<TypeName> extAnnots = new HashSet<TypeName>();
        HashMap<TypeName, List> extAnnotToType = new HashMap<TypeName, List>();
        HashMap<TypeName, TypeInfo> extTypes = new HashMap<TypeName, TypeInfo>();
        for (TypeInfoAndAnnotations annotatedType : annotatedTypes) {
            for (TypeName typeName : annotatedType.annotations()) {
                Predicate<TypeName> predicate;
                boolean added = false;
                List<RegistryCodegenExtension> validExts = this.typeToExtensions.get(typeName);
                if (validExts != null) {
                    for (RegistryCodegenExtension validExt : validExts) {
                        if (validExt != extension) continue;
                        extAnnots.add(typeName);
                        extAnnotToType.computeIfAbsent(typeName, key -> new ArrayList()).add(annotatedType.typeInfo());
                        extTypes.put(annotatedType.typeInfo().typeName(), annotatedType.typeInfo);
                        added = true;
                    }
                }
                if (added || (predicate = this.extensionPredicates.get(extension)) == null || !predicate.test(typeName)) continue;
                extAnnots.add(typeName);
                extAnnotToType.computeIfAbsent(typeName, key -> new ArrayList()).add(annotatedType.typeInfo());
                extTypes.put(annotatedType.typeInfo().typeName(), annotatedType.typeInfo);
            }
        }
        return new RoundContextImpl(Set.copyOf(extAnnots), Map.copyOf(extAnnotToType), List.copyOf(extTypes.values()));
    }

    private Set<TypeName> annotations(TypeInfo theTypeInfo) {
        HashSet<TypeName> result = new HashSet<TypeName>();
        theTypeInfo.annotations().stream().map(rec$ -> ((Annotation)rec$).typeName()).forEach(result::add);
        theTypeInfo.elementInfo().stream().map(Annotated::annotations).flatMap(Collection::stream).map(rec$ -> ((Annotation)rec$).typeName()).forEach(result::add);
        theTypeInfo.elementInfo().stream().map(rec$ -> ((TypedElementInfo)rec$).parameterArguments()).flatMap(Collection::stream).map(Annotated::annotations).flatMap(Collection::stream).map(rec$ -> ((Annotation)rec$).typeName()).forEach(result::add);
        return result;
    }

    private String topLevelPackage(Set<DescriptorMetadata> typeNames) {
        String thePackage = typeNames.iterator().next().descriptorType().packageName();
        for (DescriptorMetadata typeName : typeNames) {
            String nextPackage = typeName.descriptorType().packageName();
            if (nextPackage.length() >= thePackage.length()) continue;
            thePackage = nextPackage;
        }
        return thePackage;
    }

    private record TypeInfoAndAnnotations(TypeInfo typeInfo, Set<TypeName> annotations) {
    }
}

