/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.RegistryRoundContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RoundContextImpl
implements RegistryRoundContext {
    private final Map<TypeName, List<TypeInfo>> annotationToTypes;
    private final List<TypeInfo> types;
    private final Collection<TypeName> annotations;

    RoundContextImpl(Set<TypeName> annotations, Map<TypeName, List<TypeInfo>> annotationToTypes, List<TypeInfo> types) {
        this.annotations = annotations;
        this.annotationToTypes = annotationToTypes;
        this.types = types;
    }

    @Override
    public Collection<TypeName> availableAnnotations() {
        return this.annotations;
    }

    @Override
    public Collection<TypeInfo> types() {
        return this.types;
    }

    @Override
    public Collection<TypedElementInfo> annotatedElements(TypeName annotationType) {
        List<TypeInfo> typeInfos = this.annotationToTypes.get(annotationType);
        if (typeInfos == null) {
            return Set.of();
        }
        ArrayList<TypedElementInfo> result = new ArrayList<TypedElementInfo>();
        for (TypeInfo typeInfo : typeInfos) {
            typeInfo.elementInfo().stream().filter(it -> it.hasAnnotation(annotationType)).forEach(result::add);
        }
        return result;
    }

    @Override
    public Collection<TypeInfo> annotatedTypes(TypeName annotationType) {
        List<TypeInfo> typeInfos = this.annotationToTypes.get(annotationType);
        if (typeInfos == null) {
            return Set.of();
        }
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (TypeInfo typeInfo : typeInfos) {
            if (!typeInfo.hasAnnotation(annotationType)) continue;
            result.add(typeInfo);
        }
        return result;
    }
}

