/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.ClassCode;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenContextDelegate;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.TypeName;
import io.helidon.service.codegen.DescriptorClassCode;
import io.helidon.service.codegen.DescriptorClassCodeImpl;
import io.helidon.service.codegen.RegistryCodegenContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class RegistryCodegenContextImpl
extends CodegenContextDelegate
implements RegistryCodegenContext {
    private final List<DescriptorClassCode> descriptors = new ArrayList<DescriptorClassCode>();
    private final List<ClassCode> nonDescriptors = new ArrayList<ClassCode>();

    RegistryCodegenContextImpl(CodegenContext context) {
        super(context);
    }

    @Override
    public Optional<ClassModel.Builder> descriptor(TypeName serviceType) {
        Objects.requireNonNull(serviceType);
        for (DescriptorClassCode descriptor : this.descriptors) {
            ClassCode classCode = descriptor.classCode();
            if (!classCode.mainTrigger().equals((Object)serviceType)) continue;
            return Optional.of(classCode.classModel());
        }
        return Optional.empty();
    }

    @Override
    public void addDescriptor(String registryType, TypeName serviceType, TypeName descriptorType, ClassModel.Builder descriptor, double weight, Set<TypeName> contracts, Object ... originatingElements) {
        Objects.requireNonNull(registryType);
        Objects.requireNonNull(serviceType);
        Objects.requireNonNull(descriptorType);
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(contracts);
        Objects.requireNonNull(originatingElements);
        this.descriptors.add(new DescriptorClassCodeImpl(new ClassCode(descriptorType, descriptor, serviceType, originatingElements), registryType, weight, contracts));
    }

    @Override
    public void addType(TypeName type, ClassModel.Builder newClass, TypeName mainTrigger, Object ... originatingElements) {
        this.nonDescriptors.add(new ClassCode(type, newClass, mainTrigger, originatingElements));
    }

    @Override
    public Optional<ClassModel.Builder> type(TypeName type) {
        for (ClassCode classCode : this.nonDescriptors) {
            if (!classCode.newType().equals((Object)type)) continue;
            return Optional.of(classCode.classModel());
        }
        for (DescriptorClassCode descriptor : this.descriptors) {
            ClassCode classCode = descriptor.classCode();
            if (!classCode.newType().equals((Object)type)) continue;
            return Optional.of(classCode.classModel());
        }
        return Optional.empty();
    }

    @Override
    public TypeName descriptorType(TypeName serviceType) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(serviceType.packageName())).className(RegistryCodegenContextImpl.descriptorClassName(serviceType))).build();
    }

    @Override
    public List<ClassCode> types() {
        return this.nonDescriptors;
    }

    @Override
    public List<DescriptorClassCode> descriptors() {
        return this.descriptors;
    }

    @Override
    public RegistryCodegenContext.Assignment assignment(TypeName typeName, String valueSource) {
        return new RegistryCodegenContext.Assignment(typeName, it -> it.addContent(valueSource));
    }

    private static String descriptorClassName(TypeName typeName) {
        List enclosing = typeName.enclosingNames();
        Object namePrefix = enclosing.isEmpty() ? "" : String.join((CharSequence)"_", enclosing) + "_";
        return (String)namePrefix + typeName.className() + "__ServiceDescriptor";
    }
}

