/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.Weight;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.ParamDefinition;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.ServiceOptions;
import io.helidon.service.codegen.SuperType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class GenerateServiceDescriptor {
    static final TypeName SET_OF_TYPES = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SET).addTypeArgument(TypeNames.TYPE_NAME)).build();
    private static final TypeName LIST_OF_DEPENDENCIES = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.LIST).addTypeArgument(ServiceCodegenTypes.SERVICE_DEPENDENCY)).build();
    private static final TypeName DESCRIPTOR_TYPE = ((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.SERVICE_DESCRIPTOR).addTypeArgument(TypeName.create((String)"T"))).build();
    private static final TypedElementInfo DEFAULT_CONSTRUCTOR = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(TypeNames.OBJECT)).accessModifier(AccessModifier.PUBLIC)).kind(ElementKind.CONSTRUCTOR)).build();
    private static final TypeName ANY_GENERIC_TYPE = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.GENERIC_TYPE).addTypeArgument(TypeName.create((String)"?"))).build();
    private final TypeName generator;
    private final RegistryCodegenContext ctx;
    private final Collection<TypeInfo> services;
    private final TypeInfo typeInfo;
    private final boolean autoAddContracts;

    private GenerateServiceDescriptor(TypeName generator, RegistryCodegenContext ctx, Collection<TypeInfo> allServices, TypeInfo service) {
        this.generator = generator;
        this.ctx = ctx;
        this.services = allServices;
        this.typeInfo = service;
        this.autoAddContracts = (Boolean)ServiceOptions.AUTO_ADD_NON_CONTRACT_INTERFACES.value(ctx.options());
    }

    static ClassModel.Builder generate(TypeName generator, RegistryCodegenContext ctx, Collection<TypeInfo> allServices, TypeInfo service) {
        return new GenerateServiceDescriptor(generator, ctx, allServices, service).generate();
    }

    static List<ParamDefinition> declareCtrParamsAndGetThem(Method.Builder method, List<ParamDefinition> params) {
        List<ParamDefinition> constructorParams = params.stream().filter(it -> it.kind() == ElementKind.CONSTRUCTOR).toList();
        for (ParamDefinition param : constructorParams) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(param.declaredType())).addContent(" ")).addContent(param.ipParamName())).addContent(" = ")).update(it -> param.assignmentHandler().accept((ContentBuilder<?>)it))).addContentLine(";");
        }
        if (!params.isEmpty()) {
            method.addContentLine("");
        }
        return constructorParams;
    }

    private ClassModel.Builder generate() {
        TypeName serviceType = this.typeInfo.typeName();
        if (this.typeInfo.kind() == ElementKind.INTERFACE) {
            throw new CodegenException("We can only generated service descriptors for classes, interface was requested: ", (Object)this.typeInfo.originatingElement().orElse(serviceType));
        }
        boolean isAbstractClass = this.typeInfo.elementModifiers().contains(Modifier.ABSTRACT) && this.typeInfo.kind() == ElementKind.CLASS;
        SuperType superType = this.superType(this.typeInfo, this.services);
        TypeName descriptorType = this.ctx.descriptorType(serviceType);
        List<ParamDefinition> params = this.params(this.typeInfo, this.constructor(this.typeInfo));
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().copyright(CodegenUtil.copyright((TypeName)this.generator, (TypeName)serviceType, (TypeName)descriptorType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)this.generator, (TypeName)serviceType, (TypeName)descriptorType, (String)"1", (String)""))).type(descriptorType).addGenericArgument(TypeArgument.create((String)("T extends " + serviceType.fqName())))).javadoc(Javadoc.builder().add("Service descriptor for {@link " + serviceType.fqName() + "}.").addGenericArgument("T", "type of the service, for extensibility").build())).sortStaticFields(false);
        Map<String, GenericTypeDeclaration> genericTypes = this.genericTypes(classModel, params);
        HashSet<TypeName> contracts = new HashSet<TypeName>();
        HashSet<String> collectedFullyQualifiedContracts = new HashSet<String>();
        this.contracts(this.typeInfo, this.autoAddContracts, contracts, collectedFullyQualifiedContracts);
        if (superType.hasSupertype()) {
            classModel.superType(superType.superDescriptorType());
        } else {
            classModel.addInterface(DESCRIPTOR_TYPE);
        }
        this.singletonInstanceField(classModel, serviceType, descriptorType);
        this.serviceTypeFields(classModel, serviceType, descriptorType);
        this.dependencyFields(classModel, this.typeInfo, genericTypes, params);
        this.dependenciesField(classModel, params);
        classModel.addConstructor(constructor -> ((Constructor.Builder)constructor.description("Constructor with no side effects")).accessModifier(AccessModifier.PROTECTED));
        this.serviceTypeMethod(classModel);
        this.descriptorTypeMethod(classModel);
        this.contractsMethod(classModel, contracts);
        this.dependenciesMethod(classModel, params, superType);
        this.isAbstractMethod(classModel, superType, isAbstractClass);
        this.instantiateMethod(classModel, serviceType, params, isAbstractClass);
        this.weightMethod(this.typeInfo, classModel, superType);
        HashSet<TypeName> allContracts = new HashSet<TypeName>(contracts);
        allContracts.add(serviceType);
        Object[] objectArray = new Object[1];
        objectArray[0] = this.typeInfo.originatingElement().orElseGet(() -> this.typeInfo.typeName());
        this.ctx.addDescriptor("core", serviceType, descriptorType, classModel, this.weight(this.typeInfo).orElse(100.0), allContracts, objectArray);
        return classModel;
    }

    private SuperType superType(TypeInfo typeInfo, Collection<TypeInfo> services) {
        Optional superTypeInfoOptional = typeInfo.superTypeInfo();
        if (superTypeInfoOptional.isEmpty()) {
            return SuperType.noSuperType();
        }
        TypeInfo superType = (TypeInfo)superTypeInfoOptional.get();
        TypeName expectedSuperDescriptor = this.ctx.descriptorType(superType.typeName());
        TypeName superTypeToExtend = ((TypeName.Builder)TypeName.builder((TypeName)expectedSuperDescriptor).addTypeArgument(TypeName.create((String)"T"))).build();
        boolean isCore = superType.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PROVIDER);
        if (!isCore) {
            throw new CodegenException("Service annotated with @Service.Provider extends invalid supertype, the super type must also be a @Service.Provider. Type: " + typeInfo.typeName().fqName() + ", super type: " + superType.typeName().fqName());
        }
        for (TypeInfo service : services) {
            if (!service.typeName().equals((Object)superType.typeName())) continue;
            return new SuperType(true, superTypeToExtend, service, true);
        }
        return this.ctx.typeInfo(expectedSuperDescriptor).map(it -> new SuperType(true, superTypeToExtend, superType, true)).orElseGet(SuperType::noSuperType);
    }

    private TypedElementInfo constructor(TypeInfo typeInfo) {
        return typeInfo.elementInfo().stream().filter(it -> it.kind() == ElementKind.CONSTRUCTOR).filter(Predicate.not(ElementInfoPredicates::isPrivate)).findFirst().orElse(DEFAULT_CONSTRUCTOR);
    }

    private List<ParamDefinition> params(TypeInfo service, TypedElementInfo constructor) {
        AtomicInteger paramCounter = new AtomicInteger();
        return constructor.parameterArguments().stream().map(param -> {
            String constantName = "PARAM_" + paramCounter.getAndIncrement();
            RegistryCodegenContext.Assignment assignment = this.translateParameter(param.typeName(), constantName);
            return new ParamDefinition(constructor, null, (TypedElementInfo)param, constantName, param.typeName(), assignment.usedType(), assignment.codeGenerator(), ElementKind.CONSTRUCTOR, constructor.elementName(), param.elementName(), param.elementName(), false, param.annotations(), Set.of(), this.contract(service.typeName().fqName() + " Constructor parameter: " + param.elementName(), assignment.usedType()), constructor.accessModifier(), "<init>");
        }).toList();
    }

    private TypeName contract(String description, TypeName typeName) {
        if (typeName.isOptional()) {
            if (typeName.typeArguments().isEmpty()) {
                throw new IllegalArgumentException("Dependency with Optional type must have a declared type argument: " + description);
            }
            return this.contract(description, (TypeName)typeName.typeArguments().getFirst());
        }
        if (typeName.isList()) {
            if (typeName.typeArguments().isEmpty()) {
                throw new IllegalArgumentException("Dependency with List type must have a declared type argument: " + description);
            }
            return this.contract(description, (TypeName)typeName.typeArguments().getFirst());
        }
        if (typeName.isSupplier()) {
            if (typeName.typeArguments().isEmpty()) {
                throw new IllegalArgumentException("Dependency with Supplier type must have a declared type argument: " + description);
            }
            return this.contract(description, (TypeName)typeName.typeArguments().getFirst());
        }
        return typeName;
    }

    private Map<String, GenericTypeDeclaration> genericTypes(ClassModel.Builder classModel, List<ParamDefinition> params) {
        LinkedHashMap<String, GenericTypeDeclaration> result = new LinkedHashMap<String, GenericTypeDeclaration>();
        AtomicInteger counter = new AtomicInteger();
        for (ParamDefinition param : params) {
            result.computeIfAbsent(param.translatedType().resolvedName(), type -> {
                GenericTypeDeclaration response = new GenericTypeDeclaration("TYPE_" + counter.getAndIncrement(), param.declaredType());
                this.addTypeConstant(classModel, param.translatedType(), response);
                return response;
            });
            result.computeIfAbsent(param.contract().fqName(), type -> {
                GenericTypeDeclaration response = new GenericTypeDeclaration("TYPE_" + counter.getAndIncrement(), param.declaredType());
                this.addTypeConstant(classModel, param.contract(), response);
                return response;
            });
        }
        return result;
    }

    private void addTypeConstant(ClassModel.Builder classModel, TypeName typeName, GenericTypeDeclaration generic) {
        String stringType = typeName.resolvedName();
        classModel.addField(field -> ((Field.Builder)field.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).type(TypeNames.TYPE_NAME).name(generic.constantName())).update(it -> {
            if (stringType.indexOf(46) < 0) {
                it.addContent(TypeNames.TYPE_NAME).addContent(".create(").addContent(typeName).addContent(".class)");
            } else {
                it.addContentCreate(typeName);
            }
        }));
        classModel.addField(field -> ((Field.Builder)field.accessModifier(AccessModifier.PRIVATE).isStatic(true).isFinal(true).type(ANY_GENERIC_TYPE).name("G" + generic.constantName())).update(it -> {
            if (typeName.primitive()) {
                it.addContent(TypeNames.GENERIC_TYPE).addContent(".create(").addContent(typeName.className()).addContent(".class)");
            } else {
                it.addContent("new ").addContent(TypeNames.GENERIC_TYPE).addContent("<").addContent(typeName).addContent(">() {}");
            }
        }));
    }

    private void contracts(TypeInfo typeInfo, boolean contractEligible, Set<TypeName> collectedContracts, Set<String> collectedFullyQualified) {
        TypeName typeName = typeInfo.typeName();
        boolean addedThisContract = false;
        if (contractEligible) {
            collectedContracts.add(typeName);
            addedThisContract = true;
            if (!collectedFullyQualified.add(typeName.resolvedName())) {
                return;
            }
        }
        if (typeName.isSupplier()) {
            TypeName providedType;
            if (!typeName.typeArguments().isEmpty() && !(providedType = (TypeName)typeName.typeArguments().getFirst()).generic()) {
                collectedContracts.add(TypeNames.SUPPLIER);
                if (providedType.isOptional() && !providedType.typeArguments().isEmpty()) {
                    providedType = (TypeName)providedType.typeArguments().getFirst();
                    collectedFullyQualified.add(TypeNames.SUPPLIER.fqName());
                    collectedContracts.add(TypeNames.SUPPLIER);
                    if (providedType.generic()) {
                        providedType = null;
                    } else {
                        collectedFullyQualified.add(TypeNames.OPTIONAL.fqName());
                        collectedContracts.add(TypeNames.OPTIONAL);
                        this.contractsFromProvidedType(collectedContracts, collectedFullyQualified, providedType);
                    }
                } else {
                    this.contractsFromProvidedType(collectedContracts, collectedFullyQualified, providedType);
                }
                if (providedType != null && !collectedFullyQualified.add(providedType.resolvedName())) {
                    return;
                }
            }
            if (!addedThisContract) {
                collectedContracts.add(typeName);
                if (!collectedFullyQualified.add(typeName.resolvedName())) {
                    return;
                }
            }
        }
        typeInfo.findAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_CONTRACT).ifPresent(it -> collectedContracts.add(typeInfo.typeName()));
        typeInfo.findAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_EXTERNAL_CONTRACTS).ifPresent(it -> collectedContracts.addAll(it.typeValues().orElseGet(List::of)));
        typeInfo.superTypeInfo().ifPresent(it -> this.contracts((TypeInfo)it, contractEligible, collectedContracts, collectedFullyQualified));
        typeInfo.interfaceTypeInfo().forEach(it -> this.contracts((TypeInfo)it, contractEligible, collectedContracts, collectedFullyQualified));
    }

    private void contractsFromProvidedType(Set<TypeName> collectedContracts, Set<String> collectedFullyQualified, TypeName providedType) {
        Optional providedTypeInfo = this.ctx.typeInfo(providedType);
        if (providedTypeInfo.isPresent()) {
            this.contracts((TypeInfo)providedTypeInfo.get(), true, collectedContracts, collectedFullyQualified);
        } else {
            collectedContracts.add(providedType);
        }
    }

    private void singletonInstanceField(ClassModel.Builder classModel, TypeName serviceType, TypeName descriptorType) {
        classModel.addField(instance -> ((Field.Builder)((Field.Builder)instance.description("Global singleton instance for this descriptor.")).accessModifier(AccessModifier.PUBLIC).isStatic(true).isFinal(true).type(this.descriptorInstanceType(serviceType, descriptorType)).name("INSTANCE")).defaultValueContent("new " + descriptorType.className() + "<>()"));
    }

    private void serviceTypeFields(ClassModel.Builder classModel, TypeName serviceType, TypeName descriptorType) {
        classModel.addField(field -> ((Field.Builder)field.isStatic(true).isFinal(true).accessModifier(AccessModifier.PRIVATE).type(TypeNames.TYPE_NAME).name("SERVICE_TYPE")).addContentCreate(serviceType.genericTypeName()));
        classModel.addField(field -> ((Field.Builder)field.isStatic(true).isFinal(true).accessModifier(AccessModifier.PRIVATE).type(TypeNames.TYPE_NAME).name("DESCRIPTOR_TYPE")).addContentCreate(descriptorType.genericTypeName()));
    }

    private void dependencyFields(ClassModel.Builder classModel, TypeInfo service, Map<String, GenericTypeDeclaration> genericTypes, List<ParamDefinition> params) {
        for (ParamDefinition param : params) {
            classModel.addField(field -> ((Field.Builder)((Field.Builder)field.accessModifier(AccessModifier.PUBLIC).isStatic(true).isFinal(true).type(ServiceCodegenTypes.SERVICE_DEPENDENCY).name(param.constantName())).description(this.dependencyDescription(service, param))).update(it -> {
                ((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)((Field.Builder)it.addContent(ServiceCodegenTypes.SERVICE_DEPENDENCY).addContentLine(".builder()")).increaseContentPadding().increaseContentPadding().addContent(".typeName(").addContent(((GenericTypeDeclaration)genericTypes.get(param.translatedType().resolvedName())).constantName()).addContentLine(")")).update(maybeElementKind -> {
                    if (param.kind() != ElementKind.CONSTRUCTOR) {
                        maybeElementKind.addContent(".elementKind(").addContent(TypeNames.ELEMENT_KIND).addContent(".").addContent(param.kind().name()).addContentLine(")");
                    }
                })).update(maybeMethod -> {
                    if (param.kind() == ElementKind.METHOD) {
                        maybeMethod.addContent(".method(").addContent(param.methodConstantName()).addContentLine(")");
                    }
                })).addContent(".name(\"").addContent(param.fieldId()).addContentLine("\")")).addContentLine(".service(SERVICE_TYPE)")).addContentLine(".descriptor(DESCRIPTOR_TYPE)")).addContent(".descriptorConstant(\"").addContent(param.constantName()).addContentLine("\")")).addContent(".contract(").addContent(((GenericTypeDeclaration)genericTypes.get(param.contract().fqName())).constantName()).addContentLine(")")).addContent(".contractType(G").addContent(((GenericTypeDeclaration)genericTypes.get(param.contract().fqName())).constantName()).addContentLine(")");
                if (param.access() != AccessModifier.PACKAGE_PRIVATE) {
                    it.addContent(".access(").addContent(TypeNames.ACCESS_MODIFIER).addContent(".").addContent(param.access().name()).addContentLine(")");
                }
                if (param.isStatic()) {
                    it.addContentLine(".isStatic(true)");
                }
                if (!param.qualifiers().isEmpty()) {
                    for (Annotation qualifier : param.qualifiers()) {
                        ((Field.Builder)it.addContent(".addQualifier(qualifier -> qualifier.typeName(").addContentCreate(qualifier.typeName().genericTypeName())).addContent(")");
                        qualifier.value().ifPresent(q -> it.addContent(".value(\"").addContent(q).addContent("\")"));
                        it.addContentLine(")");
                    }
                }
                it.addContent(".build()").decreaseContentPadding().decreaseContentPadding();
            }));
        }
    }

    private String dependencyDescription(TypeInfo service, ParamDefinition param) {
        boolean elementPublic;
        TypeName serviceType = service.typeName();
        StringBuilder result = new StringBuilder("Dependency for ");
        boolean servicePublic = service.accessModifier() == AccessModifier.PUBLIC;
        boolean bl = elementPublic = param.owningElement().accessModifier() == AccessModifier.PUBLIC;
        if (servicePublic) {
            result.append("{@link ").append(serviceType.fqName());
            if (!elementPublic) {
                result.append("}");
            }
        } else {
            result.append(serviceType.classNameWithEnclosingNames());
        }
        if (servicePublic && elementPublic) {
            result.append("#").append(serviceType.className()).append("(").append(this.toDescriptionSignature(param.owningElement(), true)).append(")").append("}");
        } else {
            result.append("(").append(this.toDescriptionSignature(param.owningElement(), false)).append(")");
        }
        result.append(", parameter ").append(param.elementInfo().elementName()).append(".");
        return result.toString();
    }

    private String toDescriptionSignature(TypedElementInfo method, boolean javadoc) {
        if (javadoc) {
            return method.parameterArguments().stream().map(it -> it.typeName().fqName()).collect(Collectors.joining(", "));
        }
        return method.parameterArguments().stream().map(it -> it.typeName().classNameWithEnclosingNames() + " " + it.elementName()).collect(Collectors.joining(", "));
    }

    private void dependenciesField(ClassModel.Builder classModel, List<ParamDefinition> params) {
        classModel.addField(dependencies -> ((Field.Builder)((Field.Builder)((Field.Builder)dependencies.isStatic(true).isFinal(true).name("DEPENDENCIES")).type(LIST_OF_DEPENDENCIES).addContent(List.class)).addContent(".of(").update(it -> {
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                it.addContent(((ParamDefinition)iterator.next()).constantName());
                if (!iterator.hasNext()) continue;
                it.addContent(", ");
            }
        })).addContent(")"));
    }

    private void serviceTypeMethod(ClassModel.Builder classModel) {
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).name("serviceType")).addContentLine("return SERVICE_TYPE;"));
    }

    private void descriptorTypeMethod(ClassModel.Builder classModel) {
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.TYPE_NAME).name("descriptorType")).addContentLine("return DESCRIPTOR_TYPE;"));
    }

    private void contractsMethod(ClassModel.Builder classModel, Set<TypeName> contracts) {
        if (contracts.isEmpty()) {
            return;
        }
        classModel.addField(contractsField -> ((Field.Builder)((Field.Builder)((Field.Builder)contractsField.isStatic(true).isFinal(true).name("CONTRACTS")).type(SET_OF_TYPES).addContent(Set.class)).addContent(".of(").update(it -> {
            Iterator iterator = contracts.iterator();
            while (iterator.hasNext()) {
                it.addContentCreate(((TypeName)iterator.next()).genericTypeName());
                if (!iterator.hasNext()) continue;
                it.addContent(", ");
            }
        })).addContent(")"));
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).name("contracts")).returnType(SET_OF_TYPES).addContentLine("return CONTRACTS;"));
    }

    private void dependenciesMethod(ClassModel.Builder classModel, List<ParamDefinition> params, SuperType superType) {
        boolean hasSuperType = superType.hasSupertype();
        if (hasSuperType || !params.isEmpty()) {
            classModel.addMethod(method -> ((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(LIST_OF_DEPENDENCIES).name("dependencies")).update(it -> {
                if (hasSuperType) {
                    it.addContentLine("return combineDependencies(DEPENDENCIES, super.dependencies());");
                } else {
                    it.addContentLine("return DEPENDENCIES;");
                }
            }));
        }
    }

    private void instantiateMethod(ClassModel.Builder classModel, TypeName serviceType, List<ParamDefinition> params, boolean isAbstractClass) {
        if (isAbstractClass) {
            return;
        }
        classModel.addMethod(method -> ((Method.Builder)((Method.Builder)((Method.Builder)method.addAnnotation(Annotations.OVERRIDE)).returnType(serviceType).name("instantiate")).addParameter(ctxParam -> ctxParam.type(ServiceCodegenTypes.SERVICE_DEPENDENCY_CONTEXT).name("ctx__helidonRegistry"))).update(it -> this.createInstantiateBody(serviceType, (Method.Builder)it, params)));
    }

    private void createInstantiateBody(TypeName serviceType, Method.Builder method, List<ParamDefinition> params) {
        List<ParamDefinition> constructorParams = GenerateServiceDescriptor.declareCtrParamsAndGetThem(method, params);
        String paramsDeclaration = constructorParams.stream().map(ParamDefinition::ipParamName).collect(Collectors.joining(", "));
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("return new ")).addContent(serviceType.genericTypeName())).addContent("(")).addContent(paramsDeclaration)).addContentLine(");");
    }

    private void isAbstractMethod(ClassModel.Builder classModel, SuperType superType, boolean isAbstractClass) {
        if (!isAbstractClass && !superType.hasSupertype()) {
            return;
        }
        classModel.addMethod(isAbstract -> ((Method.Builder)((Method.Builder)isAbstract.name("isAbstract")).returnType(TypeNames.PRIMITIVE_BOOLEAN).addAnnotation(Annotations.OVERRIDE)).addContentLine("return " + isAbstractClass + ";"));
    }

    private void weightMethod(TypeInfo typeInfo, ClassModel.Builder classModel, SuperType superType) {
        boolean hasSuperType = superType.hasSupertype();
        Optional<Double> weight = this.weight(typeInfo);
        if (!hasSuperType && weight.isEmpty()) {
            return;
        }
        double usedWeight = weight.orElse(100.0);
        if (!hasSuperType && usedWeight == 100.0) {
            return;
        }
        classModel.addMethod(weightMethod -> ((Method.Builder)((Method.Builder)weightMethod.name("weight")).addAnnotation(Annotations.OVERRIDE)).returnType(TypeNames.PRIMITIVE_DOUBLE).addContentLine("return " + usedWeight + ";"));
    }

    private Optional<Double> weight(TypeInfo typeInfo) {
        return typeInfo.findAnnotation(TypeName.create(Weight.class)).flatMap(rec$ -> ((Annotation)rec$).doubleValue());
    }

    private RegistryCodegenContext.Assignment translateParameter(TypeName typeName, String constantName) {
        return this.ctx.assignment(typeName, "ctx__helidonRegistry.dependency(" + constantName + ")");
    }

    private TypeName descriptorInstanceType(TypeName serviceType, TypeName descriptorType) {
        return ((TypeName.Builder)TypeName.builder((TypeName)descriptorType).addTypeArgument(serviceType)).build();
    }

    private record GenericTypeDeclaration(String constantName, TypeName typeName) {
    }
}

