/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.common;

import io.helidon.security.SecurityResponse;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.config.SpanTracingConfig;
import java.util.Map;
import java.util.Optional;

abstract class CommonTracing {
    static final String LOG_STATUS = "status";
    private final Optional<SpanContext> parentSpanContext;
    private final Optional<Span> parentSpan;
    private final Optional<Span> securitySpan;
    private final Optional<Span> span;
    private final SpanTracingConfig spanConfig;

    CommonTracing(Optional<SpanContext> parentSpanContext, Optional<Span> parentSpan, Optional<Span> securitySpan, Optional<Span> span, SpanTracingConfig spanConfig) {
        this.parentSpanContext = parentSpanContext;
        this.parentSpan = parentSpan;
        this.securitySpan = securitySpan;
        this.span = span;
        this.spanConfig = spanConfig;
    }

    public void finish() {
        this.span.ifPresent(Span::end);
    }

    public void error(String message) {
        if (!this.span.isPresent()) {
            return;
        }
        Span theSpan = this.span.get();
        theSpan.status(Span.Status.ERROR);
        theSpan.addEvent("error", Map.of("message", message, "error.kind", "SecurityException"));
        theSpan.end();
    }

    public void error(Throwable throwable) {
        if (this.span.isEmpty()) {
            return;
        }
        Span theSpan = this.span.get();
        theSpan.end(throwable);
    }

    public Optional<SpanContext> findParent() {
        Optional<Span> closest = this.closestSecuritySpan();
        return closest.map(Span::context).or(() -> this.parentSpanContext);
    }

    public void logStatus(SecurityResponse.SecurityStatus status) {
        this.log(LOG_STATUS, "status: " + status, true);
    }

    Optional<Span> span() {
        return this.span;
    }

    Optional<SpanContext> parentSpanContext() {
        return this.parentSpanContext;
    }

    Optional<Span> parentSpan() {
        return this.parentSpan;
    }

    Optional<Span> securitySpan() {
        return this.securitySpan;
    }

    void log(String logName, String logMessage, boolean enabledByDefault) {
        this.span().ifPresent(span -> {
            if (this.spanConfig().logEnabled(logName, enabledByDefault)) {
                span.addEvent(logMessage);
            }
        });
    }

    protected SpanTracingConfig spanConfig() {
        return this.spanConfig;
    }

    private Optional<Span> closestSecuritySpan() {
        if (this.span.isPresent()) {
            return this.span;
        }
        return this.securitySpan;
    }
}

