/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.common;

import io.helidon.security.SecurityResponse;
import io.helidon.tracing.config.SpanTracingConfig;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.util.Map;
import java.util.Optional;

abstract class CommonTracing {
    static final String LOG_STATUS = "status";
    private final Optional<SpanContext> parentSpanContext;
    private final Optional<Span> parentSpan;
    private final Optional<Span> securitySpan;
    private final Optional<Span> span;
    private final SpanTracingConfig spanConfig;

    CommonTracing(Optional<SpanContext> parentSpanContext, Optional<Span> parentSpan, Optional<Span> securitySpan, Optional<Span> span, SpanTracingConfig spanConfig) {
        this.parentSpanContext = parentSpanContext;
        this.parentSpan = parentSpan;
        this.securitySpan = securitySpan;
        this.span = span;
        this.spanConfig = spanConfig;
    }

    public void finish() {
        this.span.ifPresent(Span::finish);
    }

    public void error(String message) {
        if (!this.span.isPresent()) {
            return;
        }
        Span theSpan = this.span.get();
        Tags.ERROR.set(theSpan, Boolean.valueOf(true));
        theSpan.log(Map.of("event", "error", "message", message, "error.kind", "SecurityException"));
        theSpan.finish();
    }

    public void error(Throwable throwable) {
        if (!this.span.isPresent()) {
            return;
        }
        Span theSpan = this.span.get();
        Tags.ERROR.set(theSpan, Boolean.valueOf(true));
        theSpan.log(Map.of("event", "error", "error.object", throwable));
        theSpan.finish();
    }

    public Optional<SpanContext> findParent() {
        Optional<Span> closest = this.closestSecuritySpan();
        return closest.map(Span::context).or(() -> this.parentSpanContext);
    }

    public void logStatus(SecurityResponse.SecurityStatus status) {
        this.log(LOG_STATUS, "status: " + String.valueOf(status), true);
    }

    Optional<Span> span() {
        return this.span;
    }

    Optional<SpanContext> parentSpanContext() {
        return this.parentSpanContext;
    }

    Optional<Span> parentSpan() {
        return this.parentSpan;
    }

    Optional<Span> securitySpan() {
        return this.securitySpan;
    }

    void log(String logName, String logMessage, boolean enabledByDefault) {
        this.span().ifPresent(span -> {
            if (this.spanConfig().logEnabled(logName, enabledByDefault)) {
                span.log(logMessage);
            }
        });
    }

    protected SpanTracingConfig spanConfig() {
        return this.spanConfig;
    }

    private Optional<Span> closestSecuritySpan() {
        if (this.span.isPresent()) {
            return this.span;
        }
        return this.securitySpan;
    }
}

