/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.common;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.security.SecurityContext;
import io.helidon.security.integration.common.AtnTracing;
import io.helidon.security.integration.common.AtzTracing;
import io.helidon.security.integration.common.CommonTracing;
import io.helidon.security.integration.common.OutboundTracing;
import io.helidon.security.integration.common.ResponseTracing;
import io.helidon.security.integration.common.RoleMapTracing;
import io.helidon.tracing.config.ComponentTracingConfig;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.Optional;

public final class SecurityTracing
extends CommonTracing {
    private static final String COMPONENT = "security";
    private static final String SPAN_SECURITY = "security";
    private static final String SPAN_OUTBOUND = "security:outbound";
    private static final String SPAN_RESPONSE = "security:response";
    private static final String SPAN_AUTHENTICATION = "security:atn";
    private static final String SPAN_AUTHORIZATION = "security:atz";
    private static final String SPAN_ROLE_MAP_PREFIX = "security:rm:";
    private static final String SPAN_TAG_SECURITY_CONTEXT = "security.id";
    private static final String LOG_STATUS = "status";
    private static final String STATUS_PROCEED = "PROCEED";
    private static final String STATUS_DENY = "DENY";
    private final ComponentTracingConfig tracedConfig;
    private final SpanTracingConfig atnSpanConfig;
    private final SpanTracingConfig atzSpanConfig;
    private final SpanTracingConfig outboundSpanConfig;
    private final SpanTracingConfig responseSpanConfig;
    private AtnTracing atnTracing;
    private AtzTracing atzTracing;
    private OutboundTracing outboundTracing;
    private ResponseTracing responseTracing;

    private SecurityTracing(Optional<SpanContext> parentSpanContext, Optional<Span> parentSpan, Optional<Span> securitySpan, ComponentTracingConfig tracedConfig) {
        super(parentSpanContext, parentSpan, securitySpan, securitySpan, tracedConfig.span("security"));
        this.tracedConfig = tracedConfig;
        this.atnSpanConfig = tracedConfig.span(SPAN_AUTHENTICATION);
        this.atzSpanConfig = tracedConfig.span(SPAN_AUTHORIZATION);
        this.outboundSpanConfig = tracedConfig.span(SPAN_OUTBOUND);
        this.responseSpanConfig = tracedConfig.span(SPAN_RESPONSE);
    }

    public static SecurityTracing get() {
        Optional context = Contexts.context();
        return SecurityTracing.tracing(context).orElseGet(() -> SecurityTracing.createTracing(context));
    }

    private static SecurityTracing createTracing(Optional<Context> context) {
        ComponentTracingConfig componentConfig = context.flatMap(ctx -> ctx.get(TracingConfig.class)).orElse(TracingConfig.ENABLED).component("security");
        Optional<SpanContext> parentSpanContext = context.flatMap(ctx -> ctx.get(SpanContext.class));
        Optional<Span> parentSpan = context.flatMap(ctx -> ctx.get(Span.class));
        Optional<Span> securitySpan = SecurityTracing.createSecuritySpan(componentConfig, parentSpanContext);
        SecurityTracing tracing = new SecurityTracing(parentSpanContext, parentSpan, securitySpan, componentConfig);
        context.ifPresent(ctx -> ctx.register((Object)tracing));
        return tracing;
    }

    private static Optional<Span> createSecuritySpan(ComponentTracingConfig componentConfig, Optional<SpanContext> parentSpan) {
        return SecurityTracing.tracer().flatMap(tracer -> {
            SpanTracingConfig spanConfig = componentConfig.span("security");
            if (spanConfig.enabled()) {
                Tracer.SpanBuilder builder = tracer.buildSpan(spanConfig.newName().orElse("security"));
                parentSpan.ifPresent(arg_0 -> ((Tracer.SpanBuilder)builder).asChildOf(arg_0));
                return Optional.of(builder.start());
            }
            return Optional.empty();
        });
    }

    private static Optional<SecurityTracing> tracing(Optional<Context> context) {
        return context.flatMap(ctx -> ctx.get(SecurityTracing.class));
    }

    private static Optional<Span> newSpan(SpanTracingConfig spanConfig, String spanName, Optional<SpanContext> parent) {
        return SecurityTracing.tracer().flatMap(tracer -> {
            if (spanConfig.enabled()) {
                Tracer.SpanBuilder builder = tracer.buildSpan(spanConfig.newName().orElse(spanName));
                parent.ifPresent(arg_0 -> ((Tracer.SpanBuilder)builder).asChildOf(arg_0));
                return Optional.of(builder.start());
            }
            return Optional.empty();
        });
    }

    private static Optional<Tracer> tracer() {
        return Contexts.context().flatMap(ctx -> ctx.get(Tracer.class));
    }

    public void securityContext(SecurityContext context) {
        this.span().ifPresent(span -> span.setTag(SPAN_TAG_SECURITY_CONTEXT, context.id()));
    }

    public void logProceed() {
        this.logStatus(STATUS_PROCEED);
    }

    public void logDeny() {
        this.logStatus(STATUS_DENY);
    }

    public AtnTracing atnTracing() {
        if (null != this.atnTracing) {
            return this.atnTracing;
        }
        Optional<Span> atnSpan = SecurityTracing.newSpan(this.atnSpanConfig, SPAN_AUTHENTICATION, this.findParent());
        this.atnTracing = new AtnTracing(this.parentSpanContext(), this.parentSpan(), this.span(), atnSpan, this.atnSpanConfig);
        return this.atnTracing;
    }

    public RoleMapTracing roleMapTracing(String id) {
        AtnTracing atn = this.atnTracing();
        String spanName = SPAN_ROLE_MAP_PREFIX + id;
        SpanTracingConfig rmTracingConfig = this.tracedConfig.span(SPAN_ROLE_MAP_PREFIX + id);
        Optional<Span> atnSpan = SecurityTracing.newSpan(rmTracingConfig, spanName, atn.findParent());
        return new RoleMapTracing(this.parentSpanContext(), this.parentSpan(), this.span(), atnSpan, this.atnSpanConfig);
    }

    public AtzTracing atzTracing() {
        if (null != this.atzTracing) {
            return this.atzTracing;
        }
        Optional<Span> atzSpan = SecurityTracing.newSpan(this.atzSpanConfig, SPAN_AUTHORIZATION, this.findParent());
        this.atzTracing = new AtzTracing(this.parentSpanContext(), this.parentSpan(), this.span(), atzSpan, this.atzSpanConfig);
        return this.atzTracing;
    }

    public OutboundTracing outboundTracing() {
        if (null != this.outboundTracing) {
            return this.outboundTracing;
        }
        Optional<Object> parentOptional = Contexts.context().flatMap(ctx -> ctx.get(TracingConfigUtil.OUTBOUND_SPAN_QUALIFIER, SpanContext.class));
        if (!parentOptional.isPresent()) {
            parentOptional = this.parentSpanContext();
        }
        Optional<Span> outboundSpan = SecurityTracing.newSpan(this.atnSpanConfig, SPAN_OUTBOUND, parentOptional);
        this.outboundTracing = new OutboundTracing(this.parentSpanContext(), this.parentSpan(), this.span(), outboundSpan, this.outboundSpanConfig);
        return this.outboundTracing;
    }

    public ResponseTracing responseTracing() {
        if (null != this.responseTracing) {
            return this.responseTracing;
        }
        Optional<Span> responseSpan = SecurityTracing.newSpan(this.responseSpanConfig, SPAN_RESPONSE, this.parentSpanContext());
        this.responseTracing = new ResponseTracing(this.parentSpanContext(), this.parentSpan(), this.span(), responseSpan, this.responseSpanConfig);
        return this.responseTracing;
    }

    private void logStatus(String status) {
        super.log(LOG_STATUS, "status: " + status, true);
    }
}

