/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.config.Config;
import io.helidon.security.AuditEvent;
import io.helidon.security.spi.AuditProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

final class DefaultAuditProvider
implements AuditProvider {
    private final System.Logger auditLogger;
    private final System.Logger.Level failureLevel;
    private final System.Logger.Level successLevel;
    private final System.Logger.Level infoLevel;
    private final System.Logger.Level warnLevel;
    private final System.Logger.Level errorLevel;
    private final System.Logger.Level auditFailureLevel;

    private DefaultAuditProvider(Config config) {
        this.auditLogger = System.getLogger((String)config.get("audit.defaultProvider.logger").asString().orElse((Object)"AUDIT"));
        this.failureLevel = this.level(config, "failure", System.Logger.Level.TRACE);
        this.successLevel = this.level(config, "success", System.Logger.Level.TRACE);
        this.infoLevel = this.level(config, "info", System.Logger.Level.TRACE);
        this.warnLevel = this.level(config, "warn", System.Logger.Level.WARNING);
        this.errorLevel = this.level(config, "error", System.Logger.Level.ERROR);
        this.auditFailureLevel = this.level(config, "audit-failure", System.Logger.Level.ERROR);
    }

    private System.Logger.Level level(Config config, String auditSeverity, System.Logger.Level defaultLevel) {
        return config.get("audit.defaultProvider.level." + auditSeverity).asString().map(s -> System.Logger.Level.valueOf(s)).orElse(defaultLevel);
    }

    static DefaultAuditProvider create(Config config) {
        return new DefaultAuditProvider(config);
    }

    @Override
    public Consumer<AuditProvider.TracedAuditEvent> auditConsumer() {
        return this::audit;
    }

    private void audit(AuditProvider.TracedAuditEvent event) {
        this.logEvent(event, switch (event.severity()) {
            case AuditEvent.AuditSeverity.FAILURE -> this.failureLevel;
            case AuditEvent.AuditSeverity.SUCCESS -> this.successLevel;
            case AuditEvent.AuditSeverity.INFO -> this.infoLevel;
            case AuditEvent.AuditSeverity.WARN -> this.warnLevel;
            case AuditEvent.AuditSeverity.ERROR -> this.errorLevel;
            default -> this.auditFailureLevel;
        });
    }

    private void logEvent(AuditProvider.TracedAuditEvent event, System.Logger.Level level) {
        if (!this.auditLogger.isLoggable(level)) {
            return;
        }
        AuditProvider.AuditSource auditSource = event.auditSource();
        StringBuilder locationInfo = new StringBuilder();
        locationInfo.append(auditSource.className().orElse("UnknownClass")).append(" ").append(auditSource.methodName().orElse("UnknownMethod")).append(" ").append(auditSource.fileName().orElse("UnknownFile")).append(" ").append(auditSource.lineNumber().orElse(-1));
        Object msg = String.valueOf((Object)event.severity()) + " " + event.eventType() + " " + event.tracingId() + " " + event.getClass().getSimpleName() + " " + String.valueOf(locationInfo) + " :: \"" + this.formatMessage(event) + "\"";
        Object finalMsg = msg = ((String)msg).replace('\n', ' ');
        event.throwable().ifPresentOrElse(arg_0 -> this.lambda$logEvent$1(level, (String)finalMsg, arg_0), () -> this.lambda$logEvent$2(level, (String)finalMsg));
    }

    String formatMessage(AuditEvent event) {
        try {
            return String.format(event.messageFormat(), this.toObjectParams(event.params()));
        }
        catch (Exception e) {
            return "Formatting failed for format: " + event.messageFormat() + ", parameters: " + String.valueOf(event.params());
        }
    }

    private Object[] toObjectParams(List<AuditEvent.AuditParam> parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (AuditEvent.AuditParam param : parameters) {
            if (param.isSensitive()) {
                result.add("(sensitive)");
                continue;
            }
            result.add(param.value().orElse("null"));
        }
        return result.toArray(new Object[0]);
    }

    private /* synthetic */ void lambda$logEvent$2(System.Logger.Level level, String finalMsg) {
        this.auditLogger.log(level, finalMsg);
    }

    private /* synthetic */ void lambda$logEvent$1(System.Logger.Level level, String finalMsg, Throwable throwable) {
        this.auditLogger.log(level, finalMsg, throwable);
    }
}

