/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.spi.OutboundSecurityProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

final class CompositeOutboundProvider
implements OutboundSecurityProvider {
    private final List<OutboundSecurityProvider> providers = new LinkedList<OutboundSecurityProvider>();

    CompositeOutboundProvider(List<OutboundSecurityProvider> providers) {
        this.providers.addAll(providers);
    }

    @Override
    public boolean isOutboundSupported(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        return this.providers.stream().anyMatch(provider -> provider.isOutboundSupported(providerRequest, outboundEnv, outboundConfig));
    }

    @Override
    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        this.providers.forEach(provider -> result.addAll(provider.supportedAnnotations()));
        return result;
    }

    @Override
    public OutboundSecurityResponse outboundSecurity(ProviderRequest providerRequest, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
        OutboundCall previousCall = new OutboundCall(OutboundSecurityResponse.abstain(), providerRequest, outboundEnv, outboundConfig);
        for (OutboundSecurityProvider provider : this.providers) {
            OutboundSecurityResponse outboundResponse;
            if (previousCall.response.status() == SecurityResponse.SecurityStatus.ABSTAIN && provider.isOutboundSupported(previousCall.inboundContext, previousCall.outboundEnv, previousCall.outboundConfig)) {
                outboundResponse = provider.outboundSecurity(previousCall.inboundContext, previousCall.outboundEnv, previousCall.outboundConfig);
                SecurityEnvironment nextEnv = this.updateRequestHeaders(previousCall.outboundEnv, outboundResponse);
                previousCall = new OutboundCall(outboundResponse, previousCall.inboundContext, nextEnv, previousCall.outboundConfig);
            }
            if (!previousCall.response.status().isSuccess()) continue;
            outboundResponse = provider.outboundSecurity(previousCall.inboundContext, previousCall.outboundEnv, previousCall.outboundConfig);
            OutboundSecurityResponse prevResponse = previousCall.response;
            OutboundSecurityResponse.Builder builder = OutboundSecurityResponse.builder();
            prevResponse.requestHeaders().forEach(builder::requestHeader);
            prevResponse.responseHeaders().forEach(builder::responseHeader);
            outboundResponse.requestHeaders().forEach(builder::requestHeader);
            outboundResponse.responseHeaders().forEach(builder::responseHeader);
            SecurityEnvironment nextEnv = this.updateRequestHeaders(previousCall.outboundEnv, outboundResponse);
            builder.status(outboundResponse.status());
            previousCall = new OutboundCall(builder.build(), previousCall.inboundContext, nextEnv, previousCall.outboundConfig);
        }
        return previousCall.response;
    }

    private SecurityEnvironment updateRequestHeaders(SecurityEnvironment env, OutboundSecurityResponse response) {
        SecurityEnvironment.Builder builder = env.derive();
        response.requestHeaders().forEach(builder::header);
        return builder.build();
    }

    private static final class OutboundCall {
        private final ProviderRequest inboundContext;
        private final SecurityEnvironment outboundEnv;
        private final EndpointConfig outboundConfig;
        private final OutboundSecurityResponse response;

        private OutboundCall(OutboundSecurityResponse response, ProviderRequest inboundContext, SecurityEnvironment outboundEnv, EndpointConfig outboundConfig) {
            this.response = response;
            this.inboundContext = inboundContext;
            this.outboundEnv = outboundEnv;
            this.outboundConfig = outboundConfig;
        }
    }
}

