/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.config.Config;
import io.helidon.security.util.TokenHandler;

public final class QueryParamMapping {
    private final String queryParamName;
    private final TokenHandler tokenHandler;

    private QueryParamMapping(String queryParamName, TokenHandler tokenHandler) {
        this.queryParamName = queryParamName;
        this.tokenHandler = tokenHandler;
    }

    public static QueryParamMapping create(String queryParamName, TokenHandler tokenHandler) {
        return new QueryParamMapping(queryParamName, tokenHandler);
    }

    public static QueryParamMapping create(String queryParamName, String headerName) {
        return new QueryParamMapping(queryParamName, TokenHandler.forHeader((String)headerName));
    }

    public static QueryParamMapping create(Config config) {
        String name = (String)config.get("name").asString().get();
        TokenHandler handler = (TokenHandler)config.map(TokenHandler::create).get();
        return QueryParamMapping.create(name, handler);
    }

    public String queryParamName() {
        return this.queryParamName;
    }

    public TokenHandler tokenHandler() {
        return this.tokenHandler;
    }
}

