/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.Builder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public abstract class SecurityResponse {
    private final Map<String, List<String>> requestHeaders;
    private final Map<String, List<String>> responseHeaders;
    private final SecurityStatus status;
    private final String description;
    private final Throwable throwable;
    private final int statusCode;

    SecurityResponse(SecurityResponseBuilder<? extends SecurityResponseBuilder<?, ?>, ?> builder) {
        this.status = builder.status;
        this.description = builder.description;
        this.throwable = builder.throwable;
        this.requestHeaders = builder.requestHeaders;
        this.responseHeaders = builder.responseHeaders;
        this.statusCode = builder.statusCode;
    }

    public SecurityStatus status() {
        return this.status;
    }

    public OptionalInt statusCode() {
        return this.statusCode == -1 ? OptionalInt.empty() : OptionalInt.of(this.statusCode);
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public Map<String, List<String>> requestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, List<String>> responseHeaders() {
        return this.responseHeaders;
    }

    public String toString() {
        return "SecurityResponse{status=" + String.valueOf((Object)this.status) + ", description='" + this.description + "', statusCode=" + this.statusCode + "}";
    }

    static abstract class SecurityResponseBuilder<T extends SecurityResponseBuilder<T, B>, B>
    implements Builder<T, B> {
        private final Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        private final Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        private SecurityStatus status = SecurityStatus.SUCCESS;
        private String description;
        private Throwable throwable;
        private int statusCode = -1;

        SecurityResponseBuilder() {
        }

        public T statusCode(int statusCode) {
            this.statusCode = statusCode;
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T status(SecurityStatus status) {
            this.status = status;
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T description(String description) {
            this.description = description;
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T throwable(Throwable exception) {
            this.throwable = exception;
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T requestHeaders(Map<String, List<String>> headers) {
            this.requestHeaders.clear();
            this.requestHeaders.putAll(headers);
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T requestHeader(String header, String value) {
            this.requestHeaders.put(header, List.of(value));
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T requestHeader(String header, List<String> values) {
            this.requestHeaders.put(header, values);
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T responseHeaders(Map<String, List<String>> headers) {
            this.responseHeaders.clear();
            this.responseHeaders.putAll(headers);
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T responseHeader(String header, String value) {
            this.responseHeaders.put(header, List.of(value));
            return (T)((SecurityResponseBuilder)this.identity());
        }

        public T responseHeader(String header, List<String> values) {
            this.responseHeaders.put(header, values);
            return (T)((SecurityResponseBuilder)this.identity());
        }
    }

    public static enum SecurityStatus {
        SUCCESS(true),
        SUCCESS_FINISH(true),
        FAILURE,
        FAILURE_FINISH,
        ABSTAIN;

        private final boolean success;

        private SecurityStatus() {
            this(false);
        }

        private SecurityStatus(boolean success) {
            this.success = success;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

