/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.ClassToInstanceStore;
import io.helidon.security.Grant;
import io.helidon.security.Principal;
import io.helidon.security.util.AbacSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Subject
implements AbacSupport {
    private final List<Grant> grants = new LinkedList<Grant>();
    private final List<Principal> principals = new LinkedList<Principal>();
    private final Map<String, List<Grant>> grantsByType = new HashMap<String, List<Grant>>();
    private final AbacSupport attributes;
    private final Principal principal;
    private final ClassToInstanceStore<Object> privateCredentials = new ClassToInstanceStore();
    private final ClassToInstanceStore<Object> publicCredentials = new ClassToInstanceStore();

    private Subject(Builder builder) {
        AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create((AbacSupport)builder.properties);
        this.principal = builder.principal;
        this.principals.addAll(builder.principals);
        builder.grants.forEach(grant -> {
            this.grants.add((Grant)grant);
            this.grantsByType.computeIfAbsent(grant.type(), key -> new LinkedList()).add(grant);
        });
        properties.put("principal", (Object)this.principal);
        properties.put("grant", this.grants);
        this.grantsByType.forEach((arg_0, arg_1) -> ((AbacSupport.BasicAttributes)properties).put(arg_0, arg_1));
        this.attributes = properties;
        this.privateCredentials.putAll(builder.privateCredentials);
        this.publicCredentials.putAll(builder.publicCredentials);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Subject create(Principal principal) {
        return Subject.builder().principal(principal).build();
    }

    public Principal principal() {
        return this.principal;
    }

    public List<Principal> principals() {
        return Collections.unmodifiableList(this.principals);
    }

    public <T extends Grant> List<T> grants(Class<T> grantType) {
        return this.grants.stream().filter(grantType::isInstance).map(grantType::cast).collect(Collectors.toList());
    }

    public List<Grant> grantsByType(String grantType) {
        return Collections.unmodifiableList(this.grantsByType.getOrDefault(grantType, List.of()));
    }

    public Object abacAttributeRaw(String key) {
        return this.attributes.abacAttributeRaw(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.attributes.abacAttributeNames();
    }

    public <T> Optional<T> publicCredential(Class<T> credential) {
        return this.publicCredentials.getInstance(credential);
    }

    public <T> Optional<T> privateCredential(Class<T> credential) {
        return this.privateCredentials.getInstance(credential);
    }

    public javax.security.auth.Subject toJavaSubject() {
        LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>(this.principals);
        for (String key : this.attributes.abacAttributeNames()) {
            this.attributes.abacAttribute(key).stream().filter(prop -> prop instanceof Principal).map(Principal.class::cast).forEach(principals::add);
        }
        principals.addAll(this.grants);
        HashSet<Object> pubCredentials = new HashSet<Object>(this.publicCredentials.values());
        HashSet<Object> privCredentials = new HashSet<Object>(this.privateCredentials.values());
        return new javax.security.auth.Subject(true, principals, pubCredentials, privCredentials);
    }

    public Subject combine(Subject another) {
        Builder builder = Subject.builder().addPrincipal(this.principal);
        this.principals.forEach(builder::addPrincipal);
        this.privateCredentials.keys().forEach(key -> builder.addPrivateCredential((Class<?>)key, this.privateCredentials.getInstance(key)));
        this.publicCredentials.keys().forEach(key -> builder.addPublicCredential((Class<?>)key, this.publicCredentials.getInstance(key)));
        this.grants.forEach(builder::addGrant);
        this.attributes.abacAttributeNames().forEach(key -> builder.addAttribute((String)key, this.attributes.abacAttribute(key)));
        another.principals.forEach(builder::addPrincipal);
        another.privateCredentials.keys().forEach(key -> builder.addPrivateCredential((Class<?>)key, another.privateCredentials.getInstance(key)));
        another.publicCredentials.keys().forEach(key -> builder.addPublicCredential((Class<?>)key, another.publicCredentials.getInstance(key)));
        another.grants.forEach(builder::addGrant);
        another.attributes.abacAttributeNames().forEach(key -> builder.addAttribute((String)key, another.attributes.abacAttribute(key)));
        return builder.build();
    }

    public String toString() {
        return this.toJavaSubject().toString();
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, Subject> {
        private final List<Grant> grants = new LinkedList<Grant>();
        private final List<Principal> principals = new LinkedList<Principal>();
        private final ClassToInstanceStore<Object> privateCredentials = new ClassToInstanceStore();
        private final ClassToInstanceStore<Object> publicCredentials = new ClassToInstanceStore();
        private AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create();
        private Principal principal;

        private Builder() {
        }

        public Subject build() {
            return new Subject(this);
        }

        public Builder update(Subject subject) {
            this.principal = subject.principal;
            this.grants.addAll(subject.grants);
            this.principals.addAll(subject.principals);
            this.privateCredentials.putAll(subject.privateCredentials);
            this.publicCredentials.putAll(subject.publicCredentials);
            for (String name : subject.attributes.abacAttributeNames()) {
                subject.attributes.abacAttribute(name).ifPresent(attrib -> this.properties.put(name, attrib));
            }
            return this;
        }

        public Builder principal(Principal principal) {
            this.principal = principal;
            this.principals.add(principal);
            return this;
        }

        public Builder addGrant(Grant grant) {
            this.grants.add(grant);
            return this;
        }

        public Builder addPublicCredential(Class<?> className, Object instance) {
            this.publicCredentials.putInstance(className, instance);
            return this;
        }

        public Builder addPublicCredential(Object instance) {
            this.publicCredentials.putInstance(instance);
            return this;
        }

        public Builder addPrivateCredential(Class<?> className, Object instance) {
            this.privateCredentials.putInstance(className, instance);
            return this;
        }

        public Builder addPrivateCredential(Object instance) {
            this.privateCredentials.putInstance(instance);
            return this;
        }

        public Builder attributes(AbacSupport attributes) {
            this.properties = AbacSupport.BasicAttributes.create((AbacSupport)attributes);
            return this;
        }

        public Builder addAttribute(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder addPrincipal(Principal principal) {
            if (null == this.principal) {
                this.principal = principal;
            }
            this.principals.add(principal);
            return this;
        }
    }
}

