/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.common.reactive.Single;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.config.metadata.Configured;
import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.CompositeProviderSelectionPolicy;
import io.helidon.security.DefaultAuditProvider;
import io.helidon.security.FirstProviderSelectionPolicy;
import io.helidon.security.Grant;
import io.helidon.security.NamedProvider;
import io.helidon.security.ProviderRequest;
import io.helidon.security.ProviderSelectionPolicyType;
import io.helidon.security.ReflectionUtil;
import io.helidon.security.Role;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityImpl;
import io.helidon.security.SecurityTime;
import io.helidon.security.SecurityUtil;
import io.helidon.security.Subject;
import io.helidon.security.spi.AuditProvider;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.AuthorizationProvider;
import io.helidon.security.spi.DigestProvider;
import io.helidon.security.spi.EncryptionProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.ProviderConfig;
import io.helidon.security.spi.ProviderSelectionPolicy;
import io.helidon.security.spi.SecretsProvider;
import io.helidon.security.spi.SecurityProvider;
import io.helidon.security.spi.SecurityProviderService;
import io.helidon.security.spi.SubjectMappingProvider;
import io.helidon.tracing.Tracer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Security {
    public static final String HEADER_ORIG_URI = "X_ORIG_URI_HEADER";

    public static Security create(Config config) {
        Objects.requireNonNull(config, "Configuration must not be null");
        return Security.builder().config(config).build();
    }

    public static Builder builder(Config config) {
        Objects.requireNonNull(config, "Configuration must not be null");
        return Security.builder().config(config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Set<String> getRoles(Subject subject) {
        return subject.grants(Role.class).stream().map(Grant::getName).collect(Collectors.toSet());
    }

    public SecurityTime serverTime();

    public SecurityContext.Builder contextBuilder(String var1);

    public SecurityContext createContext(String var1);

    public Tracer tracer();

    public Collection<Class<? extends Annotation>> customAnnotations();

    public Config configFor(String var1);

    public Single<String> encrypt(String var1, byte[] var2);

    public Single<byte[]> decrypt(String var1, String var2);

    public Single<String> digest(String var1, byte[] var2, boolean var3);

    public Single<String> digest(String var1, byte[] var2);

    public Single<Boolean> verifyDigest(String var1, byte[] var2, String var3, boolean var4);

    public Single<Boolean> verifyDigest(String var1, byte[] var2, String var3);

    public Single<Optional<String>> secret(String var1);

    public Single<String> secret(String var1, String var2);

    public SecurityEnvironment.Builder environmentBuilder();

    public Optional<SubjectMappingProvider> subjectMapper();

    public boolean enabled();

    public void audit(String var1, AuditEvent var2);

    public ProviderSelectionPolicy providerSelectionPolicy();

    public Supplier<ExecutorService> executorService();

    public Optional<? extends AuthenticationProvider> resolveAtnProvider(String var1);

    public Optional<AuthorizationProvider> resolveAtzProvider(String var1);

    public List<? extends OutboundSecurityProvider> resolveOutboundProvider(String var1);

    @Configured(root=true, prefix="security", description="Configuration of security providers, integration and other security options")
    public static final class Builder
    implements io.helidon.common.Builder<Builder, Security> {
        private static final System.Logger LOGGER = System.getLogger(Builder.class.getName());
        private final Set<AuditProvider> auditProviders = new LinkedHashSet<AuditProvider>();
        private final List<NamedProvider<AuthenticationProvider>> atnProviders = new LinkedList<NamedProvider<AuthenticationProvider>>();
        private final List<NamedProvider<AuthorizationProvider>> atzProviders = new LinkedList<NamedProvider<AuthorizationProvider>>();
        private final List<NamedProvider<OutboundSecurityProvider>> outboundProviders = new LinkedList<NamedProvider<OutboundSecurityProvider>>();
        private final Map<String, SecretsProvider<?>> secretsProviders = new HashMap();
        private final Map<String, EncryptionProvider<?>> encryptionProviders = new HashMap();
        private final Map<String, DigestProvider<?>> digestProviders = new HashMap();
        private final Map<SecurityProvider, Boolean> allProviders = new IdentityHashMap<SecurityProvider, Boolean>();
        private final Map<String, Supplier<Single<Optional<String>>>> secrets = new HashMap<String, Supplier<Single<Optional<String>>>>();
        private final Map<String, EncryptionProvider.EncryptionSupport> encryptions = new HashMap<String, EncryptionProvider.EncryptionSupport>();
        private final Map<String, DigestProvider.DigestSupport> digests = new HashMap<String, DigestProvider.DigestSupport>();
        private final Set<String> providerNames = new HashSet<String>();
        private NamedProvider<AuthenticationProvider> authnProvider;
        private NamedProvider<AuthorizationProvider> authzProvider;
        private SubjectMappingProvider subjectMappingProvider;
        private Config config = Config.empty();
        private Function<ProviderSelectionPolicy.Providers, ProviderSelectionPolicy> providerSelectionPolicy = FirstProviderSelectionPolicy::new;
        private Tracer tracer;
        private boolean tracingEnabled = true;
        private SecurityTime serverTime = SecurityTime.builder().build();
        private Supplier<ExecutorService> executorService = ThreadPoolSupplier.create((String)"security-thread-pool");
        private boolean enabled = true;

        private Builder() {
        }

        public Builder providerSelectionPolicy(Function<ProviderSelectionPolicy.Providers, ProviderSelectionPolicy> pspFunction) {
            this.providerSelectionPolicy = pspFunction;
            return this;
        }

        public Builder serverTime(SecurityTime time) {
            this.serverTime = time;
            return this;
        }

        public Builder tracer(Tracer tracer) {
            this.tracer = tracer;
            this.tracingEnabled(null != tracer);
            return this;
        }

        public Builder tracingEnabled(boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public Builder disableTracing() {
            return this.tracingEnabled(false);
        }

        public Builder addProvider(SecurityProvider provider) {
            return this.addProvider(provider, provider.getClass().getSimpleName());
        }

        public Builder addProvider(Supplier<? extends SecurityProvider> providerBuilder) {
            return this.addProvider(providerBuilder.get());
        }

        public Builder addProvider(SecurityProvider provider, String name) {
            Objects.requireNonNull(provider);
            if (provider instanceof AuthenticationProvider) {
                this.addAuthenticationProvider((AuthenticationProvider)provider, name);
            }
            if (provider instanceof AuthorizationProvider) {
                this.addAuthorizationProvider((AuthorizationProvider)provider, name);
            }
            if (provider instanceof OutboundSecurityProvider) {
                this.addOutboundSecurityProvider((OutboundSecurityProvider)provider, name);
            }
            if (provider instanceof AuditProvider) {
                this.addAuditProvider((AuditProvider)provider);
            }
            if (provider instanceof SubjectMappingProvider) {
                this.subjectMappingProvider((SubjectMappingProvider)provider);
            }
            return this;
        }

        public Builder addProvider(Supplier<? extends SecurityProvider> providerBuilder, String name) {
            return this.addProvider(providerBuilder.get(), name);
        }

        public Builder authenticationProvider(AuthenticationProvider provider) {
            this.authnProvider = new NamedProvider<AuthenticationProvider>(provider.getClass().getSimpleName(), provider);
            return this.addAuthenticationProvider(provider, provider.getClass().getSimpleName());
        }

        public Builder authenticationProvider(Supplier<? extends AuthenticationProvider> builder) {
            return this.authenticationProvider(builder.get());
        }

        public Builder authorizationProvider(AuthorizationProvider provider) {
            this.authzProvider = new NamedProvider<AuthorizationProvider>(provider.getClass().getSimpleName(), provider);
            return this.addAuthorizationProvider(provider, provider.getClass().getSimpleName());
        }

        public Builder authorizationProvider(Supplier<? extends AuthorizationProvider> builder) {
            return this.authorizationProvider(builder.get());
        }

        public Builder addAuthenticationProvider(AuthenticationProvider provider) {
            return this.addAuthenticationProvider(provider, provider.getClass().getSimpleName());
        }

        public Builder addAuthenticationProvider(Supplier<? extends AuthenticationProvider> builder) {
            return this.addAuthenticationProvider(builder.get());
        }

        public Builder addAuthenticationProvider(AuthenticationProvider provider, String name) {
            Objects.requireNonNull(provider);
            NamedProvider<AuthenticationProvider> namedProvider = new NamedProvider<AuthenticationProvider>(name, provider);
            if (null == this.authnProvider) {
                this.authnProvider = namedProvider;
            }
            this.atnProviders.add(namedProvider);
            this.allProviders.put(provider, true);
            if (null != name) {
                this.providerNames.add(name);
            }
            return this;
        }

        public Builder addAuthenticationProvider(Supplier<? extends AuthenticationProvider> builder, String name) {
            return this.addAuthenticationProvider(builder.get(), name);
        }

        public Builder addAuthorizationProvider(AuthorizationProvider provider) {
            return this.addAuthorizationProvider(provider, provider.getClass().getSimpleName());
        }

        public Builder addAuthorizationProvider(Supplier<? extends AuthorizationProvider> builder) {
            return this.addAuthorizationProvider(builder.get());
        }

        public Builder addAuthorizationProvider(AuthorizationProvider provider, String name) {
            Objects.requireNonNull(provider);
            NamedProvider<AuthorizationProvider> namedProvider = new NamedProvider<AuthorizationProvider>(name, provider);
            if (null == this.authzProvider) {
                this.authzProvider = namedProvider;
            }
            this.atzProviders.add(namedProvider);
            this.allProviders.put(provider, true);
            if (null != name) {
                this.providerNames.add(name);
            }
            return this;
        }

        public Builder addAuthorizationProvider(Supplier<? extends AuthorizationProvider> builder, String name) {
            return this.addAuthorizationProvider(builder.get(), name);
        }

        public Builder addOutboundSecurityProvider(OutboundSecurityProvider provider) {
            return this.addOutboundSecurityProvider(provider, provider.getClass().getSimpleName());
        }

        public Builder addOutboundSecurityProvider(Supplier<? extends OutboundSecurityProvider> builder) {
            return this.addOutboundSecurityProvider(builder.get());
        }

        public Builder addOutboundSecurityProvider(Supplier<? extends OutboundSecurityProvider> build, String name) {
            return this.addOutboundSecurityProvider(build.get(), name);
        }

        public Builder addOutboundSecurityProvider(OutboundSecurityProvider provider, String name) {
            Objects.requireNonNull(provider);
            Objects.requireNonNull(name);
            this.outboundProviders.add(new NamedProvider<OutboundSecurityProvider>(name, provider));
            this.allProviders.put(provider, true);
            this.providerNames.add(name);
            return this;
        }

        public Builder addSecretProvider(SecretsProvider<?> provider, String name) {
            Objects.requireNonNull(provider);
            Objects.requireNonNull(name);
            this.secretsProviders.put(name, provider);
            this.allProviders.put(provider, true);
            this.providerNames.add(name);
            return this;
        }

        public Builder addEncryptionProvider(EncryptionProvider<?> provider, String name) {
            Objects.requireNonNull(provider);
            Objects.requireNonNull(name);
            this.encryptionProviders.put(name, provider);
            this.allProviders.put(provider, true);
            this.providerNames.add(name);
            return this;
        }

        public Builder addDigestProvider(DigestProvider<?> provider, String name) {
            Objects.requireNonNull(provider);
            Objects.requireNonNull(name);
            this.digestProviders.put(name, provider);
            this.allProviders.put(provider, true);
            this.providerNames.add(name);
            return this;
        }

        public Builder addAuditProvider(AuditProvider provider) {
            this.auditProviders.add(provider);
            this.allProviders.put(provider, true);
            return this;
        }

        public Builder subjectMappingProvider(SubjectMappingProvider provider) {
            this.subjectMappingProvider = provider;
            this.allProviders.put(provider, true);
            return this;
        }

        public Builder addAuditProvider(Supplier<? extends AuditProvider> builder) {
            return this.addAuditProvider(builder.get());
        }

        public Builder config(Config config) {
            this.config = config;
            this.fromConfig(config);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Security build() {
            if (this.allProviders.isEmpty() && this.enabled) {
                LOGGER.log(System.Logger.Level.WARNING, "Security component is NOT configured with any security providers.");
            }
            if (this.auditProviders.isEmpty()) {
                DefaultAuditProvider provider = DefaultAuditProvider.create(this.config);
                this.addAuditProvider(provider);
            }
            if (this.atnProviders.isEmpty()) {
                this.addAuthenticationProvider((ProviderRequest context) -> CompletableFuture.completedFuture(AuthenticationResponse.success(SecurityContext.ANONYMOUS)), "default");
            }
            if (this.atzProviders.isEmpty()) {
                this.addAuthorizationProvider(new DefaultAtzProvider(), "default");
            }
            if (!this.enabled) {
                this.providerSelectionPolicy(FirstProviderSelectionPolicy::new);
            }
            return new SecurityImpl(this);
        }

        public <T extends ProviderConfig> Builder addSecret(String name, SecretsProvider<T> secretProvider, T providerConfig) {
            this.secrets.put(name, secretProvider.secret(providerConfig));
            return this;
        }

        public <T extends ProviderConfig> Builder addEncryption(String name, EncryptionProvider<T> encryptionProvider, T providerConfig) {
            this.encryptions.put(name, encryptionProvider.encryption(providerConfig));
            return this;
        }

        public <T extends ProviderConfig> Builder addDigest(String name, DigestProvider<T> digestProvider, T providerConfig) {
            this.digests.put(name, digestProvider.digest(providerConfig));
            return this;
        }

        private void fromConfig(Config config) {
            String defaultAtzProvider;
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            if (!this.enabled) {
                LOGGER.log(System.Logger.Level.INFO, "Security is disabled, ignoring provider configuration");
                return;
            }
            config.get("environment.server-time").as(SecurityTime::create).ifPresent(this::serverTime);
            this.executorService((Supplier<ExecutorService>)ThreadPoolSupplier.create((Config)config.get("environment.executor-service"), (String)"security-thread-pool"));
            HashMap<String, SecurityProviderService> configKeyToService = new HashMap<String, SecurityProviderService>();
            HashMap<String, SecurityProviderService> classNameToService = new HashMap<String, SecurityProviderService>();
            String knownKeys = this.loadProviderServices(configKeyToService, classNameToService);
            config.get("tracing.enabled").as(Boolean.class).ifPresent(this::tracingEnabled);
            config.get("providers").asList(Config.class).ifPresent(confList -> confList.forEach(pConf -> this.providerFromConfig(configKeyToService, classNameToService, knownKeys, (Config)pConf)));
            String defaultAtnProvider = (String)config.get("default-authentication-provider").asString().orElse(null);
            if (null != defaultAtnProvider) {
                this.authenticationProvider(this.atnProviders.stream().filter(nsp -> nsp.getName().equals(defaultAtnProvider)).findFirst().map(NamedProvider::getProvider).orElseThrow(() -> new SecurityException("Authentication provider named \"" + defaultAtnProvider + "\" is set as default, yet no provider configuration exists")));
            }
            if (null != (defaultAtzProvider = (String)config.get("default-authorization-provider").asString().orElse(null))) {
                this.authorizationProvider(this.atzProviders.stream().filter(nsp -> nsp.getName().equals(defaultAtzProvider)).findFirst().map(NamedProvider::getProvider).orElseThrow(() -> new SecurityException("Authorization provider named \"" + defaultAtzProvider + "\" is set as default, yet no provider configuration exists")));
            }
            Config providerPolicyConfig = config.get("provider-policy");
            ProviderSelectionPolicyType pType = providerPolicyConfig.get("type").asString().map(ProviderSelectionPolicyType::valueOf).orElse(ProviderSelectionPolicyType.FIRST);
            switch (pType) {
                case FIRST: {
                    this.providerSelectionPolicy = FirstProviderSelectionPolicy::new;
                    break;
                }
                case COMPOSITE: {
                    this.providerSelectionPolicy = CompositeProviderSelectionPolicy.create(providerPolicyConfig);
                    break;
                }
                case CLASS: {
                    this.providerSelectionPolicy = this.findProviderSelectionPolicy(providerPolicyConfig);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid enum option: " + pType + ", probably version mis-match");
                }
            }
            config.get("secrets").asList(Config.class).ifPresent(confList -> confList.forEach(sConf -> {
                String name = (String)sConf.get("name").asString().get();
                String provider = (String)sConf.get("provider").asString().get();
                Config secretConfig = sConf.get("config");
                SecretsProvider<?> secretsProvider = this.secretsProviders.get(provider);
                if (secretsProvider == null) {
                    throw new SecurityException("Provider \"" + provider + "\" used for secret \"" + name + "\" not found");
                }
                this.secrets.put(name, secretsProvider.secret(secretConfig));
            }));
            config.get("encryption").asList(Config.class).ifPresent(confList -> confList.forEach(eConf -> {
                String name = (String)eConf.get("name").asString().get();
                String provider = (String)eConf.get("provider").asString().get();
                Config encryptionConfig = eConf.get("config");
                EncryptionProvider<?> encryptionProvider = this.encryptionProviders.get(provider);
                if (encryptionProvider == null) {
                    throw new SecurityException("Provider \"" + provider + "\" used for encryption \"" + name + "\" not found");
                }
                this.encryptions.put(name, encryptionProvider.encryption(encryptionConfig));
            }));
            config.get("digest").asList(Config.class).ifPresent(confList -> confList.forEach(dConf -> {
                String name = (String)dConf.get("name").asString().get();
                String provider = (String)dConf.get("provider").asString().get();
                Config digestConfig = dConf.get("config");
                DigestProvider<?> digestProvider = this.digestProviders.get(provider);
                if (digestProvider == null) {
                    throw new SecurityException("Provider \"" + provider + "\" used for digest \"" + name + "\" not found");
                }
                this.digests.put(name, digestProvider.digest(digestConfig));
            }));
        }

        private void providerFromConfig(Map<String, SecurityProviderService> configKeyToService, Map<String, SecurityProviderService> classNameToService, String knownKeys, Config pConf) {
            boolean enabled = (Boolean)pConf.get("enabled").asBoolean().orElse((Object)true);
            if (!enabled) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Provider with key: " + pConf.key() + " is disabled");
                }
                return;
            }
            AtomicReference<SecurityProviderService> service = new AtomicReference<SecurityProviderService>();
            AtomicReference<Config> providerSpecific = new AtomicReference<Config>();
            String className = (String)pConf.get("class").asString().orElse(null);
            if (null == className) {
                this.findProviderService(configKeyToService, knownKeys, pConf, service, providerSpecific);
            } else {
                SecurityProviderService providerService = classNameToService.get(className);
                if (null == providerService) {
                    this.findProviderSpecificConfig(pConf, providerSpecific);
                } else {
                    service.set(providerService);
                    providerSpecific.set(pConf.get(providerService.providerConfigKey()));
                }
            }
            Config providerSpecificConfig = providerSpecific.get();
            SecurityProviderService providerService = service.get();
            if (null == className && null == providerService) {
                throw new SecurityException("Each configured provider MUST have a \"class\" configuration property defined or a custom configuration section mapped to that provider, supported keys: " + knownKeys);
            }
            String name = this.resolveProviderName(pConf, className, providerSpecificConfig, providerService);
            if (providerSpecificConfig != null && !((Boolean)providerSpecificConfig.get("enabled").asBoolean().orElse((Object)true)).booleanValue()) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Provider: " + name + " is disabled");
                }
                return;
            }
            boolean isAuthn = (Boolean)pConf.get("is-authentication-provider").asBoolean().orElse((Object)true);
            boolean isAuthz = (Boolean)pConf.get("is-authorization-provider").asBoolean().orElse((Object)true);
            boolean isClientSec = (Boolean)pConf.get("is-client-security-provider").asBoolean().orElse((Object)true);
            boolean isAudit = (Boolean)pConf.get("is-audit-provider").asBoolean().orElse((Object)true);
            boolean isSubjectMapper = (Boolean)pConf.get("is-subject-mapper").asBoolean().orElse((Object)true);
            SecurityProvider provider = null == providerService ? SecurityUtil.instantiate(className, SecurityProvider.class, providerSpecificConfig) : providerService.providerInstance(providerSpecificConfig);
            if (isAuthn && provider instanceof AuthenticationProvider) {
                this.addAuthenticationProvider((AuthenticationProvider)provider, name);
            }
            if (isAuthz && provider instanceof AuthorizationProvider) {
                this.addAuthorizationProvider((AuthorizationProvider)provider, name);
            }
            if (isClientSec && provider instanceof OutboundSecurityProvider) {
                this.addOutboundSecurityProvider((OutboundSecurityProvider)provider, name);
            }
            if (isAudit && provider instanceof AuditProvider) {
                this.addAuditProvider((AuditProvider)provider);
            }
            if (isSubjectMapper && provider instanceof SubjectMappingProvider) {
                this.subjectMappingProvider((SubjectMappingProvider)provider);
            }
            if (provider instanceof SecretsProvider) {
                this.addSecretProvider((SecretsProvider)provider, name);
            }
            if (provider instanceof EncryptionProvider) {
                this.addEncryptionProvider((EncryptionProvider)provider, name);
            }
            if (provider instanceof DigestProvider) {
                this.addDigestProvider((DigestProvider)provider, name);
            }
        }

        public Builder executorService(Supplier<ExecutorService> supplier) {
            this.executorService = supplier;
            return this;
        }

        private String resolveProviderName(Config pConf, String className, Config providerSpecificConfig, SecurityProviderService providerService) {
            return (String)pConf.get("name").asString().orElseGet(() -> {
                if (null == providerSpecificConfig) {
                    if (null == className) {
                        return providerService.providerClass().getSimpleName();
                    }
                    int index = className.indexOf(46);
                    if (index > -1) {
                        return className.substring(index + 1);
                    }
                    return className;
                }
                return providerSpecificConfig.name();
            });
        }

        private void findProviderSpecificConfig(Config pConf, AtomicReference<Config> providerSpecific) {
            ((List)pConf.asNodeList().get()).stream().filter(this::notReservedProviderKey).forEach(providerSpecificConf -> {
                if (!providerSpecific.compareAndSet((Config)null, (Config)providerSpecificConf)) {
                    throw new SecurityException("More than one provider configurations found, each provider can only have one provide specific config. Conflict: " + ((Config)providerSpecific.get()).key() + " and " + providerSpecificConf.key());
                }
            });
        }

        private void findProviderService(Map<String, SecurityProviderService> configKeyToService, String knownKeys, Config pConf, AtomicReference<SecurityProviderService> service, AtomicReference<Config> providerSpecific) {
            ConfigValue type = pConf.get("type").asString();
            if (type.isPresent()) {
                this.findProviderService(service, configKeyToService, (String)type.get(), knownKeys);
                providerSpecific.set(pConf.get((String)type.get()));
            } else {
                ((List)pConf.asNodeList().get()).stream().filter(this::notReservedProviderKey).forEach(providerSpecificConf -> {
                    if (!providerSpecific.compareAndSet((Config)null, (Config)providerSpecificConf)) {
                        throw new SecurityException("More than one provider configurations found, each provider can only have one provider specific config. Conflict: " + ((Config)providerSpecific.get()).key() + " and " + providerSpecificConf.key());
                    }
                    this.findProviderService(service, configKeyToService, providerSpecificConf.name(), knownKeys);
                });
            }
        }

        private void findProviderService(AtomicReference<SecurityProviderService> service, Map<String, SecurityProviderService> configKeyToService, String name, String knownKeys) {
            if (!configKeyToService.containsKey(name)) {
                throw new SecurityException("Configuration key " + name + " is not a valid provider configuration. Supported keys: " + knownKeys);
            }
            service.set(configKeyToService.get(name));
        }

        private String loadProviderServices(Map<String, SecurityProviderService> configKeyToService, Map<String, SecurityProviderService> classNameToService) {
            HashSet configKeys = new HashSet();
            HelidonServiceLoader loader = HelidonServiceLoader.create(ServiceLoader.load(SecurityProviderService.class));
            loader.forEach(service -> {
                String configKey = service.providerConfigKey();
                if (null != configKey) {
                    configKeyToService.put(configKey, (SecurityProviderService)service);
                    configKeys.add(configKey);
                }
                Class<? extends SecurityProvider> theClass = service.providerClass();
                classNameToService.put(theClass.getName(), (SecurityProviderService)service);
            });
            return String.join((CharSequence)", ", configKeys);
        }

        private boolean notReservedProviderKey(Config config) {
            return !SecurityImpl.RESERVED_PROVIDER_KEYS.contains(config.name());
        }

        private Function<ProviderSelectionPolicy.Providers, ProviderSelectionPolicy> findProviderSelectionPolicy(Config config) {
            Class clazz = (Class)config.get("class-name").as(Class.class).orElseThrow(() -> new java.lang.SecurityException("You have configured a CLASS provider selection without configuring class-name"));
            if (!ProviderSelectionPolicy.class.isAssignableFrom(clazz)) {
                throw new SecurityException("Class " + clazz.getName() + " does not implement ProviderSelectionPolicy");
            }
            Class pspClass = clazz;
            try {
                Constructor constructor = pspClass.getConstructor(ProviderSelectionPolicy.Providers.class, Config.class);
                if (ReflectionUtil.canAccess(this.getClass(), constructor)) {
                    return providers -> {
                        try {
                            return (ProviderSelectionPolicy)constructor.newInstance(providers, config);
                        }
                        catch (Exception e) {
                            throw new SecurityException("Failed to instantiate ProviderSelectionPolicy", e);
                        }
                    };
                }
                throw new SecurityException("Constructor " + constructor + " of class " + clazz.getName() + " is not accessible");
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor constructor2 = pspClass.getConstructor(ProviderSelectionPolicy.Providers.class);
                    if (ReflectionUtil.canAccess(this.getClass(), constructor2)) {
                        return providers -> {
                            try {
                                return (ProviderSelectionPolicy)constructor2.newInstance(providers);
                            }
                            catch (Exception e) {
                                throw new SecurityException("Failed to instantiate ProviderSelectionPolicy", e);
                            }
                        };
                    }
                    throw new SecurityException("Constructor " + constructor2 + " of class " + clazz.getName() + " is not accessible");
                }
                catch (NoSuchMethodException e) {
                    throw new SecurityException("You have configured " + clazz.getName() + " as provider selection policy class, yet it is missing public constructor with Providers or Providers and Config as parameters.", e);
                }
            }
        }

        public boolean noProvider(Class<? extends SecurityProvider> providerClass) {
            if (providerClass.equals(AuthenticationProvider.class)) {
                return this.atnProviders.isEmpty();
            }
            if (providerClass.equals(AuthorizationProvider.class)) {
                return this.atzProviders.isEmpty();
            }
            if (providerClass.equals(OutboundSecurityProvider.class)) {
                return this.outboundProviders.isEmpty();
            }
            if (providerClass.equals(AuditProvider.class)) {
                return this.auditProviders.isEmpty();
            }
            if (providerClass.equals(SubjectMappingProvider.class)) {
                return this.subjectMappingProvider == null;
            }
            return this.allProviders.isEmpty();
        }

        public boolean hasProvider(String name) {
            return this.providerNames.stream().anyMatch(name::equals);
        }

        Set<AuditProvider> auditProviders() {
            return this.auditProviders;
        }

        List<NamedProvider<AuthenticationProvider>> atnProviders() {
            return this.atnProviders;
        }

        List<NamedProvider<AuthorizationProvider>> atzProviders() {
            return this.atzProviders;
        }

        List<NamedProvider<OutboundSecurityProvider>> outboundProviders() {
            return this.outboundProviders;
        }

        Map<String, SecretsProvider<?>> secretsProviders() {
            return this.secretsProviders;
        }

        Map<String, EncryptionProvider<?>> encryptionProviders() {
            return this.encryptionProviders;
        }

        Map<String, DigestProvider<?>> digestProviders() {
            return this.digestProviders;
        }

        Map<SecurityProvider, Boolean> allProviders() {
            return this.allProviders;
        }

        Map<String, Supplier<Single<Optional<String>>>> secrets() {
            return this.secrets;
        }

        Map<String, EncryptionProvider.EncryptionSupport> encryptions() {
            return this.encryptions;
        }

        Map<String, DigestProvider.DigestSupport> digests() {
            return this.digests;
        }

        Set<String> providerNames() {
            return this.providerNames;
        }

        NamedProvider<AuthenticationProvider> authnProvider() {
            return this.authnProvider;
        }

        NamedProvider<AuthorizationProvider> authzProvider() {
            return this.authzProvider;
        }

        SubjectMappingProvider subjectMappingProvider() {
            return this.subjectMappingProvider;
        }

        Config config() {
            return this.config;
        }

        Function<ProviderSelectionPolicy.Providers, ProviderSelectionPolicy> providerSelectionPolicy() {
            return this.providerSelectionPolicy;
        }

        Tracer tracer() {
            return this.tracer;
        }

        boolean tracingEnabled() {
            return this.tracingEnabled;
        }

        SecurityTime serverTime() {
            return this.serverTime;
        }

        Supplier<ExecutorService> executorService() {
            return this.executorService;
        }

        boolean enabled() {
            return this.enabled;
        }

        private static class DefaultAtzProvider
        implements AuthorizationProvider {
            private DefaultAtzProvider() {
            }

            @Override
            public CompletionStage<AuthorizationResponse> authorize(ProviderRequest context) {
                return CompletableFuture.completedFuture(AuthorizationResponse.permit());
            }
        }
    }
}

