/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.context.Contexts;
import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationClientImpl;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationClientImpl;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.Role;
import io.helidon.security.Security;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityTime;
import io.helidon.security.Subject;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.spi.AuthorizationProvider;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

final class SecurityContextImpl
implements SecurityContext {
    private final Security security;
    private final String tracingId;
    private final SpanContext requestSpan;
    private final Supplier<ExecutorService> executorService;
    private final Tracer securityTracer;
    private final SecurityTime serverTime;
    private final ReadWriteLock envLock = new ReentrantReadWriteLock();
    private final ReadWriteLock ecLock = new ReentrantReadWriteLock();
    private volatile SecurityEnvironment environment;
    private volatile EndpointConfig ec;
    private volatile Subject serviceSubject;
    private volatile Subject currentSubject;
    private volatile AtomicBoolean atzChecked = new AtomicBoolean(false);

    SecurityContextImpl(SecurityContext.Builder builder) {
        this.security = builder.security();
        this.tracingId = builder.id();
        this.requestSpan = builder.tracingSpan();
        this.executorService = builder.executorServiceSupplier();
        this.securityTracer = builder.tracingTracer();
        this.serverTime = builder.serverTime();
        this.environment = builder.env();
        this.ec = builder.endpointConfig();
    }

    @Override
    public SpanContext tracingSpan() {
        return this.requestSpan;
    }

    @Override
    public Tracer tracer() {
        return this.securityTracer;
    }

    @Override
    public String id() {
        return this.tracingId;
    }

    @Override
    public SecurityTime serverTime() {
        return this.serverTime;
    }

    @Override
    public SecurityRequestBuilder<?> securityRequestBuilder() {
        return this.securityRequestBuilder(this.env());
    }

    @Override
    public SecurityRequestBuilder<?> securityRequestBuilder(SecurityEnvironment environment) {
        return new SecurityRequestBuilder(this);
    }

    @Override
    public SecurityClientBuilder<AuthenticationResponse> atnClientBuilder() {
        return new SecurityClientBuilder<AuthenticationResponse>(this.security, this, AuthenticationClientImpl::new);
    }

    @Override
    public AuthenticationResponse authenticate() {
        return this.atnClientBuilder().buildAndGet();
    }

    @Override
    public SecurityClientBuilder<AuthorizationResponse> atzClientBuilder() {
        this.atzChecked.set(true);
        return new SecurityClientBuilder<AuthorizationResponse>(this.security, this, AuthorizationClientImpl::new);
    }

    @Override
    public OutboundSecurityClientBuilder outboundClientBuilder() {
        return new OutboundSecurityClientBuilder(this.security, this);
    }

    @Override
    public boolean isAuthenticated() {
        return this.user().isPresent();
    }

    @Override
    public void logout() {
        this.currentSubject = ANONYMOUS;
    }

    @Override
    public ExecutorService executorService() {
        return this.executorService.get();
    }

    @Override
    public boolean isUserInRole(String role) {
        if (!this.isAuthenticated()) {
            return false;
        }
        Optional<AuthorizationProvider> authorizationProvider = this.security.providerSelectionPolicy().selectProvider(AuthorizationProvider.class);
        return authorizationProvider.map(provider -> provider.isUserInRole(this.currentSubject, role)).orElseGet(() -> this.user().map(Security::getRoles).orElse(Set.of()).stream().anyMatch(role::equals));
    }

    @Override
    public boolean isUserInRole(String role, String authorizerName) {
        return this.security.resolveAtzProvider(authorizerName).map(provider -> provider.isUserInRole(this.currentSubject, role)).orElse(false);
    }

    @Override
    public AuthorizationResponse authorize(Object ... resource) {
        this.atzChecked.set(true);
        SecurityClientBuilder<AuthorizationResponse> builder = this.atzClientBuilder();
        for (int i = 0; i < resource.length; ++i) {
            if (i == 0) {
                builder.object(resource[i]);
            }
            builder.object("object" + i, resource[i]);
        }
        return builder.buildAndGet();
    }

    @Override
    public void audit(AuditEvent event) {
        this.security.audit(this.tracingId, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAs(Subject subject, Runnable runnable) {
        this.audit(SecurityAuditEvent.info("security.runAs", "runAs(Subject,Runnable) invoked for %s").addParam(AuditEvent.AuditParam.plain("subject", subject)));
        Subject original = this.currentSubject;
        try {
            this.currentSubject = subject;
            runnable.run();
        }
        finally {
            this.currentSubject = original;
        }
    }

    @Override
    public void runAs(String role, Runnable runnable) {
        Subject currentSubject = this.currentSubject;
        Subject runAsSubject = Subject.builder().principal(currentSubject.principal()).addGrant(Role.create(role)).build();
        this.runAs(runAsSubject, runnable);
    }

    @Override
    public Optional<Subject> service() {
        if (this.serviceSubject == ANONYMOUS) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.serviceSubject);
    }

    void setService(Subject serviceSubject) {
        Objects.requireNonNull(serviceSubject);
        this.serviceSubject = serviceSubject;
    }

    @Override
    public Optional<Subject> user() {
        if (this.currentSubject == ANONYMOUS) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.currentSubject);
    }

    void setUser(Subject subject) {
        Objects.requireNonNull(subject);
        this.currentSubject = subject;
        Contexts.context().ifPresent(ctx -> ctx.register((Object)this.currentSubject.principal()));
    }

    @Override
    public EndpointConfig endpointConfig() {
        Lock lock = this.ecLock.readLock();
        try {
            lock.lock();
            EndpointConfig endpointConfig = this.ec;
            return endpointConfig;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void endpointConfig(EndpointConfig ec) {
        Lock lock = this.ecLock.writeLock();
        try {
            lock.lock();
            this.ec = ec;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SecurityEnvironment env() {
        Lock rl = this.envLock.readLock();
        try {
            rl.lock();
            SecurityEnvironment securityEnvironment = this.environment;
            return securityEnvironment;
        }
        finally {
            rl.unlock();
        }
    }

    @Override
    public void env(SecurityEnvironment env) {
        Lock lock = this.envLock.writeLock();
        try {
            lock.lock();
            this.environment = env;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean atzChecked() {
        return this.atzChecked.get();
    }
}

