/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.util.AbacSupport;
import java.security.Principal;
import java.util.Collection;
import java.util.Objects;

public class Grant
implements AbacSupport,
Principal {
    private final AbacSupport properties;
    private final String type;
    private final String name;
    private final String origin;

    protected Grant(Builder<?> builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.origin = builder.origin;
        AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create((AbacSupport)builder.properties);
        properties.put("type", (Object)this.type);
        properties.put("name", (Object)this.name);
        properties.put("origin", (Object)this.origin);
        this.properties = properties;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public Object abacAttributeRaw(String key) {
        return this.properties.abacAttributeRaw(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.properties.abacAttributeNames();
    }

    public String type() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.type + ":" + this.name;
    }

    public String origin() {
        return this.origin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Grant)) {
            return false;
        }
        Grant grant = (Grant)o;
        return this.type.equals(grant.type) && this.getName().equals(grant.getName()) && this.origin.equals(grant.origin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.getName(), this.origin);
    }

    public static class Builder<B extends Builder<B>>
    implements io.helidon.common.Builder<B, Grant> {
        private AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create();
        private String type;
        private String name;
        private String origin = "builder";

        protected Builder() {
        }

        public Grant build() {
            return new Grant(this);
        }

        public B type(String type) {
            this.type = type;
            return (B)((Builder)this.identity());
        }

        public B name(String name) {
            this.name = name;
            return (B)((Builder)this.identity());
        }

        public B origin(String origin) {
            this.origin = origin;
            return (B)((Builder)this.identity());
        }

        public B attributes(AbacSupport attribs) {
            this.properties = AbacSupport.BasicAttributes.create((AbacSupport)attribs);
            return (B)((Builder)this.identity());
        }

        public B addAttribute(String key, Object value) {
            this.properties.put(key, value);
            return (B)((Builder)this.identity());
        }
    }
}

