/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.Principal;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import java.util.Optional;

public final class AuthenticationResponse
extends SecurityResponse {
    private final Optional<Subject> user;
    private final Optional<Subject> service;

    AuthenticationResponse(Builder builder) {
        super(builder);
        this.user = Optional.ofNullable(builder.user);
        this.service = Optional.ofNullable(builder.service);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AuthenticationResponse failed(String message, Throwable cause) {
        return ((Builder)((Builder)((Builder)AuthenticationResponse.builder().description(message)).throwable(cause)).status(SecurityResponse.SecurityStatus.FAILURE)).build();
    }

    public static AuthenticationResponse failed(String message) {
        return ((Builder)((Builder)AuthenticationResponse.builder().description(message)).status(SecurityResponse.SecurityStatus.FAILURE)).build();
    }

    public static AuthenticationResponse abstain() {
        return ((Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.ABSTAIN)).build();
    }

    public static AuthenticationResponse success(Subject subject) {
        return ((Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.SUCCESS)).user(subject).build();
    }

    public static AuthenticationResponse success(Subject user, Subject service) {
        return ((Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.SUCCESS)).user(user).service(service).build();
    }

    public static AuthenticationResponse successService(Subject service) {
        return ((Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.SUCCESS)).service(service).build();
    }

    public static AuthenticationResponse success(Principal principal) {
        return AuthenticationResponse.success(Subject.builder().principal(principal).build());
    }

    public static AuthenticationResponse successService(Principal principal) {
        return AuthenticationResponse.successService(Subject.builder().principal(principal).build());
    }

    public Optional<Subject> user() {
        return this.user;
    }

    public Optional<Subject> service() {
        return this.service;
    }

    @Override
    public String toString() {
        return "AuthenticationResponse{" + super.toString() + "user=" + this.user + ", service=" + this.service + "}";
    }

    public static final class Builder
    extends SecurityResponse.SecurityResponseBuilder<Builder, AuthenticationResponse> {
        private Subject user;
        private Subject service;

        private Builder() {
        }

        public Builder user(Subject subject) {
            this.user = subject;
            return this;
        }

        public Builder service(Subject subject) {
            this.service = subject;
            return this;
        }

        public AuthenticationResponse build() {
            return new AuthenticationResponse(this);
        }
    }
}

