/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.SecurityResponse;
import java.util.EnumSet;
import java.util.Set;

public enum CompositeProviderFlag {
    MAY_FAIL(EnumSet.of(SecurityResponse.SecurityStatus.SUCCESS, SecurityResponse.SecurityStatus.ABSTAIN, SecurityResponse.SecurityStatus.FAILURE)),
    SUFFICIENT(EnumSet.of(SecurityResponse.SecurityStatus.SUCCESS, SecurityResponse.SecurityStatus.ABSTAIN)),
    OPTIONAL(EnumSet.of(SecurityResponse.SecurityStatus.SUCCESS, SecurityResponse.SecurityStatus.ABSTAIN)),
    REQUIRED(EnumSet.of(SecurityResponse.SecurityStatus.SUCCESS)),
    FORBIDDEN(EnumSet.of(SecurityResponse.SecurityStatus.ABSTAIN, SecurityResponse.SecurityStatus.FAILURE)),
    MUST_FAIL(EnumSet.of(SecurityResponse.SecurityStatus.FAILURE));

    private final Set<SecurityResponse.SecurityStatus> supportedStates;

    private CompositeProviderFlag(Set<SecurityResponse.SecurityStatus> supportedStates) {
        this.supportedStates = supportedStates;
    }

    public boolean isValid(SecurityResponse.SecurityStatus status) {
        return this.supportedStates.contains((Object)status);
    }
}

