/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

public final class ClassToInstanceStore<T> {
    private final Map<Class<? extends T>, T> backingMap = new IdentityHashMap<Class<? extends T>, T>();

    @SafeVarargs
    public static <T> ClassToInstanceStore<T> create(T ... instances) {
        ClassToInstanceStore<T> result = new ClassToInstanceStore<T>();
        for (T instance : instances) {
            result.putInstance(instance);
        }
        return result;
    }

    public <U extends T> Optional<U> getInstance(Class<U> clazz) {
        return Optional.ofNullable(clazz.cast(this.backingMap.get(clazz)));
    }

    public <U extends T> Optional<U> putInstance(Class<? extends U> clazz, U instance) {
        return Optional.ofNullable(clazz.cast(this.backingMap.put(clazz, instance)));
    }

    public <U extends T> Optional<U> removeInstance(Class<U> clazz) {
        return Optional.ofNullable(clazz.cast(this.backingMap.remove(clazz)));
    }

    public void putAll(ClassToInstanceStore<? extends T> toCopy) {
        this.backingMap.putAll(toCopy.backingMap);
    }

    public boolean containsKey(Class<? extends T> clazz) {
        return this.backingMap.containsKey(clazz);
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    public <U extends T> Optional<U> putInstance(U instance) {
        return this.putInstance(instance.getClass(), instance);
    }

    public Collection<T> values() {
        return this.backingMap.values();
    }

    public Collection<Class<? extends T>> keys() {
        return this.backingMap.keySet();
    }

    public String toString() {
        return this.backingMap.toString();
    }
}

