/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.util.AbacSupport;
import java.security.Principal;
import java.util.Collection;
import java.util.Objects;

public class Grant
implements AbacSupport,
Principal {
    private final AbacSupport properties;
    private final String type;
    private final String name;
    private final String origin;

    protected Grant(Builder<?> builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.origin = builder.origin;
        AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create((AbacSupport)builder.properties);
        properties.put("type", (Object)this.type);
        properties.put("name", (Object)this.name);
        properties.put("origin", (Object)this.origin);
        this.properties = properties;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public Object abacAttributeRaw(String key) {
        return this.properties.abacAttributeRaw(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.properties.abacAttributeNames();
    }

    public String type() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.type + ":" + this.name;
    }

    public String origin() {
        return this.origin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Grant)) {
            return false;
        }
        Grant grant = (Grant)o;
        return this.type.equals(grant.type) && this.getName().equals(grant.getName()) && this.origin.equals(grant.origin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.getName(), this.origin);
    }

    public static class Builder<T extends Builder<T>>
    implements io.helidon.common.Builder<Grant> {
        private final T instance;
        private AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create();
        private String type;
        private String name;
        private String origin = "builder";

        protected Builder() {
            this.instance = this;
        }

        public Grant build() {
            return new Grant(this);
        }

        public T type(String type) {
            this.type = type;
            return this.instance;
        }

        public T name(String name) {
            this.name = name;
            return this.instance;
        }

        public T origin(String origin) {
            this.origin = origin;
            return this.instance;
        }

        public T attributes(AbacSupport attribs) {
            this.properties = AbacSupport.BasicAttributes.create((AbacSupport)attribs);
            return this.instance;
        }

        public T addAttribute(String key, Object value) {
            this.properties.put(key, value);
            return this.instance;
        }
    }
}

