/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.SecurityTime;
import io.helidon.security.util.AbacSupport;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class SecurityEnvironment
implements AbacSupport {
    private final AbacSupport properties;
    private final SecurityTime timeProvider;
    private final ZonedDateTime time;
    private final URI targetUri;
    private final String method;
    private final String transport;
    private final Optional<String> path;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

    private SecurityEnvironment(Builder builder) {
        AbacSupport.BasicAttributes basicAttributes = AbacSupport.BasicAttributes.create((AbacSupport)builder.attributes);
        this.timeProvider = builder.timeProvider;
        this.time = builder.time;
        this.targetUri = builder.targetUri;
        this.path = Optional.ofNullable(builder.path);
        this.method = builder.method;
        this.transport = builder.transport;
        this.headers.putAll(builder.headers);
        basicAttributes.put("time", (Object)this.time);
        basicAttributes.put("uri", (Object)this.targetUri);
        basicAttributes.put("path", this.path);
        basicAttributes.put("method", (Object)this.method);
        basicAttributes.put("transport", (Object)this.transport);
        basicAttributes.put("headers", this.headers);
        this.properties = basicAttributes;
    }

    public static Builder builder(SecurityTime serverTime) {
        return new Builder(serverTime);
    }

    public static Builder builder() {
        return new Builder(SecurityTime.create());
    }

    public static SecurityEnvironment create() {
        return SecurityEnvironment.builder().build();
    }

    public Object abacAttributeRaw(String key) {
        return this.properties.abacAttributeRaw(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.properties.abacAttributeNames();
    }

    public ZonedDateTime time() {
        return this.time;
    }

    public URI targetUri() {
        return this.targetUri;
    }

    public Optional<String> path() {
        return this.path;
    }

    public String method() {
        return this.method;
    }

    public String transport() {
        return this.transport;
    }

    public Builder derive() {
        return SecurityEnvironment.builder(this.timeProvider).attributes(this.properties).targetUri(this.targetUri).method(this.method).transport(this.transport).path(this.path.orElse(null)).headers(this.headers);
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final class Builder
    implements io.helidon.common.Builder<SecurityEnvironment> {
        public static final String DEFAULT_TRANSPORT = "http";
        public static final String DEFAULT_METHOD = "GET";
        private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        private SecurityTime timeProvider;
        private ZonedDateTime time;
        private AbacSupport.BasicAttributes attributes = AbacSupport.BasicAttributes.create();
        private URI targetUri;
        private String path;
        private String method = "GET";
        private String transport = "http";

        private Builder(SecurityTime timeProvider) {
            this.timeProvider = timeProvider;
        }

        public SecurityEnvironment build() {
            this.time = this.timeProvider.get();
            return new SecurityEnvironment(this);
        }

        private Builder attributes(AbacSupport props) {
            this.attributes = AbacSupport.BasicAttributes.create((AbacSupport)props);
            return this;
        }

        public Builder addAttribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder clearHeaders() {
            this.headers.clear();
            return this;
        }

        public Builder header(String header, String value) {
            this.headers.put(header, List.of(value));
            return this;
        }

        public Builder header(String header, List<String> values) {
            this.headers.put(header, values);
            return this;
        }

        public Builder targetUri(URI uri) {
            this.targetUri = uri;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder transport(String transport) {
            this.transport = transport;
            return this;
        }

        public Builder time(SecurityTime time) {
            this.timeProvider = time;
            return this;
        }
    }
}

