/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.Builder;
import io.helidon.security.EndpointConfig;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecurityLevel {
    private final String className;
    private final String methodName;
    private final Map<Class<? extends Annotation>, List<Annotation>> classLevelAnnotations;
    private final Map<Class<? extends Annotation>, List<Annotation>> methodLevelAnnotations;

    public static SecurityLevelBuilder create(String className) {
        Objects.requireNonNull(className);
        return new SecurityLevelBuilder(className);
    }

    public static SecurityLevelBuilder create(SecurityLevel copyFrom) {
        Objects.requireNonNull(copyFrom);
        return new SecurityLevelBuilder(copyFrom);
    }

    private SecurityLevel(SecurityLevelBuilder builder) {
        this.className = builder.className;
        this.methodName = builder.methodName;
        HashMap m = new HashMap();
        builder.classAnnotations.forEach((key, value) -> m.put(key, Collections.unmodifiableList(value)));
        this.classLevelAnnotations = Collections.unmodifiableMap(m);
        HashMap meth = new HashMap();
        builder.methodAnnotations.forEach((key, value) -> meth.put(key, Collections.unmodifiableList(value)));
        this.methodLevelAnnotations = Collections.unmodifiableMap(meth);
    }

    public <T extends Annotation> List<T> filterAnnotations(Class<T> annotationType, EndpointConfig.AnnotationScope scope) {
        switch (scope) {
            case CLASS: {
                return this.classLevelAnnotations.getOrDefault(annotationType, List.of());
            }
            case METHOD: {
                return this.methodLevelAnnotations.getOrDefault(annotationType, List.of());
            }
        }
        return List.of();
    }

    public <T extends Annotation> List<T> combineAnnotations(Class<T> annotationType, EndpointConfig.AnnotationScope ... scopes) {
        LinkedList<T> result = new LinkedList<T>();
        for (EndpointConfig.AnnotationScope scope : scopes) {
            result.addAll(this.filterAnnotations(annotationType, scope));
        }
        return result;
    }

    public Map<Class<? extends Annotation>, List<Annotation>> allAnnotations() {
        HashMap<Class<? extends Annotation>, List<Annotation>> result = new HashMap<Class<? extends Annotation>, List<Annotation>>(this.classLevelAnnotations);
        this.methodLevelAnnotations.forEach((key, value) -> {
            LinkedList anno = new LinkedList();
            if (result.containsKey(key)) {
                anno.addAll((Collection)result.get(key));
            }
            anno.addAll(value);
            result.put((Class<? extends Annotation>)key, anno);
        });
        return result;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Map<Class<? extends Annotation>, List<Annotation>> getClassLevelAnnotations() {
        return this.classLevelAnnotations;
    }

    public Map<Class<? extends Annotation>, List<Annotation>> getMethodLevelAnnotations() {
        return this.methodLevelAnnotations;
    }

    public String toString() {
        return this.className + (String)(this.methodName.isEmpty() ? this.methodName : "." + this.methodName);
    }

    public static class SecurityLevelBuilder
    implements Builder<SecurityLevel> {
        private String className;
        private String methodName;
        private Map<Class<? extends Annotation>, List<Annotation>> classAnnotations;
        private Map<Class<? extends Annotation>, List<Annotation>> methodAnnotations;
        private SecurityLevel copyFrom;

        private SecurityLevelBuilder(String className) {
            this.className = className;
        }

        private SecurityLevelBuilder(SecurityLevel copyFrom) {
            this.copyFrom = copyFrom;
        }

        public SecurityLevelBuilder withMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public SecurityLevelBuilder withClassAnnotations(Map<Class<? extends Annotation>, List<Annotation>> classAnnotations) {
            this.classAnnotations = classAnnotations;
            return this;
        }

        public SecurityLevelBuilder withMethodAnnotations(Map<Class<? extends Annotation>, List<Annotation>> methodAnnotations) {
            this.methodAnnotations = methodAnnotations;
            return this;
        }

        public SecurityLevel build() {
            String string = this.className = this.className == null ? this.copyFrom.getClassName() : this.className;
            String string2 = this.methodName == null ? (this.copyFrom == null ? "Unknown" : this.copyFrom.getMethodName()) : (this.methodName = this.methodName);
            Map<Object, Object> map = this.classAnnotations == null ? (this.copyFrom == null ? new HashMap() : this.copyFrom.getClassLevelAnnotations()) : (this.classAnnotations = this.classAnnotations);
            this.methodAnnotations = this.methodAnnotations == null ? (this.copyFrom == null ? new HashMap() : this.copyFrom.getMethodLevelAnnotations()) : this.methodAnnotations;
            return new SecurityLevel(this);
        }
    }
}

