/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.config.Config;
import io.helidon.security.CompositeAuthenticationProvider;
import io.helidon.security.CompositeAuthorizationProvider;
import io.helidon.security.CompositeOutboundProvider;
import io.helidon.security.CompositeProviderFlag;
import io.helidon.security.FirstProviderSelectionPolicy;
import io.helidon.security.NamedProvider;
import io.helidon.security.SecurityException;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.AuthorizationProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.ProviderSelectionPolicy;
import io.helidon.security.spi.SecurityProvider;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class CompositeProviderSelectionPolicy
implements ProviderSelectionPolicy {
    private final CompositeOutboundProvider outbound;
    private final CompositeAuthenticationProvider atn;
    private final CompositeAuthorizationProvider atz;
    private final Set<String> configuredOutbound = new HashSet<String>();
    private final List<NamedProvider<OutboundSecurityProvider>> allOutbound = new LinkedList<NamedProvider<OutboundSecurityProvider>>();
    private final boolean isDefault;
    private final String name;
    private final FirstProviderSelectionPolicy fallback;

    private CompositeProviderSelectionPolicy(ProviderSelectionPolicy.Providers providers, Builder builder) {
        LinkedList<CompositeAuthenticationProvider.Atn> parts;
        this.fallback = new FirstProviderSelectionPolicy(providers);
        this.isDefault = builder.isDefault;
        this.name = builder.name;
        if (!builder.authenticators.isEmpty()) {
            parts = new LinkedList<CompositeAuthenticationProvider.Atn>();
            builder.authenticators.forEach(flaggedProvider -> parts.add(new CompositeAuthenticationProvider.Atn((FlaggedProvider)flaggedProvider, providers.getProviders(AuthenticationProvider.class).stream().filter(np -> np.getName().equals(flaggedProvider.providerName())).findFirst().map(NamedProvider::getProvider).orElseThrow(() -> new SecurityException("Misconfigured composite provider selection policy. There is no authentication provider named " + flaggedProvider.providerName() + " configured.")))));
            this.atn = new CompositeAuthenticationProvider(parts);
        } else {
            this.atn = null;
        }
        if (!builder.authorizers.isEmpty()) {
            parts = new LinkedList();
            builder.authorizers.forEach(flaggedProvider -> parts.add((CompositeAuthenticationProvider.Atn)((Object)new CompositeAuthorizationProvider.Atz((FlaggedProvider)flaggedProvider, providers.getProviders(AuthorizationProvider.class).stream().filter(np -> np.getName().equals(flaggedProvider.providerName())).findFirst().map(NamedProvider::getProvider).orElseThrow(() -> new SecurityException("Misconfigured composite provider selection policy. There is no authorization provider named " + flaggedProvider.providerName() + " configured."))))));
            this.atz = new CompositeAuthorizationProvider(parts);
        } else {
            this.atz = null;
        }
        this.allOutbound.addAll(providers.getProviders(OutboundSecurityProvider.class));
        if (!builder.outbound.isEmpty()) {
            parts = new LinkedList();
            this.configuredOutbound.addAll(builder.outbound);
            builder.outbound.forEach(name -> parts.add((CompositeAuthenticationProvider.Atn)((Object)providers.getProviders(OutboundSecurityProvider.class).stream().filter(np -> np.getName().equals(name)).findFirst().map(NamedProvider::getProvider).orElseThrow(() -> new SecurityException("Misconfigured composite provider selection policy. There is no outbound security provider provider named " + name + " configured.")))));
            this.outbound = new CompositeOutboundProvider(parts);
        } else {
            this.outbound = null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Function<ProviderSelectionPolicy.Providers, ProviderSelectionPolicy> create(Config config) {
        return CompositeProviderSelectionPolicy.builder().config(config).build();
    }

    @Override
    public <T extends SecurityProvider> Optional<T> selectProvider(Class<T> providerType) {
        if (this.isDefault) {
            if (null != this.atn && providerType.equals(AuthenticationProvider.class)) {
                return Optional.of((SecurityProvider)providerType.cast(this.atn));
            }
            if (null != this.atz && providerType.equals(AuthorizationProvider.class)) {
                return Optional.of((SecurityProvider)providerType.cast(this.atz));
            }
        }
        return this.fallback.selectProvider(providerType);
    }

    @Override
    public List<OutboundSecurityProvider> selectOutboundProviders() {
        LinkedList<OutboundSecurityProvider> result = new LinkedList<OutboundSecurityProvider>();
        this.allOutbound.stream().filter(np -> !this.configuredOutbound.contains(np.getName())).forEach(np -> result.add((OutboundSecurityProvider)np.getProvider()));
        if (null != this.outbound) {
            if (this.isDefault) {
                result.addFirst(this.outbound);
            } else {
                result.addLast(this.outbound);
            }
        }
        return result;
    }

    @Override
    public <T extends SecurityProvider> Optional<T> selectProvider(Class<T> providerType, String requestedName) {
        if (this.name.equals(requestedName)) {
            if (null != this.atn && providerType.equals(AuthenticationProvider.class)) {
                return Optional.of((SecurityProvider)providerType.cast(this.atn));
            }
            if (null != this.atz && providerType.equals(AuthorizationProvider.class)) {
                return Optional.of((SecurityProvider)providerType.cast(this.atz));
            }
            if (null != this.outbound && providerType.equals(OutboundSecurityProvider.class)) {
                return Optional.of((SecurityProvider)providerType.cast(this.outbound));
            }
        }
        return this.fallback.selectProvider(providerType, requestedName);
    }

    static class FlaggedProvider {
        private final CompositeProviderFlag flag;
        private final String providerName;

        FlaggedProvider(CompositeProviderFlag flag, String providerName) {
            this.flag = flag;
            this.providerName = providerName;
        }

        static FlaggedProvider create(Config config) {
            String name = (String)config.get("name").asString().get();
            CompositeProviderFlag flag = (CompositeProviderFlag)((Object)config.get("flag").asString().as(CompositeProviderFlag::valueOf).orElse((Object)CompositeProviderFlag.REQUIRED));
            return new FlaggedProvider(flag, name);
        }

        String providerName() {
            return this.providerName;
        }

        CompositeProviderFlag flag() {
            return this.flag;
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<Function<ProviderSelectionPolicy.Providers, ProviderSelectionPolicy>> {
        private final List<FlaggedProvider> authenticators = new LinkedList<FlaggedProvider>();
        private final List<FlaggedProvider> authorizers = new LinkedList<FlaggedProvider>();
        private final List<String> outbound = new LinkedList<String>();
        private String name = "composite";
        private boolean isDefault = true;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder addAuthenticationProvider(String namedProvider) {
            this.authenticators.add(new FlaggedProvider(CompositeProviderFlag.REQUIRED, namedProvider));
            return this;
        }

        public Builder addAuthenticationProvider(String namedProvider, CompositeProviderFlag flag) {
            this.authenticators.add(new FlaggedProvider(flag, namedProvider));
            return this;
        }

        public Builder addAuthorizationProvider(String namedProvider) {
            this.authorizers.add(new FlaggedProvider(CompositeProviderFlag.REQUIRED, namedProvider));
            return this;
        }

        public Builder addAuthorizationProvider(String namedProvider, CompositeProviderFlag flag) {
            this.authorizers.add(new FlaggedProvider(flag, namedProvider));
            return this;
        }

        public Builder addOutboundProvider(String namedProvider) {
            this.outbound.add(namedProvider);
            return this;
        }

        public Builder config(Config config) {
            config.get("name").asString().ifPresent(this::name);
            config.get("default").asBoolean().ifPresent(this::isDefault);
            config.get("authentication").asList(FlaggedProvider::create).ifPresent(this.authenticators::addAll);
            config.get("authorization").asList(FlaggedProvider::create).ifPresent(this.authorizers::addAll);
            config.get("outbound").asNodeList().ifPresent(configs -> configs.forEach(outConfig -> this.addOutboundProvider((String)outConfig.get("name").asString().get())));
            return this;
        }

        public Function<ProviderSelectionPolicy.Providers, ProviderSelectionPolicy> build() {
            return providers -> new CompositeProviderSelectionPolicy((ProviderSelectionPolicy.Providers)providers, this);
        }
    }
}

