/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import io.helidon.security.AuditEvent;
import io.helidon.security.spi.AuditProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DefaultAuditProvider
implements AuditProvider {
    private final Logger auditLogger;
    private final Level failureLevel;
    private final Level successLevel;
    private final Level infoLevel;
    private final Level warnLevel;
    private final Level errorLevel;
    private final Level auditFailureLevel;

    private DefaultAuditProvider(Config config) {
        this.auditLogger = Logger.getLogger((String)DeprecatedConfig.get((Config)config, (String)"audit.defaultProvider.logger", (String)"security.audit.defaultProvider.logger").asString().orElse((Object)"AUDIT"));
        this.failureLevel = this.level(config, "failure", Level.FINEST);
        this.successLevel = this.level(config, "success", Level.FINEST);
        this.infoLevel = this.level(config, "info", Level.FINEST);
        this.warnLevel = this.level(config, "warn", Level.WARNING);
        this.errorLevel = this.level(config, "error", Level.SEVERE);
        this.auditFailureLevel = this.level(config, "audit-failure", Level.SEVERE);
    }

    private Level level(Config config, String auditSeverity, Level defaultLevel) {
        return config.get("audit.defaultProvider.level." + auditSeverity).asString().map(Level::parse).orElse(defaultLevel);
    }

    static DefaultAuditProvider create(Config config) {
        return new DefaultAuditProvider(config);
    }

    @Override
    public Consumer<AuditProvider.TracedAuditEvent> auditConsumer() {
        return this::audit;
    }

    private void audit(AuditProvider.TracedAuditEvent event) {
        Level level;
        switch (event.severity()) {
            case FAILURE: {
                level = this.failureLevel;
                break;
            }
            case SUCCESS: {
                level = this.successLevel;
                break;
            }
            case INFO: {
                level = this.infoLevel;
                break;
            }
            case WARN: {
                level = this.warnLevel;
                break;
            }
            case ERROR: {
                level = this.errorLevel;
                break;
            }
            default: {
                level = this.auditFailureLevel;
            }
        }
        this.logEvent(event, level);
    }

    private void logEvent(AuditProvider.TracedAuditEvent event, Level level) {
        if (!this.auditLogger.isLoggable(level)) {
            return;
        }
        AuditProvider.AuditSource auditSource = event.auditSource();
        StringBuilder locationInfo = new StringBuilder();
        locationInfo.append(auditSource.className().orElse("UnknownClass")).append(" ").append(auditSource.methodName().orElse("UnknownMethod")).append(" ").append(auditSource.fileName().orElse("UnknownFile")).append(" ").append(auditSource.lineNumber().orElse(-1));
        Object msg = event.severity() + " " + event.eventType() + " " + event.tracingId() + " " + event.getClass().getSimpleName() + " " + locationInfo + " :: \"" + this.formatMessage(event) + "\"";
        Object finalMsg = msg = ((String)msg).replace('\n', ' ');
        event.throwable().ifPresentOrElse(arg_0 -> this.lambda$logEvent$0(level, (String)finalMsg, arg_0), () -> this.lambda$logEvent$1(level, (String)finalMsg));
    }

    String formatMessage(AuditEvent event) {
        try {
            return String.format(event.messageFormat(), this.toObjectParams(event.params()));
        }
        catch (Exception e) {
            return "Formatting failed for format: " + event.messageFormat() + ", parameters: " + event.params();
        }
    }

    private Object[] toObjectParams(List<AuditEvent.AuditParam> parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (AuditEvent.AuditParam param : parameters) {
            if (param.isSensitive()) {
                result.add("(sensitive)");
                continue;
            }
            result.add(param.value().orElse("null"));
        }
        return result.toArray(new Object[0]);
    }

    private /* synthetic */ void lambda$logEvent$1(Level level, String finalMsg) {
        this.auditLogger.log(level, finalMsg);
    }

    private /* synthetic */ void lambda$logEvent$0(Level level, String finalMsg, Throwable throwable) {
        this.auditLogger.log(level, finalMsg, throwable);
    }
}

