/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.config.Config;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class SecurityTime {
    private final long shiftSeconds;
    private final ZoneId timeZone;
    private final List<ChronoValues> chronoValues = new ArrayList<ChronoValues>();

    private SecurityTime(Builder builder) {
        this.shiftSeconds = builder.shiftBySeconds;
        this.timeZone = builder.timeZone;
        this.chronoValues.addAll(builder.values);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SecurityTime create() {
        return SecurityTime.builder().build();
    }

    public static SecurityTime create(Config config) {
        return SecurityTime.builder().config(config).build();
    }

    public ZonedDateTime get() {
        ZonedDateTime zdt = ZonedDateTime.now();
        zdt = zdt.withZoneSameInstant(this.timeZone);
        zdt = zdt.plus(this.shiftSeconds, ChronoUnit.SECONDS);
        for (ChronoValues chronoValues : this.chronoValues) {
            zdt = zdt.with(chronoValues.field, chronoValues.value);
        }
        return zdt;
    }

    private static final class ChronoValues {
        private final ChronoField field;
        private final long value;

        private ChronoValues(ChronoField field, long delta) {
            this.field = field;
            this.value = delta;
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<SecurityTime> {
        private final List<ChronoValues> values = new ArrayList<ChronoValues>();
        private ZoneId timeZone = ZoneId.systemDefault();
        private long shiftBySeconds = 0L;

        private Builder() {
        }

        public SecurityTime build() {
            return new SecurityTime(this);
        }

        public Builder timeZone(ZoneId zoneId) {
            this.timeZone = zoneId;
            return this;
        }

        public Builder shiftBySeconds(long seconds) {
            this.shiftBySeconds = seconds;
            return this;
        }

        public Builder value(ChronoField field, long value) {
            this.values.add(new ChronoValues(field, value));
            return this;
        }

        public Builder config(Config config) {
            config.get("time-zone").asString().map(ZoneId::of).ifPresent(this::timeZone);
            config.get("shift-by-seconds").asLong().ifPresent(this::shiftBySeconds);
            config.get("year").asLong().ifPresent(it -> this.value(ChronoField.YEAR, (long)it));
            config.get("month").asLong().ifPresent(it -> this.value(ChronoField.MONTH_OF_YEAR, (long)it));
            config.get("day-of-month").asLong().ifPresent(it -> this.value(ChronoField.DAY_OF_MONTH, (long)it));
            config.get("hour-of-day").asLong().ifPresent(it -> this.value(ChronoField.HOUR_OF_DAY, (long)it));
            config.get("minute").asLong().ifPresent(it -> this.value(ChronoField.MINUTE_OF_HOUR, (long)it));
            config.get("second").asLong().ifPresent(it -> this.value(ChronoField.SECOND_OF_MINUTE, (long)it));
            config.get("millisecond").asLong().ifPresent(it -> this.value(ChronoField.MILLI_OF_SECOND, (long)it));
            return this;
        }
    }
}

