/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.HelidonPrincipal;
import io.helidon.security.util.AbacSupport;

public interface Principal
extends AbacSupport,
java.security.Principal {
    public String id();

    public static Builder builder() {
        return new Builder();
    }

    public static Principal create(String id) {
        return Principal.builder().id(id).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<Principal> {
        private String name;
        private String id;
        private AbacSupport.BasicAttributes properties = AbacSupport.BasicAttributes.create();

        private Builder() {
        }

        String name() {
            return this.name;
        }

        String id() {
            return this.id;
        }

        AbacSupport.BasicAttributes properties() {
            return this.properties;
        }

        public Principal build() {
            return new HelidonPrincipal(this);
        }

        public Builder name(String name) {
            this.name = name;
            if (null == this.id) {
                this.id = name;
            }
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            if (null == this.name) {
                this.name = id;
            }
            return this;
        }

        private Builder attributes(AbacSupport attributes) {
            this.properties = AbacSupport.BasicAttributes.create((AbacSupport)attributes);
            return this;
        }

        public Builder addAttribute(String key, Object value) {
            if (null == value) {
                return this;
            }
            this.properties.put(key, value);
            return this;
        }
    }
}

