/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.internal;

import io.helidon.security.AuditEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class SecurityAuditEvent
implements AuditEvent {
    private final AuditEvent.AuditSeverity severity;
    private final String eventType;
    private final String messageFormat;
    private final Optional<Throwable> throwable;
    private final List<AuditEvent.AuditParam> auditParameters = new ArrayList<AuditEvent.AuditParam>();

    private SecurityAuditEvent(AuditEvent.AuditSeverity severity, String eventType, String messageFormat, Throwable throwable) {
        this.severity = severity;
        this.eventType = eventType;
        this.messageFormat = messageFormat;
        this.throwable = Optional.ofNullable(throwable);
    }

    public static SecurityAuditEvent info(String eventType, String messageFormat) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.INFO, eventType, messageFormat, null);
    }

    public static SecurityAuditEvent success(String eventType, String messageFormat) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.SUCCESS, eventType, messageFormat, null);
    }

    public static SecurityAuditEvent warn(String eventType, String messageFormat) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.WARN, eventType, messageFormat, null);
    }

    public static SecurityAuditEvent warn(String eventType, String messageFormat, Throwable e) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.WARN, eventType, messageFormat, e);
    }

    public static SecurityAuditEvent error(String eventType, String messageFormat) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.ERROR, eventType, messageFormat, null);
    }

    public static SecurityAuditEvent error(String eventType, String messageFormat, Throwable e) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.ERROR, eventType, messageFormat, e);
    }

    public static SecurityAuditEvent failure(String eventType, String messageFormat) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.FAILURE, eventType, messageFormat, null);
    }

    public static SecurityAuditEvent failure(String eventType, String messageFormat, Throwable e) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.FAILURE, eventType, messageFormat, e);
    }

    public static SecurityAuditEvent auditFailure(String eventType, String messageFormat) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.AUDIT_FAILURE, eventType, messageFormat, null);
    }

    public static SecurityAuditEvent auditFailure(String eventType, String messageFormat, Throwable e) {
        return new SecurityAuditEvent(AuditEvent.AuditSeverity.AUDIT_FAILURE, eventType, messageFormat, e);
    }

    public static SecurityAuditEvent audit(AuditEvent.AuditSeverity severity, String eventType, String messageFormat) {
        return new SecurityAuditEvent(severity, eventType, messageFormat, null);
    }

    public SecurityAuditEvent addParam(AuditEvent.AuditParam param) {
        this.auditParameters.add(param);
        return this;
    }

    @Override
    public String eventType() {
        return this.eventType;
    }

    @Override
    public Optional<Throwable> throwable() {
        return this.throwable;
    }

    @Override
    public List<AuditEvent.AuditParam> params() {
        return Collections.unmodifiableList(this.auditParameters);
    }

    @Override
    public String messageFormat() {
        return this.messageFormat;
    }

    @Override
    public AuditEvent.AuditSeverity severity() {
        return this.severity;
    }

    public String toString() {
        return "AuditEvent{severity=" + (Object)((Object)this.severity) + ", eventType='" + this.eventType + '\'' + ", messageFormat='" + this.messageFormat + '\'' + ", throwable=" + this.throwable + ", auditParameters=" + this.toString(this.auditParameters) + '}';
    }

    private String toString(List<AuditEvent.AuditParam> auditParameters) {
        StringBuilder response = new StringBuilder();
        for (AuditEvent.AuditParam param : auditParameters) {
            if (param.isSensitive()) {
                response.append(param.name()).append("=").append("********");
            } else {
                response.append(param.name()).append("=").append(param.value().orElse("null"));
            }
            response.append(",");
        }
        if (response.length() != 0) {
            return response.substring(0, response.length() - 1);
        }
        return response.toString();
    }
}

