/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.OptionalHelper;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Entity;
import io.helidon.security.ReflectionUtil;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityException;
import io.helidon.security.Subject;
import io.helidon.security.util.AbacSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ProviderRequest
implements AbacSupport {
    private static final Logger LOGGER = Logger.getLogger(ProviderRequest.class.getName());
    private final Map<String, AbacSupport> contextRoot = new HashMap<String, AbacSupport>();
    private final Optional<Subject> subject;
    private final Optional<Subject> service;
    private final SecurityEnvironment env;
    private final Optional<ObjectWrapper> resource;
    private final SecurityContext context;
    private final EndpointConfig epConfig;
    private final Optional<Entity> requestEntity;
    private final Optional<Entity> responseEntity;

    ProviderRequest(SecurityContext context, Map<String, Supplier<Object>> resources, Optional<Entity> requestEntity, Optional<Entity> responseEntity) {
        this.requestEntity = requestEntity;
        this.responseEntity = responseEntity;
        ObjectWrapper object = null;
        for (Map.Entry<String, Supplier<Object>> entry : resources.entrySet()) {
            ObjectWrapper wrapper = new ObjectWrapper(entry.getValue());
            this.contextRoot.put(entry.getKey(), wrapper);
            if (!"object".equals(entry.getKey())) continue;
            object = wrapper;
        }
        this.env = context.env();
        this.epConfig = context.endpointConfig();
        this.context = context;
        this.resource = Optional.ofNullable(object);
        this.subject = context.user();
        this.service = context.service();
        this.contextRoot.put("env", this.env);
        this.subject.ifPresent(user -> this.contextRoot.put("subject", (AbacSupport)user));
        this.service.ifPresent(svc -> this.contextRoot.put("service", (AbacSupport)svc));
    }

    public static Optional<Object> getValue(Object object, String key) {
        Class<?> aClass = object.getClass();
        try {
            Field field = aClass.getField(key);
            if (ReflectionUtil.canAccess(ProviderRequest.class, field)) {
                return Optional.ofNullable(field.get(object));
            }
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.FINEST, e, () -> "Field \"" + key + "\" + is not present in class: " + aClass.getName());
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.FINEST, e, () -> "Failed to access field: \"" + key + "\" in class: " + aClass.getName());
        }
        String capName = ProviderRequest.capitalize(key);
        return OptionalHelper.from(ProviderRequest.getMethod(aClass, "get" + capName)).or(() -> ProviderRequest.getMethod(aClass, key)).or(() -> ProviderRequest.getMethod(aClass, "is" + capName)).or(() -> ProviderRequest.getMethod(aClass, "has" + capName)).or(() -> ProviderRequest.getMethod(aClass, "should" + capName)).asOptional().map(method -> {
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new SecurityException("Failed to invoke method \"" + method + "\" on class \"" + aClass.getName() + "\"", e);
            }
        });
    }

    static String capitalize(String string) {
        char c = string.charAt(0);
        char upperCase = Character.toUpperCase(c);
        return String.valueOf(upperCase) + string.substring(1);
    }

    static Optional<Method> getMethod(Class<?> aClass, String methodName) {
        try {
            Method method = aClass.getMethod(methodName, new Class[0]);
            if (ReflectionUtil.canAccess(ProviderRequest.class, method)) {
                return Optional.of(method);
            }
            return Optional.empty();
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.FINEST, e, () -> "Method: \"" + methodName + "\" is not in class: " + aClass.getName());
            return Optional.empty();
        }
    }

    public EndpointConfig endpointConfig() {
        return this.epConfig;
    }

    public SecurityContext securityContext() {
        return this.context;
    }

    public Optional<Subject> subject() {
        return this.subject;
    }

    public Optional<Subject> service() {
        return this.service;
    }

    public SecurityEnvironment env() {
        return this.env;
    }

    public Optional<Object> getObject() {
        return this.resource.map(ObjectWrapper::getValue);
    }

    @Deprecated
    public Optional<Entity> requestEntity() {
        return this.requestEntity;
    }

    @Deprecated
    public Optional<Entity> responseEntity() {
        return this.responseEntity;
    }

    public Object abacAttributeRaw(String key) {
        return this.contextRoot.get(key);
    }

    public Collection<String> abacAttributeNames() {
        return this.contextRoot.keySet();
    }

    private static final class ObjectWrapper
    implements AbacSupport {
        private final Supplier<Object> valueSupplier;
        private volatile Object value;
        private volatile AbacSupport container;

        private ObjectWrapper(Supplier<Object> value) {
            this.valueSupplier = value;
        }

        public Object abacAttributeRaw(String key) {
            this.checkValue();
            if (null != this.container) {
                return this.container.abacAttributeRaw(key);
            }
            return ProviderRequest.getValue(this.value, key);
        }

        public Collection<String> abacAttributeNames() {
            this.checkValue();
            if (null != this.container) {
                return this.container.abacAttributeNames();
            }
            throw new UnsupportedOperationException("Property names are not available for general Object types, such as: " + this.value.getClass());
        }

        Object getValue() {
            this.checkValue();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkValue() {
            if (null == this.value) {
                Supplier<Object> supplier = this.valueSupplier;
                synchronized (supplier) {
                    if (null == this.value) {
                        this.value = this.valueSupplier.get();
                        if (this.value instanceof AbacSupport) {
                            this.container = (AbacSupport)this.value;
                        } else if (this.value instanceof Map) {
                            final Map map = (Map)this.value;
                            this.container = new AbacSupport(){

                                public Object abacAttributeRaw(String key) {
                                    return map.get(key);
                                }

                                public Collection<String> abacAttributeNames() {
                                    return map.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
                                }
                            };
                        }
                    }
                }
            }
        }
    }
}

