/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuthorizationResponse;
import io.helidon.security.CompositeProviderFlag;
import io.helidon.security.CompositeProviderSelectionPolicy;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityResponse;
import io.helidon.security.spi.AuthorizationProvider;
import io.helidon.security.spi.ProviderConfig;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class CompositeAuthorizationProvider
implements AuthorizationProvider {
    private final List<Atz> providers = new LinkedList<Atz>();

    CompositeAuthorizationProvider(List<Atz> parts) {
        this.providers.addAll(parts);
    }

    @Override
    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        this.providers.forEach(atzConfig -> result.addAll(((Atz)atzConfig).provider.supportedAnnotations()));
        return result;
    }

    @Override
    public Collection<String> supportedConfigKeys() {
        HashSet<String> configKeys = new HashSet<String>();
        this.providers.forEach(atzConfig -> configKeys.addAll(((Atz)atzConfig).provider.supportedConfigKeys()));
        return configKeys;
    }

    @Override
    public Collection<Class<? extends ProviderConfig>> supportedCustomObjects() {
        HashSet<Class<? extends ProviderConfig>> result = new HashSet<Class<? extends ProviderConfig>>();
        this.providers.forEach(atzConfig -> result.addAll(((Atz)atzConfig).provider.supportedCustomObjects()));
        return result;
    }

    @Override
    public Collection<String> supportedAttributes() {
        HashSet<String> result = new HashSet<String>();
        this.providers.forEach(atzConfig -> result.addAll(((Atz)atzConfig).provider.supportedAttributes()));
        return result;
    }

    @Override
    public CompletionStage<AuthorizationResponse> authorize(ProviderRequest context) {
        CompletionStage<AuthorizationResponse> previous = CompletableFuture.completedFuture(AuthorizationResponse.abstain());
        for (Atz providerConfig : this.providers) {
            previous = previous.thenCombine(providerConfig.provider.authorize(context), (prevResponse, thisResponse) -> this.processProvider(providerConfig, (AuthorizationResponse)prevResponse, (AuthorizationResponse)thisResponse));
        }
        return previous.exceptionally(throwable -> {
            Throwable cause = throwable.getCause();
            if (null == cause) {
                cause = throwable;
            }
            if (cause instanceof AsyncAtzException) {
                return ((AsyncAtzException)cause).response;
            }
            return ((AuthorizationResponse.Builder)((AuthorizationResponse.Builder)((AuthorizationResponse.Builder)AuthorizationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).description("Failed processing: " + throwable.getMessage())).throwable((Throwable)throwable)).build();
        }).thenApply(atzResponse -> {
            if (atzResponse.status() == SecurityResponse.SecurityStatus.ABSTAIN) {
                return AuthorizationResponse.abstain();
            }
            return atzResponse;
        });
    }

    private AuthorizationResponse processProvider(Atz providerConfig, AuthorizationResponse prevResponse, AuthorizationResponse thisResponse) {
        CompositeProviderFlag flag = providerConfig.config.flag();
        if (!flag.isValid(thisResponse.status())) {
            switch (thisResponse.status()) {
                case SUCCESS: 
                case SUCCESS_FINISH: 
                case ABSTAIN: {
                    AuthorizationResponse.Builder builder = AuthorizationResponse.builder();
                    builder.status(SecurityResponse.SecurityStatus.FAILURE);
                    builder.description("Composite flag forbids this response: " + (Object)((Object)thisResponse.status()));
                    thisResponse.description().map(builder::description);
                    thisResponse.throwable().map(builder::throwable);
                    throw new AsyncAtzException(builder.build());
                }
            }
            throw new AsyncAtzException(thisResponse);
        }
        if (flag == CompositeProviderFlag.SUFFICIENT && thisResponse.status() == SecurityResponse.SecurityStatus.SUCCESS) {
            throw new AsyncAtzException(thisResponse);
        }
        if (prevResponse.status() == SecurityResponse.SecurityStatus.ABSTAIN) {
            return thisResponse.status().isSuccess() ? thisResponse : prevResponse;
        }
        if (!thisResponse.status().isSuccess()) {
            return prevResponse;
        }
        return thisResponse;
    }

    static class Atz {
        private final CompositeProviderSelectionPolicy.FlaggedProvider config;
        private final AuthorizationProvider provider;

        Atz(CompositeProviderSelectionPolicy.FlaggedProvider config, AuthorizationProvider provider) {
            this.config = config;
            this.provider = provider;
        }
    }

    private static final class AsyncAtzException
    extends RuntimeException {
        private AuthorizationResponse response;

        private AsyncAtzException(AuthorizationResponse response) {
            this.response = response;
        }
    }
}

