/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public interface AbacSupport {
    public Object abacAttributeRaw(String var1);

    public Collection<String> abacAttributeNames();

    default public Optional<Object> abacAttribute(String key) {
        return Optional.ofNullable(this.abacAttributeRaw(key));
    }

    public static class BasicAttributes
    implements AbacSupport {
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Map<String, Object> registry = new LinkedHashMap<String, Object>();

        private BasicAttributes() {
        }

        public static BasicAttributes create() {
            return new BasicAttributes();
        }

        public static BasicAttributes create(AbacSupport toCopy) {
            BasicAttributes ba = new BasicAttributes();
            toCopy.abacAttributeNames().forEach(key -> ba.registry.put((String)key, toCopy.abacAttributeRaw((String)key)));
            return ba;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String classifier, Object value) {
            Lock lock = this.rwLock.writeLock();
            lock.lock();
            try {
                this.registry.put(classifier, value);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public Collection<String> abacAttributeNames() {
            Lock lock = this.rwLock.readLock();
            lock.lock();
            try {
                Set<String> set = this.registry.keySet();
                return set;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object abacAttributeRaw(String key) {
            Lock lock = this.rwLock.readLock();
            lock.lock();
            try {
                Object object = this.registry.get(key);
                return object;
            }
            finally {
                lock.unlock();
            }
        }

        public String toString() {
            return "BasicAttributes{registry=" + String.valueOf(this.registry) + "}";
        }
    }
}

