/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.util;

import io.helidon.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TokenHandler {
    private final String tokenHeader;
    private final Function<String, String> headerExtractor;
    private final Function<String, String> headerCreator;

    private TokenHandler(Builder builder) {
        this.tokenHeader = builder.tokenHeader;
        if (null != builder.tokenPattern) {
            Pattern tokenPattern = builder.tokenPattern;
            this.headerExtractor = s -> {
                Matcher m = tokenPattern.matcher((CharSequence)s);
                if (m.matches()) {
                    return m.group(1);
                }
                throw new SecurityException("Header does not match expected pattern: " + s);
            };
        } else if (null != builder.tokenPrefix) {
            int len = builder.tokenPrefix.length();
            String lcPrefix = builder.tokenPrefix.toLowerCase();
            this.headerExtractor = s -> {
                if (s.toLowerCase().startsWith(lcPrefix)) {
                    return s.substring(len);
                }
                throw new SecurityException("Header does not start with expected prefix " + lcPrefix + ", it is: " + s);
            };
        } else {
            this.headerExtractor = s -> s;
        }
        if (null != builder.tokenFormat) {
            String format = builder.tokenFormat;
            this.headerCreator = s -> String.format(format, s);
        } else if (null != builder.tokenPrefix) {
            String prefix = builder.tokenPrefix;
            this.headerCreator = s -> prefix + s;
        } else {
            this.headerCreator = s -> s;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TokenHandler forHeader(String header) {
        return TokenHandler.builder().tokenHeader(header).build();
    }

    public static TokenHandler fromConfig(Config config) {
        return TokenHandler.builder().fromConfig(config).build();
    }

    public Optional<String> extractToken(Map<String, List<String>> headers) {
        List tokenHeaders = headers.getOrDefault(this.tokenHeader, Collections.emptyList());
        if (tokenHeaders.isEmpty()) {
            return Optional.empty();
        }
        String tokenHeader = (String)tokenHeaders.get(0);
        return Optional.of(this.headerExtractor.apply(tokenHeader));
    }

    public String extractToken(String tokenRawValue) {
        return this.headerExtractor.apply(tokenRawValue);
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public void setHeader(Map<String, List<String>> headers, String token) {
        headers.put(this.tokenHeader, Collections.singletonList(this.headerCreator.apply(token)));
    }

    public void addHeader(Map<String, List<String>> headers, String token) {
        String tokenValue = this.headerCreator.apply(token);
        List<String> values = headers.get(this.tokenHeader);
        if (null == values) {
            values = Collections.singletonList(tokenValue);
        } else {
            values = new ArrayList<String>(values);
            values.add(tokenValue);
        }
        headers.put(this.tokenHeader, values);
    }

    public static class Builder
    implements io.helidon.common.Builder<TokenHandler> {
        private String tokenHeader;
        private String tokenPrefix;
        private Pattern tokenPattern;
        private String tokenFormat;

        public Builder tokenHeader(String header) {
            Objects.requireNonNull(header);
            this.tokenHeader = header;
            return this;
        }

        public Builder tokenPrefix(String prefix) {
            Objects.requireNonNull(prefix);
            this.tokenPrefix = prefix;
            return this;
        }

        public Builder tokenPattern(Pattern pattern) {
            Objects.requireNonNull(pattern);
            this.tokenPrefix = null;
            this.tokenPattern = pattern;
            return this;
        }

        public TokenHandler build() {
            Objects.requireNonNull(this.tokenHeader, "Token header must be configured");
            return new TokenHandler(this);
        }

        public Builder fromConfig(Config config) {
            config.get("header").value().ifPresent(this::tokenHeader);
            config.get("prefix").value().ifPresent(this::tokenPrefix);
            config.get("regexp").asOptional(Pattern.class).ifPresent(this::tokenPattern);
            config.get("format").value().ifPresent(this::tokenFormat);
            return this;
        }

        public Builder tokenFormat(String format) {
            this.tokenFormat = format;
            return this;
        }
    }
}

