/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public interface AbacSupport {
    public Object getAttributeRaw(String var1);

    public Collection<String> getAttributeNames();

    default public Optional<Object> getAttribute(String key) {
        return Optional.ofNullable(this.getAttributeRaw(key));
    }

    public static class BasicAttributes
    implements AbacSupport {
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Map<String, Object> registry = new LinkedHashMap<String, Object>();

        public BasicAttributes() {
        }

        public BasicAttributes(AbacSupport toCopy) {
            toCopy.getAttributeNames().forEach(key -> this.registry.put((String)key, toCopy.getAttributeRaw((String)key)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String classifier, Object value) {
            Lock lock = this.rwLock.writeLock();
            lock.lock();
            try {
                this.registry.put(classifier, value);
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public Collection<String> getAttributeNames() {
            Lock lock = this.rwLock.readLock();
            lock.lock();
            try {
                Set<String> set = this.registry.keySet();
                return set;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getAttributeRaw(String key) {
            Lock lock = this.rwLock.readLock();
            lock.lock();
            try {
                Object object = this.registry.get(key);
                return object;
            }
            finally {
                lock.unlock();
            }
        }

        public String toString() {
            return "BasicAttributes{registry=" + this.registry + '}';
        }
    }
}

