/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.OptionalValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class AudienceValidator
extends OptionalValidator {
    private final Set<String> expectedAudience;

    private AudienceValidator(Builder builder) {
        super(builder);
        this.expectedAudience = Set.copyOf(builder.expectedAudience);
    }

    public static Builder builder() {
        return (Builder)((Builder)new Builder().addClaim("aud")).mandatory(true);
    }

    @Override
    public void validate(Jwt jwt, Errors.Collector collector, List<ClaimValidator> validators) {
        Optional<List<String>> jwtAudiences = jwt.audience();
        jwtAudiences.ifPresent(jwtAudience -> {
            if (this.expectedAudience.stream().anyMatch(((List)jwtAudiences.get())::contains)) {
                return;
            }
            collector.fatal((Object)jwt, "Audience must contain " + String.valueOf(this.expectedAudience) + ", yet it is: " + String.valueOf(jwtAudiences));
        });
        super.validate("aud", jwtAudiences, collector);
    }

    public static final class Builder
    extends OptionalValidator.BaseBuilder<Builder, AudienceValidator> {
        private Set<String> expectedAudience = new HashSet<String>();

        private Builder() {
        }

        public AudienceValidator build() {
            return new AudienceValidator(this);
        }

        public Builder addExpectedAudience(String audience) {
            Objects.requireNonNull(audience);
            this.expectedAudience.add(audience);
            return this;
        }

        public Builder expectedAudience(Set<String> expectedAudience) {
            Objects.requireNonNull(expectedAudience);
            this.expectedAudience = new HashSet<String>(expectedAudience);
            return this;
        }
    }
}

