/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.OptionalValidator;
import java.util.List;

public final class UserPrincipalValidator
extends OptionalValidator {
    private UserPrincipalValidator(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return (Builder)((Builder)new Builder().addClaim("upn")).mandatory(true);
    }

    @Override
    public void validate(Jwt object, Errors.Collector collector, List<ClaimValidator> validators) {
        super.validate("User Principal", object.userPrincipal(), collector);
    }

    public static final class Builder
    extends OptionalValidator.BaseBuilder<Builder, UserPrincipalValidator> {
        private Builder() {
        }

        public UserPrincipalValidator build() {
            return new UserPrincipalValidator(this);
        }
    }
}

