/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.InstantValidator;
import io.helidon.security.jwt.Jwt;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public final class NotBeforeValidator
extends InstantValidator {
    private NotBeforeValidator(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return (Builder)new Builder().addClaim("nbf");
    }

    @Override
    public void validate(Jwt token, Errors.Collector collector, List<ClaimValidator> validators) {
        Optional<Instant> notBefore = token.notBefore();
        notBefore.ifPresent(it -> {
            if (this.latest().isBefore((Instant)it)) {
                collector.fatal((Object)token, "Token not yet valid, not before: " + String.valueOf(it));
            }
        });
        super.validate("notBefore", notBefore, collector);
    }

    public static final class Builder
    extends InstantValidator.BaseBuilder<Builder, NotBeforeValidator> {
        private Builder() {
        }

        public NotBeforeValidator build() {
            return new NotBeforeValidator(this);
        }
    }
}

