/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.CommonValidator;
import java.util.Optional;

abstract class OptionalValidator
extends CommonValidator {
    private final boolean mandatory;
    private final String missingClaimMessage;

    OptionalValidator(BaseBuilder<?, ?> builder) {
        super(builder);
        this.mandatory = builder.mandatory;
        this.missingClaimMessage = builder.missingClaimMessage;
    }

    <T> Optional<T> validate(String name, Optional<T> optional, Errors.Collector collector) {
        if (this.mandatory && optional.isEmpty()) {
            Object message = this.missingClaimMessage == null ? "Field " + name + " is mandatory, yet not defined in JWT" : this.missingClaimMessage;
            collector.fatal((String)message);
        }
        return optional;
    }

    static abstract class BaseBuilder<B extends BaseBuilder<B, T>, T>
    extends CommonValidator.BaseBuilder<B, T> {
        private boolean mandatory = false;
        private String missingClaimMessage;

        BaseBuilder() {
        }

        public B mandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return (B)((BaseBuilder)this.me());
        }

        public B missingClaimMessage(String missingClaimMessage) {
            this.missingClaimMessage = missingClaimMessage;
            return (B)((BaseBuilder)this.me());
        }
    }
}

