/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.InstantValidator;
import io.helidon.security.jwt.Jwt;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class MaxTokenAgeValidator
extends InstantValidator {
    private final Duration expectedMaxTokenAge;

    private MaxTokenAgeValidator(Builder builder) {
        super(builder);
        this.expectedMaxTokenAge = builder.expectedMaxTokenAge;
    }

    public static Builder builder() {
        return (Builder)((Builder)new Builder().addClaim("iat")).missingClaimMessage("Claim iat is required to be present in JWT when validating token max allowed age.");
    }

    @Override
    public void validate(Jwt jwt, Errors.Collector collector, List<ClaimValidator> validators) {
        Optional<Instant> maybeIssueTime = jwt.issueTime();
        maybeIssueTime.ifPresent(issueTime -> {
            Instant now = this.instant();
            Instant earliest = this.earliest((Instant)issueTime);
            Instant latest = this.latest(earliest).plus(this.expectedMaxTokenAge);
            if (earliest.isBefore(now) && latest.isAfter(now)) {
                return;
            }
            collector.fatal((Object)jwt, "Current time need to be between " + String.valueOf(earliest) + " and " + String.valueOf(latest) + ", but was " + String.valueOf(now));
        });
        super.validate("iat", maybeIssueTime, collector);
    }

    public static final class Builder
    extends InstantValidator.BaseBuilder<Builder, MaxTokenAgeValidator> {
        private Duration expectedMaxTokenAge = null;

        private Builder() {
        }

        public MaxTokenAgeValidator build() {
            Errors.Collector collector = Errors.collector();
            if (this.expectedMaxTokenAge == null) {
                collector.fatal(this.getClass(), "Expected JWT max token age to be set");
            }
            collector.collect().checkValid();
            return new MaxTokenAgeValidator(this);
        }

        public Builder expectedMaxTokenAge(Duration expectedMaxTokenAge) {
            this.expectedMaxTokenAge = Objects.requireNonNull(expectedMaxTokenAge);
            return this;
        }
    }
}

