/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.security.jwt.OptionalValidator;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

abstract class InstantValidator
extends OptionalValidator {
    private final Instant now;
    private final Duration allowedTimeSkew;

    InstantValidator(BaseBuilder<?, ?> builder) {
        super((OptionalValidator.BaseBuilder<?, ?>)builder);
        this.now = builder.now;
        this.allowedTimeSkew = builder.allowedTimeSkew;
    }

    Instant latest() {
        return this.instant().plus(this.allowedTimeSkew);
    }

    Instant latest(Instant now) {
        return now.plus(this.allowedTimeSkew);
    }

    Instant earliest() {
        return this.instant().minus(this.allowedTimeSkew);
    }

    Instant earliest(Instant now) {
        return now.minus(this.allowedTimeSkew);
    }

    Instant instant() {
        return this.now == null ? Instant.now() : this.now;
    }

    static abstract class BaseBuilder<B extends BaseBuilder<B, T>, T>
    extends OptionalValidator.BaseBuilder<B, T> {
        private Instant now = null;
        private Duration allowedTimeSkew = Duration.ofSeconds(5L);

        BaseBuilder() {
        }

        public B now(Instant now) {
            this.now = Objects.requireNonNull(now);
            return (B)((BaseBuilder)this.me());
        }

        public B allowedTimeSkew(Duration allowedTimeSkew) {
            this.allowedTimeSkew = Objects.requireNonNull(allowedTimeSkew);
            return (B)((BaseBuilder)this.me());
        }
    }
}

