/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt.jwk;

import io.helidon.security.jwt.JwtException;
import io.helidon.security.jwt.JwtUtil;
import io.helidon.security.jwt.jwk.JwkEC;
import io.helidon.security.jwt.jwk.JwkOctet;
import io.helidon.security.jwt.jwk.JwkRSA;
import jakarta.json.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public abstract class Jwk {
    public static final String ALG_NONE = "none";
    public static final String KEY_TYPE_EC = "EC";
    public static final String KEY_TYPE_RSA = "RSA";
    public static final String KEY_TYPE_OCT = "oct";
    public static final String USE_ENCRYPTION = "enc";
    public static final String USE_SIGNATURE = "sig";
    public static final String OPERATION_SIGN = "sign";
    public static final String OPERATION_VERIFY = "verify";
    public static final String OPERATION_ENCRYPT = "encrypt";
    public static final String OPERATION_DECRYPT = "decrypt";
    public static final String OPERATION_WRAP_KEY = "wrapKey";
    public static final String OPERATION_UNWRAP_KEY = "unwrapKey";
    public static final String OPERATION_DERIVE_KEY = "deriveKey";
    public static final String OPERATION_DERIVE_BITS = "deriveBits";
    public static final String PARAM_KEY_TYPE = "kty";
    public static final String PARAM_KEY_ID = "kid";
    public static final String PARAM_ALGORITHM = "alg";
    public static final String PARAM_USE = "use";
    public static final String PARAM_OPERATIONS = "key_ops";
    public static final Jwk NONE_JWK = new NoneJwk();
    static final byte[] EMPTY_BYTES = new byte[0];
    private final String keyType;
    private final String keyId;
    private final String algorithm;
    private final Optional<String> usage;
    private final Optional<List<String>> operations;

    Jwk(Builder<?> builder, String defaultAlgorithm) {
        this.keyId = builder.keyId;
        this.algorithm = Optional.ofNullable(builder.algorithm).orElse(defaultAlgorithm);
        this.keyType = builder.keyType;
        this.usage = Optional.ofNullable(builder.usage);
        this.operations = Optional.ofNullable(builder.operations);
    }

    public static Jwk create(JsonObject json) {
        String keyType;
        switch (keyType = JwtUtil.asString(json, PARAM_KEY_TYPE, "JWK Key type")) {
            case "EC": {
                return JwkEC.create(json);
            }
            case "RSA": {
                return JwkRSA.create(json);
            }
            case "oct": {
                return JwkOctet.create(json);
            }
        }
        throw new JwtException("Unknown JWK type: " + keyType);
    }

    public String keyType() {
        return this.keyType;
    }

    public String keyId() {
        return this.keyId;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public Optional<String> usage() {
        return this.usage;
    }

    public Optional<List<String>> operations() {
        return this.operations;
    }

    public final boolean verifySignature(byte[] signedBytes, byte[] signature) {
        if (this.supports(USE_SIGNATURE, OPERATION_VERIFY)) {
            return this.doVerify(signedBytes, signature);
        }
        throw new JwtException("This key (" + this + ") does not support verification of requests");
    }

    abstract boolean doVerify(byte[] var1, byte[] var2);

    public final byte[] sign(byte[] bytesToSign) {
        if (this.supports(USE_SIGNATURE, OPERATION_SIGN)) {
            return this.doSign(bytesToSign);
        }
        throw new JwtException("This key (" + this + ") does not support signing of requests");
    }

    abstract byte[] doSign(byte[] var1);

    boolean supports(String use, String operation) {
        Boolean result = this.operations.map(ops -> ops.contains(operation)).or(() -> this.usage.map(usage -> usage.equals(use))).orElse(true);
        if (!result.booleanValue() && OPERATION_VERIFY.equals(operation)) {
            return this.supports(use, OPERATION_SIGN);
        }
        return result;
    }

    boolean verifyNoneAlg(byte[] signatureToVerify) {
        return signatureToVerify.length == 0 && ALG_NONE.equals(this.algorithm);
    }

    public String toString() {
        return this.keyId + "(" + this.algorithm + ")";
    }

    static abstract class Builder<T extends Builder<T>> {
        private final T myInstance = this;
        private String keyType;
        private String keyId;
        private String algorithm;
        private String usage;
        private List<String> operations;

        Builder() {
        }

        public T keyType(String keyType) {
            this.keyType = keyType;
            return this.myInstance;
        }

        public T keyId(String keyId) {
            this.keyId = keyId;
            return this.myInstance;
        }

        public T algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this.myInstance;
        }

        public T usage(String usage) {
            this.usage = usage;
            return this.myInstance;
        }

        public T operations(List<String> operations) {
            if (null == this.operations) {
                this.operations = new LinkedList<String>();
            } else {
                this.operations.clear();
            }
            this.operations.addAll(operations);
            return this.myInstance;
        }

        public T addOperation(String operation) {
            if (null == this.operations) {
                this.operations = new LinkedList<String>();
            }
            this.operations.add(operation);
            return this.myInstance;
        }

        T fromJson(JsonObject json) {
            this.keyType(JwtUtil.asString(json, Jwk.PARAM_KEY_TYPE, "JWK Key type"));
            this.keyId(JwtUtil.asString(json, Jwk.PARAM_KEY_ID, "JWK Key id"));
            JwtUtil.getString(json, Jwk.PARAM_ALGORITHM).ifPresent(this::algorithm);
            JwtUtil.getString(json, Jwk.PARAM_USE).ifPresent(this::usage);
            JwtUtil.getStrings(json, Jwk.PARAM_OPERATIONS).ifPresent(this::operations);
            return this.myInstance;
        }
    }

    private static class NoneJwk
    extends Jwk {
        NoneJwk() {
            super((io.helidon.security.jwt.jwk.Jwk$Builder<?>)new Builder().algorithm(Jwk.ALG_NONE), Jwk.ALG_NONE);
        }

        @Override
        public boolean doVerify(byte[] signedBytes, byte[] signature) {
            return signature.length == 0;
        }

        @Override
        public byte[] doSign(byte[] bytesToSign) {
            return EMPTY_BYTES;
        }

        private static class Builder
        extends io.helidon.security.jwt.jwk.Jwk$Builder<Builder> {
            private Builder() {
            }
        }
    }
}

